/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient.cipher;

import com.mindspore.flclient.Common;
import com.mindspore.flclient.cipher.BaseUtil;
import com.mindspore.flclient.common.FLLoggerGenerater;
import java.math.BigInteger;
import java.util.Random;
import java.util.logging.Logger;

public class ShareSecrets {
    private static final Logger LOGGER = FLLoggerGenerater.getModelLogger(ShareSecrets.class.toString());
    private BigInteger prime;
    private final int minNum;
    private final int totalNum;
    private final Random random;

    public ShareSecrets(int minNum, int totalNum) {
        if (minNum <= 0) {
            LOGGER.severe("the argument <k> is not valid: <= 0, it should be > 0");
            throw new IllegalArgumentException();
        }
        if (totalNum <= 0) {
            LOGGER.severe("the argument <n> is not valid: <= 0, it should be > 0");
            throw new IllegalArgumentException();
        }
        if (minNum > totalNum) {
            LOGGER.severe("the argument <k, n> is not valid: k > n, it should k <= n");
            throw new IllegalArgumentException();
        }
        this.minNum = minNum;
        this.totalNum = totalNum;
        this.random = Common.getSecureRandom();
    }

    public SecretShares[] split(byte[] bytes, byte[] primeByte) {
        if (bytes == null || bytes.length == 0) {
            LOGGER.severe("the input argument <bytes> is null");
            return new SecretShares[0];
        }
        if (primeByte == null || primeByte.length == 0) {
            LOGGER.severe("the input argument <primeByte> is null");
            return new SecretShares[0];
        }
        BigInteger secret = BaseUtil.byteArray2BigInteger(bytes);
        int modLength = secret.bitLength() + 1;
        this.prime = BaseUtil.byteArray2BigInteger(primeByte);
        BigInteger[] coefficient = new BigInteger[this.minNum - 1];
        for (int i = 0; i < this.minNum - 1; ++i) {
            coefficient[i] = this.randomZp(this.prime);
        }
        SecretShares[] shares = new SecretShares[this.totalNum];
        for (int i = 1; i <= this.totalNum; ++i) {
            BigInteger accumulate = secret;
            for (int j = 1; j < this.minNum; ++j) {
                BigInteger b1 = BigInteger.valueOf(i).modPow(BigInteger.valueOf(j), this.prime);
                BigInteger b2 = coefficient[j - 1].multiply(b1).mod(this.prime);
                accumulate = accumulate.add(b2).mod(this.prime);
            }
            shares[i - 1] = new SecretShares(i, accumulate);
        }
        return shares;
    }

    public BigInteger combine(SecretShares[] shares, byte[] primeByte) {
        if (shares == null || shares.length == 0) {
            LOGGER.severe("the input argument <shares> is null");
            return BigInteger.ZERO;
        }
        if (primeByte == null || primeByte.length == 0) {
            LOGGER.severe("the input argument <primeByte> is null");
            return BigInteger.ZERO;
        }
        BigInteger primeNum = BaseUtil.byteArray2BigInteger(primeByte);
        BigInteger accumulate = BigInteger.ZERO;
        for (int j = 0; j < this.minNum; ++j) {
            BigInteger tmp;
            BigInteger num = BigInteger.ONE;
            BigInteger den = BigInteger.ONE;
            for (int m = 0; m < this.minNum; ++m) {
                if (j == m) continue;
                num = num.multiply(BigInteger.valueOf(shares[m].getNumber())).mod(primeNum);
                tmp = BigInteger.valueOf(shares[j].getNumber()).multiply(BigInteger.valueOf(-1L));
                tmp = BigInteger.valueOf(shares[m].getNumber()).add(tmp).mod(primeNum);
                den = den.multiply(tmp).mod(primeNum);
            }
            BigInteger value = shares[j].getShares();
            tmp = den.modInverse(primeNum);
            tmp = tmp.multiply(num).mod(primeNum);
            tmp = tmp.multiply(value).mod(primeNum);
            accumulate = accumulate.add(tmp).mod(primeNum);
        }
        return accumulate;
    }

    private BigInteger randomZp(BigInteger num) {
        BigInteger rand;
        while ((rand = new BigInteger(num.bitLength(), this.random)).compareTo(BigInteger.ZERO) <= 0 || rand.compareTo(num) >= 0) {
        }
        return rand;
    }

    public final class SecretShares {
        private final int number;
        private final BigInteger share;

        public SecretShares(int number, BigInteger share) {
            this.number = number;
            this.share = share;
        }

        public int getNumber() {
            return this.number;
        }

        public BigInteger getShares() {
            return this.share;
        }

        public String toString() {
            return "SecretShares [number=" + this.number + ", share=" + this.share + "]";
        }
    }
}

