/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient;

import com.google.flatbuffers.FlatBufferBuilder;
import com.mindspore.flclient.FLClientStatus;
import com.mindspore.flclient.FLParameter;
import com.mindspore.flclient.LocalFLParameter;
import com.mindspore.flclient.ServerMod;
import com.mindspore.flclient.common.FLLoggerGenerater;
import com.mindspore.flclient.compression.DecodeExecutor;
import com.mindspore.flclient.model.Client;
import com.mindspore.flclient.model.ClientManager;
import com.mindspore.flclient.model.RunType;
import com.mindspore.flclient.model.Status;
import java.util.Date;
import java.util.logging.Logger;
import mindspore.fl.schema.CompressFeatureMap;
import mindspore.fl.schema.FeatureMap;
import mindspore.fl.schema.RequestGetModel;
import mindspore.fl.schema.ResponseGetModel;

public class GetModel {
    private static final Logger LOGGER = FLLoggerGenerater.getModelLogger(GetModel.class.toString());
    private static volatile GetModel getModel;
    private FLParameter flParameter = FLParameter.getInstance();
    private LocalFLParameter localFLParameter = LocalFLParameter.getInstance();
    private int retCode = 400;

    private GetModel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GetModel getInstance() {
        GetModel localRef = getModel;
        if (localRef != null) return localRef;
        Class<GetModel> clazz = GetModel.class;
        synchronized (GetModel.class) {
            localRef = getModel;
            if (localRef != null) return localRef;
            getModel = localRef = new GetModel();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return localRef;
        }
    }

    public int getRetCode() {
        return this.retCode;
    }

    public byte[] getRequestGetModel(String name, int iteration) {
        if (name == null || name.isEmpty()) {
            LOGGER.severe("[GetModel] the input parameter of <name> is null or empty, please check!");
            throw new IllegalArgumentException();
        }
        RequestGetModelBuilder builder = new RequestGetModelBuilder();
        return builder.iteration(iteration).flName(name).time().downloadCompressTypesBuilder(this.flParameter.getDownloadCompressTypes()).build();
    }

    private FeatureGenerator FeatureGeneratorCtr(ResponseGetModel responseDataBuf) {
        byte compressType = responseDataBuf.downloadCompressType();
        switch (compressType) {
            case 0: {
                LOGGER.info("[FeatureGeneratorCtr] Compress type:" + compressType);
                return new NormalFeatureGenerator(responseDataBuf);
            }
            case 2: {
                LOGGER.info("[FeatureGeneratorCtr] Compress type:" + compressType);
                return new QuatFeatureGenerator(responseDataBuf);
            }
        }
        LOGGER.severe("[FeatureGeneratorCtr] Unsupported compress type:" + compressType);
        return null;
    }

    private FLClientStatus parseResponseFeatures(ResponseGetModel responseDataBuf) {
        Client client = ClientManager.getClient(this.flParameter.getFlName());
        FeatureGenerator featureGenerator = this.FeatureGeneratorCtr(responseDataBuf);
        if (this.localFLParameter.getServerMod().equals(ServerMod.HYBRID_TRAINING.toString())) {
            return this.updateFeatureForHybrid(client, featureGenerator);
        }
        if (this.localFLParameter.getServerMod().equals(ServerMod.FEDERATED_LEARNING.toString())) {
            String trainModelPath = this.flParameter.getTrainModelPath();
            String inferModelPath = this.flParameter.getInferModelPath();
            if (!inferModelPath.equals("null") && !inferModelPath.equals(trainModelPath)) {
                return this.updateFeatureForHybrid(client, featureGenerator);
            }
            return this.updateFeatureForFederated(client, featureGenerator);
        }
        LOGGER.severe("[parseResponseFeatures] Unsupported ServerMod:" + this.localFLParameter.getServerMod());
        return FLClientStatus.FAILED;
    }

    private FLClientStatus updateFeatureForFederated(Client client, FeatureGenerator featureGenerator) {
        FLClientStatus result = FLClientStatus.SUCCESS;
        Status status = Status.SUCCESS;
        while (!featureGenerator.isEnd()) {
            FeatureMap featureMap = featureGenerator.next();
            status = client.updateFeature(featureMap, true);
            if (status == Status.SUCCESS) continue;
            LOGGER.severe("[updateFeatureForFederated] Update feature failed.");
            break;
        }
        return status == Status.SUCCESS ? FLClientStatus.SUCCESS : FLClientStatus.FAILED;
    }

    private FLClientStatus updateFeatureForHybrid(Client client, FeatureGenerator featureGenerator) {
        FLClientStatus result = FLClientStatus.SUCCESS;
        Status status = Status.SUCCESS;
        while (!featureGenerator.isEnd()) {
            FeatureMap featureMap = featureGenerator.next();
            if (this.flParameter.getHybridWeightName(RunType.TRAINMODE).contains(featureMap.weightFullname())) {
                status = client.updateFeature(featureMap, true);
            }
            if (status != Status.SUCCESS) {
                LOGGER.severe("[updateFeatureForFederated] Update feature failed.");
                break;
            }
            if (this.flParameter.getHybridWeightName(RunType.INFERMODE).contains(featureMap.weightFullname())) {
                status = client.updateFeature(featureMap, false);
            }
            if (status == Status.SUCCESS) continue;
            LOGGER.severe("[updateFeatureForFederated] Update feature failed.");
            break;
        }
        return status == Status.SUCCESS ? FLClientStatus.SUCCESS : FLClientStatus.FAILED;
    }

    public FLClientStatus doResponse(ResponseGetModel responseDataBuf) {
        this.retCode = responseDataBuf.retcode();
        LOGGER.info("[getModel] ==========the response message of getModel is:================");
        LOGGER.info("[getModel] ==========retCode: " + this.retCode);
        LOGGER.info("[getModel] ==========reason: " + responseDataBuf.reason());
        LOGGER.info("[getModel] ==========iteration: " + responseDataBuf.iteration());
        LOGGER.info("[getModel] ==========time: " + responseDataBuf.timestamp());
        FLClientStatus status = FLClientStatus.SUCCESS;
        switch (responseDataBuf.retcode()) {
            case 200: {
                LOGGER.info("[getModel] into <parseResponseFeatures>");
                status = this.parseResponseFeatures(responseDataBuf);
                return status;
            }
            case 201: {
                LOGGER.info("[getModel] server is not ready now: need wait and request getModel again");
                return FLClientStatus.WAIT;
            }
            case 300: {
                LOGGER.info("[getModel] out of time: need wait and request startFLJob again");
                return FLClientStatus.RESTART;
            }
            case 400: 
            case 500: {
                LOGGER.warning("[getModel] catch RequestError or SystemError");
                return FLClientStatus.FAILED;
            }
        }
        LOGGER.severe("[getModel] the return <retCode> from server is invalid: " + this.retCode);
        return FLClientStatus.FAILED;
    }

    static {
        System.loadLibrary("mindspore-lite-jni");
    }

    class RequestGetModelBuilder {
        private FlatBufferBuilder builder = new FlatBufferBuilder();
        private int nameOffset = 0;
        private int iteration = 0;
        private int timeStampOffset = 0;
        private int downloadCompressTypesOffset = 0;

        private RequestGetModelBuilder flName(String name) {
            if (name == null || name.isEmpty()) {
                LOGGER.severe("[GetModel] the input parameter of <name> is null or empty, please check!");
                throw new IllegalArgumentException();
            }
            this.nameOffset = this.builder.createString((CharSequence)name);
            return this;
        }

        private RequestGetModelBuilder time() {
            Date date = new Date();
            long time = date.getTime();
            this.timeStampOffset = this.builder.createString((CharSequence)String.valueOf(time));
            return this;
        }

        private RequestGetModelBuilder iteration(int iteration) {
            this.iteration = iteration;
            return this;
        }

        private RequestGetModelBuilder downloadCompressTypesBuilder(byte[] downloadCompressTypes) {
            if (downloadCompressTypes == null || downloadCompressTypes.length == 0) {
                LOGGER.severe("[GetModel] the parameter of <downloadCompressTypes> is null or empty, please check!");
                throw new IllegalArgumentException();
            }
            this.downloadCompressTypesOffset = RequestGetModel.createDownloadCompressTypesVector(this.builder, downloadCompressTypes);
            return this;
        }

        private byte[] build() {
            RequestGetModel.startRequestGetModel(this.builder);
            RequestGetModel.addFlName(this.builder, this.nameOffset);
            RequestGetModel.addIteration(this.builder, this.iteration);
            RequestGetModel.addTimestamp(this.builder, this.timeStampOffset);
            RequestGetModel.addDownloadCompressTypes(this.builder, this.downloadCompressTypesOffset);
            int root = RequestGetModel.endRequestGetModel(this.builder);
            this.builder.finish(root);
            return this.builder.sizedByteArray();
        }
    }

    class QuatFeatureGenerator
    extends FeatureGenerator {
        public QuatFeatureGenerator(ResponseGetModel responseDataBuf) {
            super(responseDataBuf);
            this.size = responseDataBuf.compressFeatureMapLength();
        }

        @Override
        public FeatureMap next() {
            if (this.curPos >= this.size) {
                return null;
            }
            int pre = this.curPos++;
            CompressFeatureMap cmpfeatureMap = this.responseDataBuf.compressFeatureMap(pre);
            return DecodeExecutor.quantDeCompress(cmpfeatureMap);
        }
    }

    class NormalFeatureGenerator
    extends FeatureGenerator {
        public NormalFeatureGenerator(ResponseGetModel responseDataBuf) {
            super(responseDataBuf);
            this.size = responseDataBuf.featureMapLength();
        }

        @Override
        public FeatureMap next() {
            if (this.curPos >= this.size) {
                return null;
            }
            int pre = this.curPos++;
            return this.responseDataBuf.featureMap(pre);
        }
    }

    abstract class FeatureGenerator {
        protected ResponseGetModel responseDataBuf;
        protected int curPos = 0;
        protected int size = 0;

        public FeatureGenerator(ResponseGetModel responseDataBuf) {
            this.responseDataBuf = responseDataBuf;
        }

        public abstract FeatureMap next();

        public boolean isEnd() {
            return this.curPos >= this.size;
        }
    }
}

