/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient.model;

import com.mindspore.MSTensor;
import com.mindspore.flclient.common.FLLoggerGenerater;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class CommonUtils {
    private static final Logger logger = FLLoggerGenerater.getModelLogger(CommonUtils.class.toString());

    public static int getMaxScoreIndex(float[] scores, int start, int end) {
        if (scores == null || scores.length == 0) {
            logger.severe("scores cannot be empty");
            return -1;
        }
        if (start >= scores.length || start < 0 || end > scores.length || end < 0) {
            logger.severe("start,end cannot out of scores length");
            return -1;
        }
        float maxScore = scores[start];
        int maxIdx = start;
        for (int i = start; i < end; ++i) {
            if (!(scores[i] > maxScore)) continue;
            maxIdx = i;
            maxScore = scores[i];
        }
        return maxIdx - start;
    }

    public static Map<String, float[]> convertTensorToFeatures(List<MSTensor> tensors) {
        if (tensors == null) {
            logger.severe("tensors cannot be null");
            return new HashMap<String, float[]>();
        }
        HashMap<String, float[]> features = new HashMap<String, float[]>(tensors.size());
        for (MSTensor mstensor : tensors) {
            if (mstensor == null) {
                logger.severe("tensors cannot be null");
                return new HashMap<String, float[]>();
            }
            features.put(mstensor.tensorName(), mstensor.getFloatData());
        }
        return features;
    }
}

