/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient.cipher;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class BaseUtil {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String byte2HexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return "";
        }
        char[] chars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            byte byteNum = bytes[i];
            chars[i * 2] = HEX_DIGITS[(byteNum & 0xF0) >> 4];
            chars[i * 2 + 1] = HEX_DIGITS[byteNum & 0xF];
        }
        return new String(chars);
    }

    public static byte[] hexString2ByteArray(String str) {
        int length = str.length() / 2;
        byte[] bytes = new byte[length];
        byte[] source2 = str.getBytes(Charset.forName("UTF-8"));
        for (int i = 0; i < bytes.length; ++i) {
            byte bh = Byte.decode("0x" + new String(new byte[]{source2[i * 2]}, Charset.forName("UTF-8")));
            bh = (byte)(bh << 4);
            byte bl = Byte.decode("0x" + new String(new byte[]{source2[i * 2 + 1]}, Charset.forName("UTF-8")));
            bytes[i] = (byte)(bh ^ bl);
        }
        return bytes;
    }

    public static BigInteger byteArray2BigInteger(byte[] bytes) {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 0; i < bytes.length; ++i) {
            int intI = bytes[i];
            if (intI < 0) {
                intI += 256;
            }
            BigInteger bi = new BigInteger(String.valueOf(intI));
            bigInteger = bigInteger.multiply(BigInteger.valueOf(256L)).add(bi);
        }
        return bigInteger;
    }

    public static BigInteger string2BigInteger(String str) throws UnsupportedEncodingException {
        StringBuilder res = new StringBuilder();
        byte[] bytes = String.valueOf(str).getBytes("UTF-8");
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 0; i < str.length(); ++i) {
            BigInteger bi = new BigInteger(String.valueOf(bytes[i]));
            bigInteger = bigInteger.multiply(BigInteger.valueOf(256L)).add(bi);
        }
        return bigInteger;
    }

    public static String bigInteger2String(BigInteger bigInteger) {
        StringBuilder res = new StringBuilder();
        ArrayList<Integer> lists = new ArrayList<Integer>();
        BigInteger bi = bigInteger;
        BigInteger div = BigInteger.valueOf(256L);
        while (bi.compareTo(BigInteger.ZERO) > 0) {
            lists.add(bi.mod(div).intValue());
            bi = bi.divide(div);
        }
        for (int i = lists.size() - 1; i >= 0; --i) {
            res.append((char)((Integer)lists.get(i)).intValue());
        }
        return res.toString();
    }

    public static byte[] bigInteger2byteArray(BigInteger bigInteger) {
        ArrayList<Integer> lists = new ArrayList<Integer>();
        BigInteger bi = bigInteger;
        BigInteger div = BigInteger.valueOf(256L);
        while (bi.compareTo(BigInteger.ZERO) > 0) {
            lists.add(bi.mod(div).intValue());
            bi = bi.divide(div);
        }
        byte[] res = new byte[lists.size()];
        for (int i = lists.size() - 1; i >= 0; --i) {
            res[lists.size() - i - 1] = (byte)((Integer)lists.get(i)).intValue();
        }
        return res;
    }

    public static byte[] integer2byteArray(Integer num) {
        ArrayList<Integer> lists = new ArrayList<Integer>();
        Integer bi = num;
        Integer div = 256;
        while (bi > 0) {
            lists.add(bi % div);
            bi = bi / div;
        }
        byte[] res = new byte[lists.size()];
        for (int i = lists.size() - 1; i >= 0; --i) {
            res[lists.size() - i - 1] = (byte)((Integer)lists.get(i)).intValue();
        }
        return res;
    }

    public static Integer byteArray2Integer(byte[] bytes) {
        Integer num = 0;
        for (int i = 0; i < bytes.length; ++i) {
            int intI = bytes[i];
            if (intI < 0) {
                intI += 256;
            }
            num = num * 256 + intI;
        }
        return num;
    }
}

