/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient.compression;

import com.google.flatbuffers.FlatBufferBuilder;
import com.mindspore.flclient.common.FLLoggerGenerater;
import com.mindspore.flclient.compression.CompressMode;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import mindspore.fl.schema.CompressFeatureMap;
import mindspore.fl.schema.CompressType;
import mindspore.fl.schema.FeatureMap;

public class DecodeExecutor {
    private static final Logger LOGGER = FLLoggerGenerater.getModelLogger(DecodeExecutor.class.toString());

    public static List<FeatureMap> deCompressWeight(byte compressType, List<CompressFeatureMap> compressFeatureMapList) {
        if (!CompressMode.COMPRESS_TYPE_MAP.containsKey(compressType)) {
            return new ArrayList<FeatureMap>();
        }
        LOGGER.info("[deCompressWeight] create " + CompressType.name(compressType) + " feature map.");
        int num_bits = CompressMode.COMPRESS_TYPE_MAP.get(compressType);
        if (compressType == 2) {
            return DecodeExecutor.deCompressQuantMinMax(compressFeatureMapList, num_bits);
        }
        return new ArrayList<FeatureMap>();
    }

    private static List<FeatureMap> deCompressQuantMinMax(List<CompressFeatureMap> compressFeatureMapList, int num_bits) {
        float temp1 = (float)(Math.pow(2.0, num_bits) - 1.0);
        float temp2 = (float)Math.pow(2.0, num_bits - 1);
        HashMap<String, float[]> deCompressFeatureMaps = new HashMap<String, float[]>();
        int compressFeatureMapLength = compressFeatureMapList.size();
        for (int i = 0; i < compressFeatureMapLength; ++i) {
            CompressFeatureMap compressFeatureMap = compressFeatureMapList.get(i);
            String weightName = compressFeatureMap.weightFullname();
            int compressDataLength = compressFeatureMap.compressDataLength();
            ArrayList<Byte> compressWeightList = new ArrayList<Byte>();
            for (int j = 0; j < compressDataLength; ++j) {
                compressWeightList.add(compressFeatureMap.compressData(j));
            }
            float minVal = compressFeatureMap.minVal();
            float maxVal = compressFeatureMap.maxVal();
            float scale_value = (float)((double)((maxVal - minVal) / temp1) + 1.0E-10);
            float[] params = new float[compressWeightList.size()];
            for (int j = 0; j < params.length; ++j) {
                float val;
                params[j] = val = ((float)((Byte)compressWeightList.get(j)).intValue() + temp2) * scale_value + minVal;
            }
            deCompressFeatureMaps.put(weightName, params);
        }
        ArrayList<FeatureMap> featureMaps = new ArrayList<FeatureMap>();
        for (String weightName : deCompressFeatureMaps.keySet()) {
            FlatBufferBuilder builder = new FlatBufferBuilder(0);
            int weightFullnameOffset = builder.createString(weightName);
            float[] data = (float[])deCompressFeatureMaps.get(weightName);
            int dataOffset = FeatureMap.createDataVector(builder, data);
            FeatureMap.startFeatureMap(builder);
            FeatureMap.addWeightFullname(builder, weightFullnameOffset);
            FeatureMap.addData(builder, dataOffset);
            int orc = FeatureMap.endFeatureMap(builder);
            builder.finish(orc);
            ByteBuffer buf = builder.dataBuffer();
            FeatureMap featureMap = FeatureMap.getRootAsFeatureMap(buf);
            featureMaps.add(featureMap);
        }
        return featureMaps;
    }

    public static FeatureMap quantDeCompress(CompressFeatureMap compressFeature) {
        int num_bits = CompressMode.COMPRESS_TYPE_MAP.get((byte)2);
        float temp1 = (float)(Math.pow(2.0, num_bits) - 1.0);
        float temp2 = (float)Math.pow(2.0, num_bits - 1);
        String weightName = compressFeature.weightFullname();
        int compressDataLength = compressFeature.compressDataLength();
        ArrayList<Byte> compressWeightList = new ArrayList<Byte>();
        for (int j = 0; j < compressDataLength; ++j) {
            compressWeightList.add(compressFeature.compressData(j));
        }
        float minVal = compressFeature.minVal();
        float maxVal = compressFeature.maxVal();
        float scale_value = (float)((double)((maxVal - minVal) / temp1) + 1.0E-10);
        float[] params = new float[compressWeightList.size()];
        for (int j = 0; j < params.length; ++j) {
            float val;
            params[j] = val = ((float)((Byte)compressWeightList.get(j)).intValue() + temp2) * scale_value + minVal;
        }
        FlatBufferBuilder builder = new FlatBufferBuilder(0);
        int weightFullnameOffset = builder.createString(weightName);
        int dataOffset = FeatureMap.createDataVector(builder, params);
        FeatureMap.startFeatureMap(builder);
        FeatureMap.addWeightFullname(builder, weightFullnameOffset);
        FeatureMap.addData(builder, dataOffset);
        int orc = FeatureMap.endFeatureMap(builder);
        builder.finish(orc);
        ByteBuffer buf = builder.dataBuffer();
        FeatureMap featureMap = FeatureMap.getRootAsFeatureMap(buf);
        return featureMap;
    }
}

