/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.config;

import com.mindspore.config.MindsporeLite;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MSContext {
    private static final Logger LOGGER = Logger.getLogger(MSContext.class.toString());
    private long msContextPtr = 0L;
    private static final long EMPTY_CONTEXT_PTR_VALUE = 0L;
    private static final int ERROR_VALUE = -1;
    private static final String NULLPTR_ERROR_MESSAGE = "msContext is a nullptr.\n";

    public boolean addDeviceInfo(int deviceType, boolean isEnableFloat16, int npuFreq) {
        return this.addDeviceInfo(this.msContextPtr, deviceType, isEnableFloat16, npuFreq);
    }

    public boolean addDeviceInfo(int deviceType, boolean isEnableFloat16) {
        return this.addDeviceInfo(this.msContextPtr, deviceType, isEnableFloat16, 3);
    }

    public boolean init() {
        this.msContextPtr = this.createDefaultMSContext();
        return this.msContextPtr != 0L;
    }

    public boolean init(int threadNum, int cpuBindMode) {
        this.msContextPtr = this.createMSContext(threadNum, cpuBindMode, false);
        return this.msContextPtr != 0L;
    }

    public boolean init(int threadNum, int cpuBindMode, boolean isEnableParallel) {
        this.msContextPtr = this.createMSContext(threadNum, cpuBindMode, isEnableParallel);
        return this.msContextPtr != 0L;
    }

    public void free() {
        if (this.isInitialized()) {
            this.free(this.msContextPtr);
        } else {
            LOGGER.log(Level.SEVERE, NULLPTR_ERROR_MESSAGE);
        }
    }

    public long getMSContextPtr() {
        return this.msContextPtr;
    }

    private boolean isInitialized() {
        return this.msContextPtr != 0L;
    }

    public void setThreadNum(int threadNum) {
        if (this.isInitialized()) {
            this.setThreadNum(this.msContextPtr, threadNum);
        } else {
            LOGGER.log(Level.SEVERE, NULLPTR_ERROR_MESSAGE);
        }
    }

    public int getThreadNum() {
        int ret_val = -1;
        if (this.isInitialized()) {
            ret_val = this.getThreadNum(this.msContextPtr);
        } else {
            LOGGER.log(Level.SEVERE, NULLPTR_ERROR_MESSAGE);
        }
        return ret_val;
    }

    public void setInterOpParallelNum(int parallelNum) {
        if (this.isInitialized()) {
            this.setInterOpParallelNum(this.msContextPtr, parallelNum);
        } else {
            LOGGER.log(Level.SEVERE, NULLPTR_ERROR_MESSAGE);
        }
    }

    public int getInterOpParallelNum() {
        int ret_val = -1;
        if (this.isInitialized()) {
            ret_val = this.getInterOpParallelNum(this.msContextPtr);
        } else {
            LOGGER.log(Level.SEVERE, NULLPTR_ERROR_MESSAGE);
        }
        return ret_val;
    }

    public void setThreadAffinity(int mode) {
        if (this.isInitialized()) {
            this.setThreadAffinity(this.msContextPtr, mode);
        } else {
            LOGGER.log(Level.SEVERE, NULLPTR_ERROR_MESSAGE);
        }
    }

    public int getThreadAffinityMode() {
        int ret_val = -1;
        if (this.isInitialized()) {
            ret_val = this.getThreadAffinityMode(this.msContextPtr);
        } else {
            LOGGER.log(Level.SEVERE, NULLPTR_ERROR_MESSAGE);
        }
        return ret_val;
    }

    public void setThreadAffinity(ArrayList<Integer> coreList) {
        if (this.isInitialized()) {
            int len = coreList.size();
            int[] coreList_array = new int[len];
            for (int i = 0; i < len; ++i) {
                coreList_array[i] = coreList.get(i);
            }
            this.setThreadAffinity(this.msContextPtr, coreList_array);
        } else {
            LOGGER.log(Level.SEVERE, NULLPTR_ERROR_MESSAGE);
        }
    }

    public ArrayList<Integer> getThreadAffinityCoreList() {
        ArrayList<Integer> ret_val = new ArrayList();
        if (this.isInitialized()) {
            ret_val = this.getThreadAffinityCoreList(this.msContextPtr);
        } else {
            LOGGER.log(Level.SEVERE, NULLPTR_ERROR_MESSAGE);
        }
        return ret_val;
    }

    public void setEnableParallel(boolean isParallel) {
        if (this.isInitialized()) {
            this.setEnableParallel(this.msContextPtr, isParallel);
        } else {
            LOGGER.log(Level.SEVERE, NULLPTR_ERROR_MESSAGE);
        }
    }

    public boolean getEnableParallel() {
        boolean ret_val = false;
        if (this.isInitialized()) {
            ret_val = this.getEnableParallel(this.msContextPtr);
        } else {
            LOGGER.log(Level.SEVERE, NULLPTR_ERROR_MESSAGE);
        }
        return ret_val;
    }

    private native long createMSContext(int var1, int var2, boolean var3);

    private native long createDefaultMSContext();

    private native boolean addDeviceInfo(long var1, int var3, boolean var4, int var5);

    private native void free(long var1);

    private native void setThreadNum(long var1, int var3);

    private native int getThreadNum(long var1);

    private native void setInterOpParallelNum(long var1, int var3);

    private native int getInterOpParallelNum(long var1);

    private native void setThreadAffinity(long var1, int var3);

    private native int getThreadAffinityMode(long var1);

    private native void setThreadAffinity(long var1, int[] var3);

    private native ArrayList<Integer> getThreadAffinityCoreList(long var1);

    private native void setEnableParallel(long var1, boolean var3);

    private native boolean getEnableParallel(long var1);

    static {
        MindsporeLite.init();
    }
}

