/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.config;

import com.mindspore.config.Version;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class NativeLibrary {
    private static final Logger LOGGER = Logger.getLogger(NativeLibrary.class.toString());
    private static final String GLOG_LIBNAME = "mindspore_glog";
    private static final String JPEG_LIBNAME = "jpeg";
    private static final String TURBOJPEG_LIBNAME = "turbojpeg";
    private static final String MINDDATA_LITE_LIBNAME = "minddata-lite";
    private static final String MINDSPORE_LITE_LIBNAME = "mindspore-lite";
    private static final String MINDSPORE_LITE_JNI_LIBNAME = "mindspore-lite-jni";
    private static final String MINDSPORE_LITE_TRAIN_LIBNAME = "mindspore-lite-train";
    private static final String MINDSPORE_LITE_TRAIN_JNI_LIBNAME = "mindspore-lite-train-jni";

    public static void load() {
        if (NativeLibrary.isLibLoaded() || NativeLibrary.loadLibrary()) {
            LOGGER.info("Native lib has been loaded.");
            return;
        }
        NativeLibrary.loadLibs();
    }

    public static void loadLibs() {
        NativeLibrary.loadLib(NativeLibrary.makeResourceName("libmindspore_glog.so"));
        NativeLibrary.loadLib(NativeLibrary.makeResourceName("libjpeg.so"));
        NativeLibrary.loadLib(NativeLibrary.makeResourceName("libturbojpeg.so"));
        NativeLibrary.loadLib(NativeLibrary.makeResourceName("libminddata-lite.so"));
        NativeLibrary.loadLib(NativeLibrary.makeResourceName("libmindspore-lite.so"));
        NativeLibrary.loadLib(NativeLibrary.makeResourceName("libmindspore-lite-jni.so"));
        NativeLibrary.loadLib(NativeLibrary.makeResourceName("libmindspore-lite-train.so"));
        NativeLibrary.loadLib(NativeLibrary.makeResourceName("libmindspore-lite-train-jni.so"));
    }

    private static boolean isLibLoaded() {
        try {
            Version.version();
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
        return true;
    }

    private static boolean loadLibrary() {
        boolean loadSuccess = false;
        try {
            System.loadLibrary(MINDSPORE_LITE_JNI_LIBNAME);
            loadSuccess = true;
            LOGGER.info("loadLibrary mindspore-lite-jni: success");
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.info("tryLoadLibrary mindspore-lite-jni failed.");
        }
        try {
            System.loadLibrary(MINDSPORE_LITE_TRAIN_JNI_LIBNAME);
            loadSuccess = true;
            LOGGER.info("loadLibrary mindspore-lite-train-jni: success.");
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.info("tryLoadLibrary mindspore-lite-train-jni failed.");
        }
        return loadSuccess;
    }

    private static void loadLib(String libResourceName) {
        LOGGER.info("start load libResourceName: " + libResourceName);
        InputStream libResource = NativeLibrary.class.getClassLoader().getResourceAsStream(libResourceName);
        if (libResource == null) {
            LOGGER.warning(String.format("lib file: %s not exist.", libResourceName));
            return;
        }
        try {
            File tmpDir = NativeLibrary.mkTmpDir();
            String libName = libResourceName.substring(libResourceName.lastIndexOf("/") + 1);
            tmpDir.deleteOnExit();
            File tmpFile = new File(tmpDir.getCanonicalPath(), libName);
            tmpFile.deleteOnExit();
            LOGGER.info(String.format("extract %d bytes to %s", NativeLibrary.copyLib(libResource, tmpFile), tmpFile));
            System.load(tmpFile.toString());
        }
        catch (IOException e) {
            throw new UnsatisfiedLinkError(String.format("extract library into tmp file (%s) failed.", e.toString()));
        }
    }

    /*
     * Loose catch block
     */
    private static long copyLib(InputStream libResource, File tmpFile) throws IOException {
        try {
            try (FileOutputStream outputStream = new FileOutputStream(tmpFile);){
                byte[] buffer = new byte[0x100000];
                long byteCnt = 0L;
                int n = 0;
                while ((n = libResource.read(buffer)) >= 0) {
                    outputStream.write(buffer, 0, n);
                    byteCnt += (long)n;
                }
                long l = byteCnt;
                return l;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            libResource.close();
        }
    }

    private static File mkTmpDir() {
        String MINDSPORE_LITE_LIBS = "mindspore_lite_libs-";
        Long timestamp = System.currentTimeMillis();
        String dirName = "mindspore_lite_libs-" + timestamp + "-";
        for (int i = 0; i < 10; ++i) {
            File tmpDir = new File(new File(System.getProperty("java.io.tmpdir")), dirName + i);
            if (!tmpDir.mkdir()) continue;
            return tmpDir;
        }
        throw new IllegalStateException("create tmp dir failed, dirName: " + dirName);
    }

    private static String makeResourceName(String basename) {
        return "com/mindspore/lite/" + String.format("linux_%s/", NativeLibrary.architecture()) + basename;
    }

    private static String architecture() {
        String arch = System.getProperty("os.arch").toLowerCase();
        return arch.equals("amd64") ? "x86_64" : arch;
    }
}

