/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient.compression;

import com.mindspore.flclient.LocalFLParameter;
import com.mindspore.flclient.compression.CompressWeight;

public class EncodeExecutor {
    private final LocalFLParameter localFLParameter = LocalFLParameter.getInstance();
    private static volatile EncodeExecutor encodeExecutor;
    private static final int multiplier = Integer.MAX_VALUE;
    private static final double increment = 4.294967294E9;
    private static final int modulo = 48271;

    private EncodeExecutor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EncodeExecutor getInstance() {
        if (encodeExecutor != null) return encodeExecutor;
        Class<EncodeExecutor> clazz = EncodeExecutor.class;
        synchronized (EncodeExecutor.class) {
            if (encodeExecutor != null) return encodeExecutor;
            encodeExecutor = new EncodeExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return encodeExecutor;
        }
    }

    public boolean[] constructMaskArray(int paramNum) {
        int i;
        int seed = this.localFLParameter.getSeed();
        float uploadSparseRatio = this.localFLParameter.getUploadSparseRatio();
        boolean[] maskArray = new boolean[paramNum];
        int retain_num = (int)((float)paramNum * uploadSparseRatio);
        for (i = 0; i < retain_num; ++i) {
            maskArray[i] = true;
        }
        for (i = retain_num; i < paramNum; ++i) {
            maskArray[i] = false;
        }
        seed = (seed + Integer.MAX_VALUE) * 48271 % Integer.MAX_VALUE;
        for (i = 0; i < paramNum; ++i) {
            double rand = (double)seed / 4.294967294E9 + 0.5;
            seed = seed * 48271 % Integer.MAX_VALUE;
            int j = (int)(rand * (double)(paramNum - i)) + i;
            boolean temp = maskArray[i];
            maskArray[i] = maskArray[j];
            maskArray[j] = temp;
        }
        return maskArray;
    }

    public static CompressWeight enDiffSparseQuantData(String featureName, float[] feature, float[] dataBeforeTrain, int numBits, int trainDataSize, boolean[] maskArray, int maskPos) {
        if (feature.length != dataBeforeTrain.length) {
            throw new RuntimeException("The featurn len is not same after train, before train length is:" + dataBeforeTrain.length + " after trian length is :" + feature.length);
        }
        float[] diffs = new float[dataBeforeTrain.length];
        int length = dataBeforeTrain.length;
        for (int i = 0; i < length; ++i) {
            diffs[i] = feature[i] - dataBeforeTrain[i] * (float)trainDataSize;
        }
        float[] sparseFeatureMap = new float[dataBeforeTrain.length];
        int sparseSize = 0;
        for (float dataValue : diffs) {
            if (maskArray[maskPos]) {
                sparseFeatureMap[sparseSize] = dataValue;
                ++sparseSize;
            }
            ++maskPos;
        }
        float temp1 = (float)(1 << numBits) - 1.0f;
        float temp2 = 1 << numBits - 1;
        CompressWeight compressWeight = new CompressWeight();
        compressWeight.setWeightFullname(featureName);
        float minVal = Float.MAX_VALUE;
        float maxVal = -minVal;
        for (int i = 0; i < sparseSize; ++i) {
            if (sparseFeatureMap[i] < minVal) {
                minVal = sparseFeatureMap[i];
            }
            if (!(sparseFeatureMap[i] > maxVal)) continue;
            maxVal = sparseFeatureMap[i];
        }
        compressWeight.setMinValue(minVal);
        compressWeight.setMaxValue(maxVal);
        float scale_value = (maxVal - minVal) / temp1 + 1.0E-10f;
        byte[] compressData = new byte[sparseSize];
        for (int i = 0; i < sparseSize; ++i) {
            compressData[i] = (byte)Math.round((sparseFeatureMap[i] - minVal) / scale_value - temp2);
        }
        compressWeight.setCompressData(compressData);
        return compressWeight;
    }
}

