/*
 * Decompiled with CFR 0.152.
 */
package mindspore.fl.schema;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import mindspore.fl.schema.CompressFeatureMap;
import mindspore.fl.schema.FLPlan;
import mindspore.fl.schema.FeatureMap;

public final class ResponseFLJob
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_2_0_0();
    }

    public static ResponseFLJob getRootAsResponseFLJob(ByteBuffer _bb) {
        return ResponseFLJob.getRootAsResponseFLJob(_bb, new ResponseFLJob());
    }

    public static ResponseFLJob getRootAsResponseFLJob(ByteBuffer _bb, ResponseFLJob obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public ResponseFLJob __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public int retcode() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public boolean mutateRetcode(int retcode) {
        int o = this.__offset(4);
        if (o != 0) {
            this.bb.putInt(o + this.bb_pos, retcode);
            return true;
        }
        return false;
    }

    public String reason() {
        int o = this.__offset(6);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer reasonAsByteBuffer() {
        return this.__vector_as_bytebuffer(6, 1);
    }

    public ByteBuffer reasonInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 6, 1);
    }

    public int iteration() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public boolean mutateIteration(int iteration) {
        int o = this.__offset(8);
        if (o != 0) {
            this.bb.putInt(o + this.bb_pos, iteration);
            return true;
        }
        return false;
    }

    public boolean isSelected() {
        int o = this.__offset(10);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public boolean mutateIsSelected(boolean is_selected) {
        int o = this.__offset(10);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, (byte)(is_selected ? 1 : 0));
            return true;
        }
        return false;
    }

    public String nextReqTime() {
        int o = this.__offset(12);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer nextReqTimeAsByteBuffer() {
        return this.__vector_as_bytebuffer(12, 1);
    }

    public ByteBuffer nextReqTimeInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 12, 1);
    }

    public FLPlan flPlanConfig() {
        return this.flPlanConfig(new FLPlan());
    }

    public FLPlan flPlanConfig(FLPlan obj) {
        int o = this.__offset(14);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public FeatureMap featureMap(int j) {
        return this.featureMap(new FeatureMap(), j);
    }

    public FeatureMap featureMap(FeatureMap obj, int j) {
        int o = this.__offset(16);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int featureMapLength() {
        int o = this.__offset(16);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public FeatureMap.Vector featureMapVector() {
        return this.featureMapVector(new FeatureMap.Vector());
    }

    public FeatureMap.Vector featureMapVector(FeatureMap.Vector obj) {
        int o = this.__offset(16);
        return o != 0 ? obj.__assign(this.__vector(o), 4, this.bb) : null;
    }

    public String timestamp() {
        int o = this.__offset(18);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer timestampAsByteBuffer() {
        return this.__vector_as_bytebuffer(18, 1);
    }

    public ByteBuffer timestampInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 18, 1);
    }

    public byte uploadCompressType() {
        int o = this.__offset(20);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public boolean mutateUploadCompressType(byte upload_compress_type) {
        int o = this.__offset(20);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, upload_compress_type);
            return true;
        }
        return false;
    }

    public float uploadSparseRate() {
        int o = this.__offset(22);
        return o != 0 ? this.bb.getFloat(o + this.bb_pos) : 0.0f;
    }

    public boolean mutateUploadSparseRate(float upload_sparse_rate) {
        int o = this.__offset(22);
        if (o != 0) {
            this.bb.putFloat(o + this.bb_pos, upload_sparse_rate);
            return true;
        }
        return false;
    }

    public byte downloadCompressType() {
        int o = this.__offset(24);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public boolean mutateDownloadCompressType(byte download_compress_type) {
        int o = this.__offset(24);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, download_compress_type);
            return true;
        }
        return false;
    }

    public CompressFeatureMap compressFeatureMap(int j) {
        return this.compressFeatureMap(new CompressFeatureMap(), j);
    }

    public CompressFeatureMap compressFeatureMap(CompressFeatureMap obj, int j) {
        int o = this.__offset(26);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int compressFeatureMapLength() {
        int o = this.__offset(26);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public CompressFeatureMap.Vector compressFeatureMapVector() {
        return this.compressFeatureMapVector(new CompressFeatureMap.Vector());
    }

    public CompressFeatureMap.Vector compressFeatureMapVector(CompressFeatureMap.Vector obj) {
        int o = this.__offset(26);
        return o != 0 ? obj.__assign(this.__vector(o), 4, this.bb) : null;
    }

    public static int createResponseFLJob(FlatBufferBuilder builder, int retcode, int reasonOffset, int iteration, boolean is_selected, int next_req_timeOffset, int fl_plan_configOffset, int feature_mapOffset, int timestampOffset, byte upload_compress_type, float upload_sparse_rate, byte download_compress_type, int compress_feature_mapOffset) {
        builder.startTable(12);
        ResponseFLJob.addCompressFeatureMap(builder, compress_feature_mapOffset);
        ResponseFLJob.addUploadSparseRate(builder, upload_sparse_rate);
        ResponseFLJob.addTimestamp(builder, timestampOffset);
        ResponseFLJob.addFeatureMap(builder, feature_mapOffset);
        ResponseFLJob.addFlPlanConfig(builder, fl_plan_configOffset);
        ResponseFLJob.addNextReqTime(builder, next_req_timeOffset);
        ResponseFLJob.addIteration(builder, iteration);
        ResponseFLJob.addReason(builder, reasonOffset);
        ResponseFLJob.addRetcode(builder, retcode);
        ResponseFLJob.addDownloadCompressType(builder, download_compress_type);
        ResponseFLJob.addUploadCompressType(builder, upload_compress_type);
        ResponseFLJob.addIsSelected(builder, is_selected);
        return ResponseFLJob.endResponseFLJob(builder);
    }

    public static void startResponseFLJob(FlatBufferBuilder builder) {
        builder.startTable(12);
    }

    public static void addRetcode(FlatBufferBuilder builder, int retcode) {
        builder.addInt(0, retcode, 0);
    }

    public static void addReason(FlatBufferBuilder builder, int reasonOffset) {
        builder.addOffset(1, reasonOffset, 0);
    }

    public static void addIteration(FlatBufferBuilder builder, int iteration) {
        builder.addInt(2, iteration, 0);
    }

    public static void addIsSelected(FlatBufferBuilder builder, boolean isSelected) {
        builder.addBoolean(3, isSelected, false);
    }

    public static void addNextReqTime(FlatBufferBuilder builder, int nextReqTimeOffset) {
        builder.addOffset(4, nextReqTimeOffset, 0);
    }

    public static void addFlPlanConfig(FlatBufferBuilder builder, int flPlanConfigOffset) {
        builder.addOffset(5, flPlanConfigOffset, 0);
    }

    public static void addFeatureMap(FlatBufferBuilder builder, int featureMapOffset) {
        builder.addOffset(6, featureMapOffset, 0);
    }

    public static int createFeatureMapVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startFeatureMapVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addTimestamp(FlatBufferBuilder builder, int timestampOffset) {
        builder.addOffset(7, timestampOffset, 0);
    }

    public static void addUploadCompressType(FlatBufferBuilder builder, byte uploadCompressType) {
        builder.addByte(8, uploadCompressType, 0);
    }

    public static void addUploadSparseRate(FlatBufferBuilder builder, float uploadSparseRate) {
        builder.addFloat(9, uploadSparseRate, 0.0);
    }

    public static void addDownloadCompressType(FlatBufferBuilder builder, byte downloadCompressType) {
        builder.addByte(10, downloadCompressType, 0);
    }

    public static void addCompressFeatureMap(FlatBufferBuilder builder, int compressFeatureMapOffset) {
        builder.addOffset(11, compressFeatureMapOffset, 0);
    }

    public static int createCompressFeatureMapVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startCompressFeatureMapVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endResponseFLJob(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public ResponseFLJob get(int j) {
            return this.get(new ResponseFLJob(), j);
        }

        public ResponseFLJob get(ResponseFLJob obj, int j) {
            return obj.__assign(ResponseFLJob.__indirect(this.__element(j), this.bb), this.bb);
        }
    }
}

