/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient.cipher;

import com.mindspore.flclient.Common;
import com.mindspore.flclient.cipher.AESEncrypt;
import com.mindspore.flclient.common.FLLoggerGenerater;
import java.security.SecureRandom;
import java.util.List;
import java.util.logging.Logger;

public class Masking {
    private static final Logger LOGGER = FLLoggerGenerater.getModelLogger(Masking.class.toString());
    private static final String RNG_ALGORITHM = "SHA1PRNG";

    public int getRandomBytes(byte[] secret) {
        if (secret == null || secret.length == 0) {
            LOGGER.severe("[Masking] the input argument <secret> is null, please check!");
            return -1;
        }
        SecureRandom secureRandom = Common.getSecureRandom();
        secureRandom.nextBytes(secret);
        return 0;
    }

    public int getMasking(List<Float> noise, int length, byte[] seed, byte[] iVec) {
        if (length <= 0) {
            LOGGER.severe("[Masking] the input argument <length> is not valid: <= 0, please check!");
            return -1;
        }
        int intV = 4;
        int size = length * intV;
        byte[] data = new byte[size];
        for (int i = 0; i < size; ++i) {
            data[i] = 0;
        }
        AESEncrypt aesEncrypt = new AESEncrypt(seed, "CTR");
        byte[] encryptCtr = aesEncrypt.encryptCTR(seed, data, iVec);
        if (encryptCtr == null || encryptCtr.length == 0) {
            LOGGER.severe("[Masking] the return byte[] is null, please check!");
            return -1;
        }
        for (int i = 0; i < length; ++i) {
            int[] sub = new int[intV];
            for (int j = 0; j < 4; ++j) {
                sub[j] = encryptCtr[i * intV + j] & 0xFF;
            }
            int subI = Masking.byte2int(sub, 4);
            if (subI == -1) {
                LOGGER.severe("[Masking] the the returned <subI> is not valid: -1, please check!");
                return -1;
            }
            Float fNoise = Float.valueOf(Float.valueOf(subI).floatValue() / 2.1474836E9f);
            noise.add(fNoise);
        }
        return 0;
    }

    private static int byte2int(int[] data, int number) {
        if (data.length < 4) {
            LOGGER.severe("[Masking] the input argument <data> is not valid: length < 4, please check!");
            return -1;
        }
        switch (number) {
            case 1: {
                return data[0];
            }
            case 2: {
                return data[0] & 0xFF | data[1] << 8 & 0xFF00;
            }
            case 3: {
                return data[0] & 0xFF | data[1] << 8 & 0xFF00 | data[2] << 16 & 0xFF0000;
            }
            case 4: {
                return data[0] & 0xFF | data[1] << 8 & 0xFF00 | data[2] << 16 & 0xFF0000 | data[3] << 24 & 0xFF000000;
            }
        }
        return 0;
    }
}

