/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient;

import com.mindspore.flclient.Common;
import com.mindspore.flclient.FLParameter;
import com.mindspore.flclient.common.FLLoggerGenerater;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SSLSocketFactoryTools {
    private static final Logger LOGGER = FLLoggerGenerater.getModelLogger(SSLSocketFactory.class.toString());
    private static volatile SSLSocketFactoryTools sslSocketFactoryTools;
    private FLParameter flParameter = FLParameter.getInstance();
    private X509Certificate x509Certificate;
    private SSLSocketFactory sslSocketFactory;
    private SSLContext sslContext;
    private MyTrustManager myTrustManager;

    private SSLSocketFactoryTools() {
        this.initSslSocketFactory();
    }

    private void initSslSocketFactory() {
        try {
            this.sslContext = SSLContext.getInstance(this.flParameter.getSslProtocol());
            this.x509Certificate = this.readCert(this.flParameter.getCertPath());
            this.myTrustManager = new MyTrustManager(this.x509Certificate);
            this.sslContext.init(null, new TrustManager[]{this.myTrustManager}, Common.getSecureRandom());
            this.sslSocketFactory = this.sslContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            LOGGER.severe("[SSLSocketFactoryTools]catch Exception in initSslSocketFactory: " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SSLSocketFactoryTools getInstance() {
        SSLSocketFactoryTools localRef = sslSocketFactoryTools;
        if (localRef != null) return localRef;
        Class<SSLSocketFactoryTools> clazz = SSLSocketFactoryTools.class;
        synchronized (SSLSocketFactoryTools.class) {
            localRef = sslSocketFactoryTools;
            if (localRef != null) return localRef;
            sslSocketFactoryTools = localRef = new SSLSocketFactoryTools();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return localRef;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509Certificate readCert(String assetName) {
        if (assetName == null || assetName.isEmpty()) {
            LOGGER.severe("[SSLSocketFactoryTools] the parameter of <assetName> is null or empty, please check!");
            return null;
        }
        FileInputStream inputStream = null;
        X509Certificate cert = null;
        try {
            inputStream = new FileInputStream(assetName);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate certificate = cf.generateCertificate(inputStream);
            if (certificate instanceof X509Certificate) {
                cert = (X509Certificate)certificate;
            } else {
                LOGGER.severe("[SSLSocketFactoryTools] cf.generateCertificate(inputStream) can not convert to X509Certificate");
            }
        }
        catch (FileNotFoundException | CertificateException ex) {
            LOGGER.severe("[SSLSocketFactoryTools] catch exception when creating CertificateFactory in readCert: invalid file or CertificateException");
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException ex) {
                LOGGER.severe("[SSLSocketFactoryTools] catch IOException: " + ex.getMessage());
            }
        }
        return cert;
    }

    public SSLSocketFactory getmSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public MyTrustManager getmTrustManager() {
        return this.myTrustManager;
    }

    private static final class MyTrustManager
    implements X509TrustManager {
        X509Certificate cert;

        MyTrustManager(X509Certificate cert) {
            this.cert = cert;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            for (X509Certificate cert : chain) {
                cert.checkValidity();
                try {
                    cert.verify(this.cert.getPublicKey());
                }
                catch (NoSuchAlgorithmException e) {
                    LOGGER.severe("[SSLSocketFactoryTools] checkServerTrusted failed, catch NoSuchAlgorithmException in checkServerTrusted: " + e.getMessage());
                }
                catch (InvalidKeyException e) {
                    LOGGER.severe("[SSLSocketFactoryTools] checkServerTrusted failed, catch InvalidKeyException in checkServerTrusted: " + e.getMessage());
                }
                catch (NoSuchProviderException e) {
                    LOGGER.severe("[SSLSocketFactoryTools] checkServerTrusted failed, catch NoSuchProviderException in checkServerTrusted: " + e.getMessage());
                }
                catch (SignatureException e) {
                    LOGGER.severe("[SSLSocketFactoryTools] checkServerTrusted failed, catch SignatureException in checkServerTrusted: " + e.getMessage());
                }
                LOGGER.info("**********************checkServerTrusted success!**********************");
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

