/*
 * Decompiled with CFR 0.152.
 */
package mindspore.fl.schema;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.ByteVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import mindspore.fl.schema.Aggregation;
import mindspore.fl.schema.CipherPublicParams;
import mindspore.fl.schema.EarlyStop;

public final class FLPlan
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_2_0_0();
    }

    public static FLPlan getRootAsFLPlan(ByteBuffer _bb) {
        return FLPlan.getRootAsFLPlan(_bb, new FLPlan());
    }

    public static FLPlan getRootAsFLPlan(ByteBuffer _bb, FLPlan obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public FLPlan __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public String serverMode() {
        int o = this.__offset(4);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer serverModeAsByteBuffer() {
        return this.__vector_as_bytebuffer(4, 1);
    }

    public ByteBuffer serverModeInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 4, 1);
    }

    public String flName() {
        int o = this.__offset(6);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer flNameAsByteBuffer() {
        return this.__vector_as_bytebuffer(6, 1);
    }

    public ByteBuffer flNameInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 6, 1);
    }

    public int iterations() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public boolean mutateIterations(int iterations) {
        int o = this.__offset(8);
        if (o != 0) {
            this.bb.putInt(o + this.bb_pos, iterations);
            return true;
        }
        return false;
    }

    public int epochs() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public boolean mutateEpochs(int epochs) {
        int o = this.__offset(10);
        if (o != 0) {
            this.bb.putInt(o + this.bb_pos, epochs);
            return true;
        }
        return false;
    }

    public EarlyStop earlyStop() {
        return this.earlyStop(new EarlyStop());
    }

    public EarlyStop earlyStop(EarlyStop obj) {
        int o = this.__offset(12);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public int miniBatch() {
        int o = this.__offset(14);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public boolean mutateMiniBatch(int mini_batch) {
        int o = this.__offset(14);
        if (o != 0) {
            this.bb.putInt(o + this.bb_pos, mini_batch);
            return true;
        }
        return false;
    }

    public boolean shuffle() {
        int o = this.__offset(16);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public boolean mutateShuffle(boolean shuffle) {
        int o = this.__offset(16);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, (byte)(shuffle ? 1 : 0));
            return true;
        }
        return false;
    }

    public float lr() {
        int o = this.__offset(18);
        return o != 0 ? this.bb.getFloat(o + this.bb_pos) : 0.0f;
    }

    public boolean mutateLr(float lr) {
        int o = this.__offset(18);
        if (o != 0) {
            this.bb.putFloat(o + this.bb_pos, lr);
            return true;
        }
        return false;
    }

    public Aggregation aggregation() {
        return this.aggregation(new Aggregation());
    }

    public Aggregation aggregation(Aggregation obj) {
        int o = this.__offset(20);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public byte metrics(int j) {
        int o = this.__offset(22);
        return o != 0 ? this.bb.get(this.__vector(o) + j * 1) : (byte)0;
    }

    public int metricsLength() {
        int o = this.__offset(22);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteVector metricsVector() {
        return this.metricsVector(new ByteVector());
    }

    public ByteVector metricsVector(ByteVector obj) {
        int o = this.__offset(22);
        return o != 0 ? obj.__assign(this.__vector(o), this.bb) : null;
    }

    public ByteBuffer metricsAsByteBuffer() {
        return this.__vector_as_bytebuffer(22, 1);
    }

    public ByteBuffer metricsInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 22, 1);
    }

    public boolean mutateMetrics(int j, byte metrics) {
        int o = this.__offset(22);
        if (o != 0) {
            this.bb.put(this.__vector(o) + j * 1, metrics);
            return true;
        }
        return false;
    }

    public CipherPublicParams cipher() {
        return this.cipher(new CipherPublicParams());
    }

    public CipherPublicParams cipher(CipherPublicParams obj) {
        int o = this.__offset(24);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public static int createFLPlan(FlatBufferBuilder builder, int server_modeOffset, int fl_nameOffset, int iterations, int epochs, int early_stopOffset, int mini_batch, boolean shuffle, float lr, int aggregationOffset, int metricsOffset, int cipherOffset) {
        builder.startTable(11);
        FLPlan.addCipher(builder, cipherOffset);
        FLPlan.addMetrics(builder, metricsOffset);
        FLPlan.addAggregation(builder, aggregationOffset);
        FLPlan.addLr(builder, lr);
        FLPlan.addMiniBatch(builder, mini_batch);
        FLPlan.addEarlyStop(builder, early_stopOffset);
        FLPlan.addEpochs(builder, epochs);
        FLPlan.addIterations(builder, iterations);
        FLPlan.addFlName(builder, fl_nameOffset);
        FLPlan.addServerMode(builder, server_modeOffset);
        FLPlan.addShuffle(builder, shuffle);
        return FLPlan.endFLPlan(builder);
    }

    public static void startFLPlan(FlatBufferBuilder builder) {
        builder.startTable(11);
    }

    public static void addServerMode(FlatBufferBuilder builder, int serverModeOffset) {
        builder.addOffset(0, serverModeOffset, 0);
    }

    public static void addFlName(FlatBufferBuilder builder, int flNameOffset) {
        builder.addOffset(1, flNameOffset, 0);
    }

    public static void addIterations(FlatBufferBuilder builder, int iterations) {
        builder.addInt(2, iterations, 0);
    }

    public static void addEpochs(FlatBufferBuilder builder, int epochs) {
        builder.addInt(3, epochs, 0);
    }

    public static void addEarlyStop(FlatBufferBuilder builder, int earlyStopOffset) {
        builder.addOffset(4, earlyStopOffset, 0);
    }

    public static void addMiniBatch(FlatBufferBuilder builder, int miniBatch) {
        builder.addInt(5, miniBatch, 0);
    }

    public static void addShuffle(FlatBufferBuilder builder, boolean shuffle) {
        builder.addBoolean(6, shuffle, false);
    }

    public static void addLr(FlatBufferBuilder builder, float lr) {
        builder.addFloat(7, lr, 0.0);
    }

    public static void addAggregation(FlatBufferBuilder builder, int aggregationOffset) {
        builder.addOffset(8, aggregationOffset, 0);
    }

    public static void addMetrics(FlatBufferBuilder builder, int metricsOffset) {
        builder.addOffset(9, metricsOffset, 0);
    }

    public static int createMetricsVector(FlatBufferBuilder builder, byte[] data) {
        return builder.createByteVector(data);
    }

    public static int createMetricsVector(FlatBufferBuilder builder, ByteBuffer data) {
        return builder.createByteVector(data);
    }

    public static void startMetricsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(1, numElems, 1);
    }

    public static void addCipher(FlatBufferBuilder builder, int cipherOffset) {
        builder.addOffset(10, cipherOffset, 0);
    }

    public static int endFLPlan(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public FLPlan get(int j) {
            return this.get(new FLPlan(), j);
        }

        public FLPlan get(FLPlan obj, int j) {
            return obj.__assign(FLPlan.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

