/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.flclient;

import com.mindspore.flclient.Common;
import com.mindspore.flclient.FLParameter;
import com.mindspore.flclient.IAsyncCallBack;
import com.mindspore.flclient.IFLCommunication;
import com.mindspore.flclient.LocalFLParameter;
import com.mindspore.flclient.SSLSocketFactoryTools;
import com.mindspore.flclient.common.FLLoggerGenerater;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class FLCommunication
implements IFLCommunication {
    private static int timeOut;
    private static String sslProtocol;
    private static String env;
    private static SSLSocketFactory sslSocketFactory;
    private static X509TrustManager x509TrustManager;
    private static final MediaType MEDIA_TYPE_JSON;
    private static final Logger LOGGER;
    private static volatile FLCommunication communication;
    private static boolean msgDumpFlg;
    private static String msgDumpPath;
    private int msgDumpIdx = 0;
    private FLParameter flParameter = FLParameter.getInstance();
    private LocalFLParameter localFLParameter = LocalFLParameter.getInstance();
    private OkHttpClient client;

    private FLCommunication() {
        timeOut = this.flParameter.getTimeOut() != 0 ? this.flParameter.getTimeOut() : 30;
        sslProtocol = this.flParameter.getSslProtocol();
        env = this.flParameter.getDeployEnv();
        if ("android".equals(env) && Common.isHttps()) {
            sslSocketFactory = this.flParameter.getSslSocketFactory();
            x509TrustManager = this.flParameter.getX509TrustManager();
        }
        this.client = FLCommunication.getOkHttpClient();
    }

    public static void setMsgDumpFlg(boolean msgDumpFlg) {
        FLCommunication.msgDumpFlg = msgDumpFlg;
    }

    public static void setMsgDumpPath(String msgDumpPath) {
        FLCommunication.msgDumpPath = msgDumpPath;
    }

    private static OkHttpClient getOkHttpClient() {
        LOGGER.info("Set timeOut in OkHttpClient: " + timeOut);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(timeOut, TimeUnit.SECONDS);
        builder.writeTimeout(timeOut, TimeUnit.SECONDS);
        builder.readTimeout(3 * timeOut, TimeUnit.SECONDS);
        if (!Common.isHttps()) {
            LOGGER.info("conducting http communication, do not need SSLSocketFactoryTools");
            return builder.build();
        }
        if ("android".equals(env)) {
            builder.sslSocketFactory(sslSocketFactory, x509TrustManager);
        } else {
            builder.sslSocketFactory(SSLSocketFactoryTools.getInstance().getmSslSocketFactory(), SSLSocketFactoryTools.getInstance().getmTrustManager());
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FLCommunication getInstance() {
        FLCommunication localRef = communication;
        if (localRef != null) return localRef;
        Class<FLCommunication> clazz = FLCommunication.class;
        synchronized (FLCommunication.class) {
            localRef = communication;
            if (localRef != null) return localRef;
            communication = localRef = new FLCommunication();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return localRef;
        }
    }

    @Override
    public void setTimeOut(int timeout2) throws TimeoutException {
    }

    private void dumpMsgBodyToFile(String url, byte[] reqBody, byte[] resBody) {
        String[] urlPath = url.split("/");
        String realPath = msgDumpPath + '/' + urlPath[urlPath.length - 1];
        String reqFileName = realPath + "/Req_" + Integer.toString(this.msgDumpIdx);
        String resFileName = realPath + "/Res_" + Integer.toString(this.msgDumpIdx);
        try {
            File dir = new File(realPath);
            if (!dir.exists()) {
                dir.mkdir();
            }
            ObjectOutputStream oosReq = new ObjectOutputStream(new FileOutputStream(reqFileName));
            ObjectOutputStream oosRes = new ObjectOutputStream(new FileOutputStream(resFileName));
            oosReq.writeObject(reqBody);
            oosRes.writeObject(resBody);
            oosReq.close();
            oosRes.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ++this.msgDumpIdx;
    }

    @Override
    public byte[] syncRequest(String url, byte[] msg) throws IOException {
        Request request = new Request.Builder().url(url).post(RequestBody.create(MEDIA_TYPE_JSON, msg)).build();
        Response response = this.client.newCall(request).execute();
        if (!response.isSuccessful()) {
            throw new IOException("Unexpected code " + response);
        }
        if (response.body() == null) {
            throw new IOException("the returned response is null");
        }
        byte[] responseBody = response.body().bytes();
        if (msgDumpFlg) {
            this.dumpMsgBodyToFile(url, msg, responseBody);
        }
        return responseBody;
    }

    @Override
    public void asyncRequest(String url, byte[] msg, final IAsyncCallBack callBack) throws Exception {
        Request request = new Request.Builder().url(url).header("Accept", "application/proto").header("Content-Type", "application/proto; charset=utf-8").post(RequestBody.create(MEDIA_TYPE_JSON, msg)).build();
        this.client.newCall(request).enqueue(new Callback(){
            IAsyncCallBack asyncCallBack;
            {
                this.asyncCallBack = callBack;
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                this.asyncCallBack.onResponse(response.body().bytes());
                call.cancel();
            }

            @Override
            public void onFailure(Call call, IOException ioException) {
                this.asyncCallBack.onFailure(ioException);
                call.cancel();
            }
        });
    }

    static {
        MEDIA_TYPE_JSON = MediaType.parse("applicatiom/json;charset=utf-8");
        LOGGER = FLLoggerGenerater.getModelLogger(FLCommunication.class.toString());
        msgDumpFlg = false;
    }
}

