/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.smartcomplete;

import com.intellij.notification.NotificationType;
import com.mindspore.ide.toolkit.common.utils.FileUtils;
import com.mindspore.ide.toolkit.common.utils.NotificationUtils;
import com.mindspore.ide.toolkit.protomessage.CompleteReply;
import com.mindspore.ide.toolkit.search.OperatorSearchService;
import com.mindspore.ide.toolkit.smartcomplete.CompleteConfig;
import com.mindspore.ide.toolkit.smartcomplete.ModelFile;
import com.mindspore.ide.toolkit.smartcomplete.ModelProcess;
import com.mindspore.ide.toolkit.smartcomplete.grpc.CompletionException;
import com.mindspore.ide.toolkit.statusbar.utils.MindSporeVersionUtils;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ModelManager {
    INSTANCE;

    private static final Logger log;
    private final CompleteConfig completeConfig = CompleteConfig.get();
    private final CompleteConfig.Model currentModel = this.completeConfig.getCurrentModel();
    private final CompleteConfig.Model oldModel = this.completeConfig.getOldModelInDisk().orElse(null);
    private volatile ModelProcess modelProcess;
    private volatile ModelProcess oldModelProcess;
    private final ModelFile modelFile = new ModelFile();
    private final int queueCapacity = 100;
    private final Long deleteOverTime = 3000L;
    private final ThreadPoolExecutor modelExecutor = new ThreadPoolExecutor(2 * Runtime.getRuntime().availableProcessors(), 4 * Runtime.getRuntime().availableProcessors(), 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100), new ThreadPoolExecutor.CallerRunsPolicy());
    private final Object modelLock = new Object();

    public void startCompleteModel() {
        this.modelExecutor.execute(() -> {
            Object object = this.modelLock;
            synchronized (object) {
                if (this.modelProcess != null) {
                    return;
                }
                if (this.modelFile.modelExeExists()) {
                    log.info("Start current model.");
                    this.startCurrentModel();
                } else if (this.oldModel == null) {
                    log.info("Download and start current model.");
                    this.modelFile.fetchModelFile();
                    this.startCurrentModel();
                } else {
                    log.info("Start old model and download current model.");
                    this.startOldModel();
                    log.info("Start old model process done, current time is {}.", (Object)System.currentTimeMillis());
                    this.startCurrentModelAndStopOldModel();
                }
            }
        });
        this.modelExecutor.execute(() -> {
            OperatorSearchService.INSTANCE.changeSearchDataHub(MindSporeVersionUtils.getBigVersion(CompleteConfig.PLUGIN_VERSION), true);
            NotificationUtils.notify(NotificationUtils.NotifyGroup.SEARCH, NotificationType.INFORMATION, "API mapping init successfully");
        });
    }

    public void shutDownSmartCompleteModel() {
        if (this.modelProcess != null) {
            this.modelProcess.shutDownModel();
        }
        if (this.oldModelProcess != null) {
            this.oldModelProcess.shutDownModel();
        }
        this.modelExecutor.shutdown();
        this.modelFile.shutdownExecutor();
    }

    public Optional<CompleteReply> communicateWithModel(String before, String options) throws CompletionException {
        if (this.modelProcess == null && this.oldModelProcess != null) {
            if (this.oldModelProcess.isAlive()) {
                return this.oldModelProcess.retrieveCompletions(before, options);
            }
            return Optional.empty();
        }
        if (this.modelProcess == null) {
            return Optional.empty();
        }
        if (this.modelProcess.isInited() && !this.modelProcess.isAlive()) {
            this.restartCurrentCompleteModel();
            return Optional.empty();
        }
        if (this.modelProcess.isAlive()) {
            return this.modelProcess.retrieveCompletions(before, options);
        }
        return Optional.empty();
    }

    private void startCurrentModelAndStopOldModel() {
        this.modelExecutor.execute(() -> {
            Object object = this.modelLock;
            synchronized (object) {
                boolean isDownloadSucceed = this.modelFile.fetchModelFile();
                if (!isDownloadSucceed) {
                    return;
                }
                this.modelProcess = new ModelProcess();
                this.modelProcess.initModel(this.currentModel);
                log.info("Start current model process done, current time is {}.", (Object)System.currentTimeMillis());
                this.shutdownAndDeleteOldModel();
            }
        });
    }

    private void shutdownAndDeleteOldModel() {
        if (this.oldModelProcess != null) {
            this.oldModelProcess.shutDownModel();
            this.oldModelProcess = null;
        }
        log.info("Stop old model process done, current time is {}.", (Object)System.currentTimeMillis());
        Long startTime = System.currentTimeMillis();
        while (FileUtils.fileExist(this.completeConfig.getModelFolderPath())) {
            this.modelFile.deleteInvalidModelAsync();
            if (System.currentTimeMillis() - startTime <= this.deleteOverTime) continue;
            break;
        }
    }

    private void restartCurrentCompleteModel() {
        this.modelExecutor.execute(() -> {
            Object object = this.modelLock;
            synchronized (object) {
                if (this.modelProcess.isInited() && !this.modelProcess.isAlive()) {
                    if (!this.modelFile.modelExeExists()) {
                        this.modelFile.fetchModelFile();
                    }
                    this.modelProcess.initModel(this.currentModel);
                }
            }
        });
    }

    private void startCurrentModel() {
        if (this.modelProcess != null || !this.modelFile.modelExeExists()) {
            return;
        }
        this.modelFile.deleteInvalidModelAsync();
        this.modelProcess = new ModelProcess();
        this.modelProcess.initModel(this.currentModel);
    }

    private void startOldModel() {
        if (this.oldModelProcess != null) {
            return;
        }
        this.oldModelProcess = new ModelProcess();
        this.oldModelProcess.initModel(this.oldModel);
    }

    static {
        log = LoggerFactory.getLogger(ModelManager.class);
    }
}

