/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.wizard;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.python.sdk.flavors.PyCondaRunKt;
import com.mindspore.ide.toolkit.common.config.GlobalConfig;
import com.mindspore.ide.toolkit.common.utils.PathUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsEnvValidator {
    private static final Logger log = LoggerFactory.getLogger(MsEnvValidator.class);

    private MsEnvValidator() {
    }

    public static MsEnvStatus validateMindSpore(Sdk sdk) {
        String validatorFileFullPathStr = String.join((CharSequence)File.separator, PathUtils.getDefaultResourcePath(), GlobalConfig.get().getMsEnvValidatorFile());
        try {
            MsEnvValidator.writeValidatorPyFile(validatorFileFullPathStr);
        }
        catch (IOException ioException) {
            log.warn("MsEnvValidator.validateMindSpore-Write python file failed.", (Throwable)ioException);
            return MsEnvStatus.UNKNOWN;
        }
        return MsEnvValidator.validateMindSporeEnv(sdk, validatorFileFullPathStr);
    }

    private static MsEnvStatus validateMindSporeEnv(Sdk sdk, String validatorFileFullPathStr) {
        MsEnvStatus msEnvStatus = MsEnvStatus.UNAVAILABLE;
        try {
            ProcessOutput output = PyCondaRunKt.runCondaPython((String)sdk.getHomePath(), Collections.singletonList(validatorFileFullPathStr));
            String stdout = output.getStdout();
            log.info("MsEnvValidator.validateMindSpore-Execute validator file succeed, stdout is {}", (Object)stdout);
            if (stdout != null && stdout.contains("MindSpore has been installed successfully")) {
                msEnvStatus = MsEnvStatus.AVAILABLE;
            }
        }
        catch (ExecutionException executionException) {
            log.warn("MsEnvValidator.validateMindSpore-Execute validator file failed.", (Throwable)executionException);
            msEnvStatus = MsEnvStatus.UNKNOWN;
        }
        return msEnvStatus;
    }

    private static void writeValidatorPyFile(String validatorFileFullPathStr) throws IOException {
        Path validatorFileFullPath = Path.of(validatorFileFullPathStr, new String[0]);
        if (!Files.exists(validatorFileFullPath, new LinkOption[0])) {
            byte[] fileContent = ("import mindspore" + System.lineSeparator() + "mindspore.run_check()").getBytes(StandardCharsets.UTF_8);
            Files.write(validatorFileFullPath, fileContent, new OpenOption[0]);
        }
    }

    public static enum MsEnvStatus {
        AVAILABLE,
        UNAVAILABLE,
        UNKNOWN;

    }
}

