/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.services.complete;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.project.Project;
import com.mindspore.ide.toolkit.common.events.EventCenter;
import com.mindspore.ide.toolkit.common.events.SmartCompleteEvents;
import com.mindspore.ide.toolkit.services.complete.SmartCompletionLookupListener;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartCompletion
extends CompletionContributor {
    private static final Logger log = LoggerFactory.getLogger(SmartCompletion.class);
    private static final long LONGEST_WAITING_TIME = 500L;
    private final SmartCompletionLookupListener smartCompletionLookupListener = new SmartCompletionLookupListener();

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        List<LookupElement> smartCompleteResult;
        if (parameters == null) {
            SmartCompletion.$$$reportNull$$$0(0);
        }
        if (result == null) {
            SmartCompletion.$$$reportNull$$$0(1);
        }
        super.fillCompletionVariants(parameters, result);
        result.restartCompletionOnAnyPrefixChange();
        String prefix = result.getPrefixMatcher().getPrefix();
        this.registerLookupListener(parameters);
        SmartCompleteEvents.CodeRecommendStart codeCompleteStart = new SmartCompleteEvents.CodeRecommendStart();
        codeCompleteStart.setDoc(parameters.getEditor().getDocument());
        codeCompleteStart.setMyOffset(parameters.getOffset());
        codeCompleteStart.setPrefix(prefix);
        EventCenter.INSTANCE.publish(codeCompleteStart);
        Long startTime = System.currentTimeMillis();
        try {
            smartCompleteResult = codeCompleteStart.getPredictResult().get(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            Long endTime = System.currentTimeMillis();
            SmartCompleteEvents.CodeCompleteFailed completeException = new SmartCompleteEvents.CodeCompleteFailed();
            completeException.setException(exception);
            completeException.setDuration(endTime - startTime);
            EventCenter.INSTANCE.publish(completeException);
            log.info("failed to get smartcomplete result,", (Throwable)exception);
            return;
        }
        CompletionResultSet resultSort = this.restartElement(smartCompleteResult, parameters, result);
        if (smartCompleteResult != null && smartCompleteResult.size() > 0) {
            EventCenter.INSTANCE.publish(new SmartCompleteEvents.CodeRecommendEnd());
            resultSort.addAllElements(smartCompleteResult);
            this.smartCompletionLookupListener.setMindspore(true);
            this.smartCompletionLookupListener.setPrefix(prefix);
        }
    }

    private CompletionResultSet restartElement(final List<LookupElement> smartCompleteResult, CompletionParameters parameters, CompletionResultSet result) {
        PrefixMatcher originalMatcher = result.getPrefixMatcher();
        LookupElementWeigher lookupElementWeigher = new LookupElementWeigher("SmartComplete", false, false){

            @NotNull
            public Integer weigh(@NotNull LookupElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (smartCompleteResult.contains(element)) {
                    Integer n = smartCompleteResult.indexOf(element);
                    if (n == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return n;
                }
                Integer n = Integer.MAX_VALUE;
                if (n == null) {
                    1.$$$reportNull$$$0(2);
                }
                return n;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/mindspore/ide/toolkit/services/complete/SmartCompletion$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/mindspore/ide/toolkit/services/complete/SmartCompletion$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "weigh";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "weigh";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        CompletionResultSet resultSort = result.withRelevanceSorter(CompletionSorter.defaultSorter((CompletionParameters)parameters, (PrefixMatcher)originalMatcher).weighBefore("liftShorterClasses", new LookupElementWeigher[]{lookupElementWeigher}));
        resultSort.restartCompletionOnAnyPrefixChange();
        return result;
    }

    private void registerLookupListener(CompletionParameters parameters) {
        LookupEx lookupEx = Objects.requireNonNull(LookupManager.getInstance((Project)Objects.requireNonNull(parameters.getEditor().getProject())).getActiveLookup());
        this.smartCompletionLookupListener.setMindspore(false);
        lookupEx.removeLookupListener((LookupListener)this.smartCompletionLookupListener);
        lookupEx.addLookupListener((LookupListener)this.smartCompletionLookupListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/mindspore/ide/toolkit/services/complete/SmartCompletion";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

