/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html;

import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.misc.Utils;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlRendererOptions {
    @NotNull
    public final String softBreak;
    public final boolean isSoftBreakAllSpaces;
    @NotNull
    public final String hardBreak;
    @Nullable
    public final String strongEmphasisStyleHtmlOpen;
    @Nullable
    public final String strongEmphasisStyleHtmlClose;
    @Nullable
    public final String emphasisStyleHtmlOpen;
    @Nullable
    public final String emphasisStyleHtmlClose;
    @Nullable
    public final String codeStyleHtmlOpen;
    @Nullable
    public final String codeStyleHtmlClose;
    public final boolean escapeHtmlBlocks;
    public final boolean escapeHtmlCommentBlocks;
    public final boolean escapeInlineHtml;
    public final boolean escapeInlineHtmlComments;
    public final boolean percentEncodeUrls;
    public final int indentSize;
    public final boolean suppressHtmlBlocks;
    public final boolean suppressHtmlCommentBlocks;
    public final boolean suppressInlineHtml;
    public final boolean suppressInlineHtmlComments;
    public final boolean doNotRenderLinksInDocument;
    public final boolean renderHeaderId;
    public final boolean generateHeaderIds;
    @NotNull
    public final String languageClassPrefix;
    @NotNull
    public final HashMap<String, String> languageClassMap;
    @NotNull
    public final String languageDelimiters;
    public final CharPredicate languageDelimiterSet;
    @NotNull
    public final String noLanguageClass;
    @NotNull
    public final String sourcePositionAttribute;
    @Nullable
    public final String inlineCodeSpliceClass;
    public final boolean sourcePositionParagraphLines;
    public final boolean sourceWrapHtmlBlocks;
    public final int formatFlags;
    public final int maxTrailingBlankLines;
    public final int maxBlankLines;
    public final boolean htmlBlockOpenTagEol;
    public final boolean htmlBlockCloseTagEol;
    public final boolean unescapeHtmlEntities;
    public final boolean noPTagsUseBr;
    @NotNull
    public final String autolinkWwwPrefix;
    @Nullable
    public final Pattern suppressedLinks;

    public HtmlRendererOptions(DataHolder options) {
        this.softBreak = (String)HtmlRenderer.SOFT_BREAK.get(options);
        this.isSoftBreakAllSpaces = Utils.isWhiteSpaceNoEOL((String)this.softBreak);
        this.hardBreak = (String)HtmlRenderer.HARD_BREAK.get(options);
        this.strongEmphasisStyleHtmlOpen = (String)HtmlRenderer.STRONG_EMPHASIS_STYLE_HTML_OPEN.get(options);
        this.strongEmphasisStyleHtmlClose = (String)HtmlRenderer.STRONG_EMPHASIS_STYLE_HTML_CLOSE.get(options);
        this.emphasisStyleHtmlOpen = (String)HtmlRenderer.EMPHASIS_STYLE_HTML_OPEN.get(options);
        this.emphasisStyleHtmlClose = (String)HtmlRenderer.EMPHASIS_STYLE_HTML_CLOSE.get(options);
        this.codeStyleHtmlOpen = (String)HtmlRenderer.CODE_STYLE_HTML_OPEN.get(options);
        this.codeStyleHtmlClose = (String)HtmlRenderer.CODE_STYLE_HTML_CLOSE.get(options);
        this.escapeHtmlBlocks = (Boolean)HtmlRenderer.ESCAPE_HTML_BLOCKS.get(options);
        this.escapeHtmlCommentBlocks = (Boolean)HtmlRenderer.ESCAPE_HTML_COMMENT_BLOCKS.get(options);
        this.escapeInlineHtml = (Boolean)HtmlRenderer.ESCAPE_INLINE_HTML.get(options);
        this.escapeInlineHtmlComments = (Boolean)HtmlRenderer.ESCAPE_INLINE_HTML_COMMENTS.get(options);
        this.percentEncodeUrls = (Boolean)HtmlRenderer.PERCENT_ENCODE_URLS.get(options);
        this.indentSize = (Integer)HtmlRenderer.INDENT_SIZE.get(options);
        this.suppressHtmlBlocks = (Boolean)HtmlRenderer.SUPPRESS_HTML_BLOCKS.get(options);
        this.suppressHtmlCommentBlocks = (Boolean)HtmlRenderer.SUPPRESS_HTML_COMMENT_BLOCKS.get(options);
        this.suppressInlineHtml = (Boolean)HtmlRenderer.SUPPRESS_INLINE_HTML.get(options);
        this.suppressInlineHtmlComments = (Boolean)HtmlRenderer.SUPPRESS_INLINE_HTML_COMMENTS.get(options);
        this.doNotRenderLinksInDocument = (Boolean)HtmlRenderer.DO_NOT_RENDER_LINKS.get(options);
        this.renderHeaderId = (Boolean)HtmlRenderer.RENDER_HEADER_ID.get(options);
        this.generateHeaderIds = (Boolean)HtmlRenderer.GENERATE_HEADER_ID.get(options);
        this.languageClassPrefix = (String)HtmlRenderer.FENCED_CODE_LANGUAGE_CLASS_PREFIX.get(options);
        this.languageClassMap = (HashMap)HtmlRenderer.FENCED_CODE_LANGUAGE_CLASS_MAP.get(options);
        this.languageDelimiters = (String)HtmlRenderer.FENCED_CODE_LANGUAGE_DELIMITERS.get(options);
        this.languageDelimiterSet = CharPredicate.anyOf((CharSequence)this.languageDelimiters);
        this.noLanguageClass = (String)HtmlRenderer.FENCED_CODE_NO_LANGUAGE_CLASS.get(options);
        this.sourcePositionAttribute = (String)HtmlRenderer.SOURCE_POSITION_ATTRIBUTE.get(options);
        this.sourcePositionParagraphLines = !this.sourcePositionAttribute.isEmpty() && (Boolean)HtmlRenderer.SOURCE_POSITION_PARAGRAPH_LINES.get(options) != false;
        this.sourceWrapHtmlBlocks = !this.sourcePositionAttribute.isEmpty() && (Boolean)HtmlRenderer.SOURCE_WRAP_HTML_BLOCKS.get(options) != false;
        this.formatFlags = (Integer)HtmlRenderer.FORMAT_FLAGS.get(options);
        this.maxTrailingBlankLines = (Integer)HtmlRenderer.MAX_TRAILING_BLANK_LINES.get(options);
        this.maxBlankLines = (Integer)HtmlRenderer.MAX_BLANK_LINES.get(options);
        this.htmlBlockOpenTagEol = (Boolean)HtmlRenderer.HTML_BLOCK_OPEN_TAG_EOL.get(options);
        this.htmlBlockCloseTagEol = (Boolean)HtmlRenderer.HTML_BLOCK_CLOSE_TAG_EOL.get(options);
        this.unescapeHtmlEntities = (Boolean)HtmlRenderer.UNESCAPE_HTML_ENTITIES.get(options);
        this.noPTagsUseBr = (Boolean)HtmlRenderer.NO_P_TAGS_USE_BR.get(options);
        this.inlineCodeSpliceClass = (String)HtmlRenderer.INLINE_CODE_SPLICE_CLASS.get(options);
        this.autolinkWwwPrefix = (String)HtmlRenderer.AUTOLINK_WWW_PREFIX.get(options);
        String ignoreLinks = (String)HtmlRenderer.SUPPRESSED_LINKS.get(options);
        this.suppressedLinks = ignoreLinks.isEmpty() ? null : Pattern.compile(ignoreLinks);
    }
}

