/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.common;

import com.intellij.util.io.ZipUtil;
import com.mindspore.ide.toolkit.common.utils.FileUtils;
import com.mindspore.ide.toolkit.common.utils.HttpUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManager {
    private static final Logger log = LoggerFactory.getLogger(ResourceManager.class);

    public static Optional<Path> getResource(String uri) {
        return Optional.empty();
    }

    public static boolean updateResource(Path oldPath, String uri) {
        return false;
    }

    public static boolean cleanResource(Path resourcePath) {
        return false;
    }

    public static boolean downloadResource(String uri, String resourceLocation, String token, int timeout) {
        boolean downloadSucceed = false;
        try (CloseableHttpResponse response = HttpUtils.doGet(uri, ResourceManager.buildDownloadHeader(token), timeout);){
            if (response == null) {
                downloadSucceed = false;
            } else if (response.getStatusLine().getStatusCode() == 200) {
                FileUtils.writeFile(resourceLocation, response.getEntity().getContent());
                downloadSucceed = true;
            } else {
                downloadSucceed = false;
            }
        }
        catch (IOException ioException) {
            log.info("Download resource failed,", (Throwable)ioException);
        }
        return downloadSucceed;
    }

    public static void unzipResource(String zipFileLocation, String unzipFileLocation) {
        try {
            ZipUtil.extract((File)FileUtils.getFile(zipFileLocation), (File)FileUtils.getFile(unzipFileLocation), null, (boolean)true);
        }
        catch (IOException ioException) {
            log.info("Unzip resource failed,", (Throwable)ioException);
        }
    }

    private static Map<String, String> buildDownloadHeader(String token) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", "application/json");
        headerMap.put("csb-token", token);
        return headerMap;
    }
}

