/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.representer.Representer;

public enum YamlUtils {
    INSTANCE;

    private static final Logger log;

    public <T> Optional<T> readResourceFile(String resourceFile, Class<T> targetClass) {
        Optional<T> optional;
        block8: {
            InputStream configStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourceFile);
            try {
                optional = Optional.of(this.parse(configStream, targetClass));
                if (configStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (configStream != null) {
                        try {
                            configStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | YAMLException exception) {
                    log.info("failed to read yaml file {}", (Object)resourceFile, (Object)exception);
                    return Optional.empty();
                }
            }
            configStream.close();
        }
        return optional;
    }

    public <T> T parse(InputStream yamlStream, Class<T> targetClass) {
        Representer representer = new Representer();
        representer.getPropertyUtils().setSkipMissingProperties(true);
        Yaml yaml = new Yaml((BaseConstructor)new CustomClassLoaderConstructor(targetClass.getClassLoader()), representer);
        return (T)yaml.loadAs(yamlStream, targetClass);
    }

    public static <T> Optional<T> read(String configPath, Class<T> configClass) {
        Optional<Object> optional;
        block8: {
            Yaml yaml = new Yaml((BaseConstructor)new Constructor(configClass));
            InputStream in = Files.newInputStream(Paths.get(configPath, new String[0]), new OpenOption[0]);
            try {
                optional = Optional.of(yaml.load(in));
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | YAMLException exception) {
                    log.warn("Init MindSpore config file failed!", exception);
                    return Optional.empty();
                }
            }
            in.close();
        }
        return optional;
    }

    public <T> Optional<T> readConfigFile(String configPath, Class<T> configClass) {
        Optional<T> optional;
        block8: {
            InputStream in = Files.newInputStream(Paths.get(configPath, new String[0]), new OpenOption[0]);
            try {
                optional = Optional.of(this.parse(in, configClass));
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | YAMLException exception) {
                    log.warn("Init MindSpore config file failed !", exception);
                    return Optional.empty();
                }
            }
            in.close();
        }
        return optional;
    }

    public <T> Optional<T> readLocalFile(String localFile, Class<T> targetClass) {
        Optional<T> optional;
        block8: {
            InputStream configStream = Files.newInputStream(Paths.get(localFile, new String[0]), new OpenOption[0]);
            try {
                optional = Optional.of(this.parse(configStream, targetClass));
                if (configStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (configStream != null) {
                        try {
                            configStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioException) {
                    log.warn("read local yaml file failed.", (Throwable)ioException);
                    return Optional.empty();
                }
            }
            configStream.close();
        }
        return optional;
    }

    static {
        log = LoggerFactory.getLogger(YamlUtils.class);
    }
}

