/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.guide;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionManager;
import com.mindspore.ide.toolkit.common.config.GuideConfig;
import com.mindspore.ide.toolkit.common.config.GuideUserEntity;
import com.mindspore.ide.toolkit.common.events.GuideUserEvents;
import com.mindspore.ide.toolkit.common.events.ProjectEvents;
import com.mindspore.ide.toolkit.common.utils.FileUtils;
import com.mindspore.ide.toolkit.common.utils.HttpUtils;
import com.mindspore.ide.toolkit.common.utils.YamlUtils;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import net.engio.mbassy.listener.Handler;
import net.engio.mbassy.listener.Listener;
import net.engio.mbassy.listener.References;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

@Listener(references=References.Strong)
public class GuideUserListener {
    private static final Logger log = LoggerFactory.getLogger(GuideUserListener.class);
    private final GuideConfig config = GuideConfig.get();

    @Handler
    public void initGuideConfigFile(ProjectEvents.AppFrameCreated appFrameCreated) throws IOException {
        if (!FileUtils.fileExist(this.config.getConfigFilePath())) {
            GuideUserEntity entity = new GuideUserEntity();
            entity.setAskAgain(false);
            entity.setVersion(this.config.getPluginVersion());
            FileUtils.writeDataToFile(Paths.get(this.config.getConfigFilePath(), new String[0]), new Yaml().dumpAsMap((Object)entity));
        }
    }

    @Handler
    public void showBalloon(ProjectEvents.ProjectOpen projectOpen) throws IOException {
        GuideUserEntity entity = GuideUserEntity.get();
        if (this.config.getGuideSettingUrl().isEmpty()) {
            return;
        }
        GuideUserEntity remoteEntity = YamlUtils.INSTANCE.parse(HttpUtils.doGet(this.config.getGuideSettingUrl(), GuideUserListener.buildDownloadHeader()).getEntity().getContent(), GuideUserEntity.class);
        if (remoteEntity == null) {
            return;
        }
        if (!entity.isAskAgain() && entity.getVersion().equals(remoteEntity.getVersion())) {
            NotificationGroup notificationGroup = new NotificationGroup(remoteEntity.getTitle(), NotificationDisplayType.BALLOON, false);
            Notification notification = notificationGroup.createNotification(remoteEntity.getContent(), remoteEntity.getContent(), NotificationType.INFORMATION, null);
            notification.addAction(ActionManager.getInstance().getAction("mindSporeGuideAction"));
            notification.addAction(ActionManager.getInstance().getAction("mindSporeDontAskAgain"));
            Notifications.Bus.notify((Notification)notification);
            NotificationGroup.balloonGroup((String)remoteEntity.getTitle()).createNotification();
            FileUtils.writeDataToFile(Paths.get(this.config.getConfigFilePath(), new String[0]), new Yaml().dumpAsMap((Object)remoteEntity));
        }
    }

    @Handler
    public void dontAskAgain(GuideUserEvents.DontAskAgain events) throws IOException {
        GuideUserEntity entity = events.getEntity();
        entity.setAskAgain(true);
        FileUtils.writeDataToFile(Paths.get(this.config.getConfigFilePath(), new String[0]), new Yaml().dumpAsMap((Object)entity));
    }

    private static Map<String, String> buildDownloadHeader() {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", "application/json");
        return headerMap;
    }
}

