/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.search;

import com.mindspore.ide.toolkit.search.MdPathString;
import com.mindspore.ide.toolkit.search.SearchEveryWhereDataHub;
import com.mindspore.ide.toolkit.search.entity.MsOperatorInfo;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.SoftLineBreak;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public enum OperatorMapDataHub implements SearchEveryWhereDataHub<String>
{
    INSTANCE;

    private static final boolean IS_SHOW_MINDSPORE_OPERATOR = false;
    private Map<String, String> linkMap = new HashMap<String, String>();
    private Map<String, List<MsOperatorInfo>> operatorMap = new HashMap<String, List<MsOperatorInfo>>();
    private Map<String, List<String>> nodeMap = new HashMap<String, List<String>>();

    private OperatorMapDataHub() {
        this.mdStringList(MdPathString.PYTORCH_MD_STR);
        this.mdStringList(MdPathString.TENSORFLOW_MD_STR);
        this.operatorMap.entrySet().forEach(entry -> this.suffixStringSplit((String)entry.getKey()));
    }

    @Override
    public Map<String, String> assemble(List<String> topResults, String input, int count) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String topResult : topResults) {
            for (String operator : this.nodeMap.get(topResult).stream().sorted().collect(Collectors.toList())) {
                if (result.size() >= count) {
                    return result;
                }
                if (!this.operatorMap.containsKey(operator)) {
                    result.put(operator, this.linkMap.get(operator));
                    continue;
                }
                for (MsOperatorInfo value : this.operatorMap.get(operator)) {
                    result.put(operator + " -> " + value.getMindSporeOperator(), value.getLink());
                }
            }
        }
        return result;
    }

    @Override
    public Set<String> searchable() {
        return this.nodeMap.keySet();
    }

    private void mdStringList(String mdString) {
        MutableDataSet options = new MutableDataSet();
        Parser parser = Parser.builder((DataHolder)options).build();
        Document document = parser.parse(mdString);
        document.getChildIterator().forEachRemaining(paragraphNode -> {
            if (paragraphNode instanceof Paragraph) {
                LinkedHashMap<String, String> mapList = new LinkedHashMap<String, String>();
                paragraphNode.getChildIterator().forEachRemaining(innerNode -> {
                    if (innerNode instanceof Link) {
                        Link link = (Link)innerNode;
                        String text = link.getText().toString();
                        String url = link.getUrl().toString();
                        mapList.put(text, url);
                    } else if (innerNode instanceof SoftLineBreak) {
                        this.setMapData(mapList);
                    } else {
                        innerNode.getNodeName();
                    }
                });
                this.setMapData(mapList);
            }
        });
    }

    private void setMapData(LinkedHashMap<String, String> mapList) {
        if (mapList.size() <= 1) {
            return;
        }
        Map.Entry[] entries = mapList.entrySet().toArray(new Map.Entry[0]);
        Map.Entry entry = entries[entries.length - 1];
        if (((String)entry.getKey()).equals("\u5dee\u5f02\u5bf9\u6bd4") || ((String)entry.getKey()).equals("diff")) {
            this.processSpecialData(entries, entries.length - 1);
        } else {
            this.processSpecialData(entries, entries.length);
        }
        mapList.clear();
    }

    private void processSpecialData(Map.Entry<String, String>[] entries, int mapLength) {
        if (mapLength <= 1) {
            return;
        }
        if (mapLength == 2) {
            this.addMapData(entries, mapLength, 0);
        }
        if (mapLength > 2) {
            for (int i = 0; i < mapLength - 1; ++i) {
                this.addMapData(entries, mapLength, i);
            }
        }
    }

    private void addMapData(Map.Entry<String, String>[] entries, int mapLength, int in) {
        Map.Entry<String, String> entry = entries[mapLength - 1];
        String otherString = entries[in].getKey();
        List msOperatorInfos = this.operatorMap.getOrDefault(otherString, new LinkedList());
        msOperatorInfos.add(new MsOperatorInfo(entry.getKey(), entry.getValue()));
        this.linkMap.put(entry.getKey(), entry.getValue());
        this.operatorMap.put(otherString, msOperatorInfos);
    }

    private void suffixStringSplit(String key) {
        String[] keyNode = key.toLowerCase(Locale.ENGLISH).split("\\.");
        StringBuilder sb = new StringBuilder();
        for (int i = keyNode.length - 1; i >= 0; --i) {
            sb.insert(0, keyNode[i]);
            List operators = this.nodeMap.getOrDefault(sb.toString(), new ArrayList());
            operators.add(key);
            this.nodeMap.put(sb.toString(), operators);
            sb.insert(0, ".");
        }
    }

    private /* synthetic */ void lambda$new$1(Map.Entry entry) {
        this.suffixStringSplit((String)entry.getKey());
    }
}

