/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.services.complete;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.mindspore.ide.toolkit.common.events.EventCenter;
import com.mindspore.ide.toolkit.common.events.SmartCompleteEvents;
import com.mindspore.ide.toolkit.services.complete.MindSporeLookupElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartCompletionLookupListener
implements LookupListener {
    private static final Logger log = LoggerFactory.getLogger(SmartCompletionLookupListener.class);
    private static final Set<Character> SUFFIX_CHAR_SET = new HashSet<Character>();
    private volatile boolean isMindspore;
    private volatile String prefix;

    public void currentItemChanged(@NotNull LookupEvent event) {
        if (event == null) {
            SmartCompletionLookupListener.$$$reportNull$$$0(0);
        }
    }

    public void lookupCanceled(@NotNull LookupEvent event) {
        if (event == null) {
            SmartCompletionLookupListener.$$$reportNull$$$0(1);
        }
    }

    public void itemSelected(@NotNull LookupEvent event) {
        if (event == null) {
            SmartCompletionLookupListener.$$$reportNull$$$0(2);
        }
        if (this.isMindspore) {
            EventCenter.INSTANCE.publish(new SmartCompleteEvents.CodeCompleteStart());
        }
        if (event.isCanceledExplicitly()) {
            log.info("Lookup event is canceled");
            return;
        }
        if (this.isMindspore && event.getItem() != null && event.getItem() instanceof MindSporeLookupElement) {
            EventCenter.INSTANCE.publish(new SmartCompleteEvents.CodeCompleteEnd());
            this.handleSuffix(event);
        }
    }

    private void handleSuffix(LookupEvent event) {
        ArrayList<Character> suffixCharList = new ArrayList<Character>();
        String lookupString = Objects.requireNonNull(event.getItem()).getLookupString();
        if (this.prefix != null && lookupString.startsWith(this.prefix)) {
            lookupString = lookupString.replaceFirst(Pattern.quote(this.prefix), "");
        }
        for (char lookupChar : lookupString.toCharArray()) {
            if (!SUFFIX_CHAR_SET.contains(Character.valueOf(lookupChar))) continue;
            suffixCharList.add(Character.valueOf(lookupChar));
        }
        if (suffixCharList.size() > 0) {
            Document document = event.getLookup().getEditor().getDocument();
            int offset = event.getLookup().getEditor().getCaretModel().getOffset();
            int lineNumber = document.getLineNumber(offset);
            int lineEndOffset = document.getLineEndOffset(lineNumber);
            String documentText = document.getText(new TextRange(offset, lineEndOffset));
            int documentTextLen = documentText.length();
            documentText = this.removeSameSuffixInStr(suffixCharList, documentText);
            lookupString = this.removeSameSuffixInStr(suffixCharList, lookupString);
            int maxPublicLen = this.getMaxPublicPrefix(lookupString, documentText).length();
            int finalMatchLen = documentTextLen - documentText.length() + maxPublicLen;
            WriteCommandAction.runWriteCommandAction((Project)event.getLookup().getEditor().getProject(), () -> document.deleteString(offset, offset + finalMatchLen));
        }
    }

    private String removeSameSuffixInStr(List<Character> suffixCharList, String targetStr) {
        Character character;
        int index;
        String result = targetStr;
        for (int i = 0; i < suffixCharList.size() && (index = targetStr.indexOf((character = suffixCharList.get(i)).charValue())) != -1; ++i) {
            result = targetStr.substring(index + 1);
        }
        return result;
    }

    private String getMaxPublicPrefix(String oneStr, String twoStr) {
        char twoStrChar;
        char oneStrChar;
        if (StringUtils.isBlank((String)oneStr) || StringUtils.isBlank((String)twoStr)) {
            return "";
        }
        StringBuilder res = new StringBuilder();
        int checkedLength = Math.min(oneStr.length(), twoStr.length());
        for (int i = 0; i < checkedLength && (oneStrChar = oneStr.charAt(i)) == (twoStrChar = twoStr.charAt(i)); ++i) {
            res.append(oneStrChar);
        }
        return res.toString();
    }

    public boolean isMindspore() {
        return this.isMindspore;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setMindspore(boolean isMindspore) {
        this.isMindspore = isMindspore;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmartCompletionLookupListener)) {
            return false;
        }
        SmartCompletionLookupListener other = (SmartCompletionLookupListener)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isMindspore() != other.isMindspore()) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        return !(this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SmartCompletionLookupListener;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMindspore() ? 79 : 97);
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        return result;
    }

    public String toString() {
        return "SmartCompletionLookupListener(isMindspore=" + this.isMindspore() + ", prefix=" + this.getPrefix() + ")";
    }

    static {
        SUFFIX_CHAR_SET.addAll(Lists.newArrayList((Object[])new Character[]{Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('\"'), Character.valueOf('\''), Character.valueOf(','), Character.valueOf('+'), Character.valueOf(':'), Character.valueOf('=')}));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/mindspore/ide/toolkit/services/complete/SmartCompletionLookupListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "currentItemChanged";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lookupCanceled";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "itemSelected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

