/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.transplugins;

import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.mindspore.ide.toolkit.common.utils.GsonUtils;
import com.mindspore.ide.toolkit.transplugins.EnvironmentProperty;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Communicator {
    INSTANCE;

    private static final Logger LOG;

    public void setParams(Project project) {
        EnvironmentProperty property = null;
        File file = Paths.get(project.getBasePath() + File.separator + ".mindsporeEnv.json", new String[0]).toFile();
        try (InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
             JsonReader reader = new JsonReader((Reader)fileReader);){
            property = (EnvironmentProperty)GsonUtils.INSTANCE.getGson().fromJson(reader, EnvironmentProperty.class);
        }
        catch (IOException ioException) {
            LOG.warn("Error of reading from property : file is {}", (Object)file.getPath());
        }
        catch (JsonParseException exception) {
            LOG.warn("This file is not a legal json file : path is {}", (Object)file.getPath());
        }
        PropertiesComponent component = PropertiesComponent.getInstance((Project)project);
        if (EnvironmentProperty.valid(property)) {
            component.setValue("mindspore.os", property.getOs());
            LOG.info("mindspore.os : {}", (Object)property.getOs());
            component.setValue("mindspore.hardwarePlatform", property.getHardware());
            LOG.info("mindspore.hardwarePlatfor : {}", (Object)property.getHardware());
        } else {
            LOG.warn("property is invalid : file is {}", (Object)file.getPath());
            component.setValue("mindspore.os", "");
            component.setValue("mindspore.hardwarePlatform", "");
        }
        component.setValue("mindspore.projectPath", project.getBasePath());
        LOG.info("mindspore.projectPath : {}", (Object)project.getBasePath());
    }

    public void invokeModelArts(AnActionEvent event) {
        ActionManager.getInstance().getAction("MAToolkit.EditTrainingJobConfig").actionPerformed(event);
    }

    static {
        LOG = LoggerFactory.getLogger(Communicator.class);
    }
}

