/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.ui.wizard;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CondaDownloadAndInstallDialog
extends JDialog {
    private static final Logger log = LoggerFactory.getLogger(CondaDownloadAndInstallDialog.class);
    JLabel firstLinePromptJLabel;
    JLabel secondLinePromptJLabel;
    TextFieldWithBrowseButton pathBrowseButton;
    JButton installButton;
    JLabel textJLabelNoPath;
    CondaDownloadAndInstallListener condaDownloadAndInstallListener;

    public CondaDownloadAndInstallDialog() {
        this.setTitle("Install Miniconda Automatically");
        this.setModal(true);
        this.setSize(600, 250);
        this.setLocationRelativeTo(null);
        this.init();
        this.setLayout(null);
    }

    public void setCondaDownloadAndInstallListener(CondaDownloadAndInstallListener condaDownloadAndInstallListener) {
        this.condaDownloadAndInstallListener = condaDownloadAndInstallListener;
    }

    private void init() {
        this.firstLinePromptJLabel = new JLabel();
        this.secondLinePromptJLabel = new JLabel();
        this.pathBrowseButton = new TextFieldWithBrowseButton();
        this.installButton = new JButton();
        this.textJLabelNoPath = new JLabel();
        this.firstLinePromptJLabel.setBounds(50, 35, 550, 30);
        this.secondLinePromptJLabel.setBounds(50, 70, 550, 30);
        this.pathBrowseButton.setBounds(50, 105, 350, 30);
        this.installButton.setBounds(450, 105, 100, 35);
        this.textJLabelNoPath.setBounds(50, 150, 400, 20);
        this.firstLinePromptJLabel.setText("Select the CONDA installation path. It is recommended to choose an exist directory.");
        this.secondLinePromptJLabel.setText("Miniconda will be installed into a new directory called 'Miniconda3'");
        this.installButton.setText("Install");
        this.textJLabelNoPath.setText("Please select the conda download and installation path first");
        this.textJLabelNoPath.setForeground(Color.red);
        this.textJLabelNoPath.setVisible(false);
        this.pathBrowseButton.setText(SystemProperties.getUserHome());
        this.add(this.firstLinePromptJLabel);
        this.add(this.secondLinePromptJLabel);
        this.add((Component)this.pathBrowseButton);
        this.add(this.installButton);
        this.add(this.textJLabelNoPath);
        this.pathBrowseButton.addBrowseFolderListener(new TextBrowseFolderListener(new FileChooserDescriptor(false, true, false, false, false, false)){

            @NlsSafe
            protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                String textPath = super.chosenFileToResultingText(chosenFile);
                log.info("Select the CONDA download installation address path : {}", (Object)textPath);
                CondaDownloadAndInstallDialog.this.textJLabelNoPath.setVisible(textPath.equals(""));
                return super.chosenFileToResultingText(chosenFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/mindspore/ide/toolkit/ui/wizard/CondaDownloadAndInstallDialog$1", "chosenFileToResultingText"));
            }
        });
        this.installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                log.info("Click the CONDA download install button");
                CondaDownloadAndInstallDialog.this.textJLabelNoPath.setVisible(CondaDownloadAndInstallDialog.this.pathBrowseButton.getText().equals(""));
                CondaDownloadAndInstallDialog.this.condaDownloadAndInstallListener.getTextString(CondaDownloadAndInstallDialog.this.pathBrowseButton.getText());
            }
        });
    }

    static interface CondaDownloadAndInstallListener {
        public void getTextString(String var1);
    }
}

