# TensorFlow与MindSpore

<a href="https://gitee.com/mindspore/docs/blob/r1.6/docs/mindspore/migration_guide/source_zh_cn/api_mapping/tensorflow_api_mapping.md" target="_blank"><img src="https://gitee.com/mindspore/docs/raw/r1.6/resource/_static/logo_source.png"></a>

由社区提供的TensorFlow APIs和MindSpore APIs之间的映射，可能在参数、输入、输出、逻辑功能和特定场景等方面存在差异，可详见各API描述或已提供的差异对比。

也欢迎更多的MindSpore开发者参与完善映射内容。

## tf

| TensorFlow  1.15 APIs                                                                         | MindSpore APIs                                                                                                                                  | 说明                                                                                                                 |
| --------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------- |
| [tf.arg_max](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/arg_max)                                                           |[mindspore.Tensor.argmax](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.argmax)                                                   |[差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/TensorArgmax.html)|
| [tf.arg_min](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/arg_min)                                                           |[mindspore.Tensor.argmin](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.argmin)                                                   |[差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/TensorArgmin.html)|
| [tf.clip_by_value](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/clip_by_value)                                                           |[mindspore.Tensor.clip](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.clip)                                                   |[差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/TensorClip.html)|
| [tf.expand_dims](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/expand_dims)     | [mindspore.ops.ExpandDims](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.ExpandDims.html)                             |                                                                                                                      |
| [tf.eye](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/eye)                     | [mindspore.ops.Eye](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.Eye.html)                                           |                                                                                                                      |
| [tf.fill](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/fill)                   | [mindspore.ops.Fill](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.Fill.html)                                         |                                                                                                                      |
| [tf.gather](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/gather)               | [mindspore.ops.Gather](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.Gather.html)                                     |                                                                                                                      |
| [tf.gradients](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/gradients)         | [mindspore.ops.GradOperation](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.GradOperation.html)                       | [差异对比](http://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/GradOperation.html) |
| [tf.norm](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/norm)                   | [mindspore.nn.Norm](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.Norm.html)                                            |                                                                                                                      |
| [tf.one_hot](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/one_hot)             | [mindspore.nn.OneHot](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.OneHot.html)                                        |                                                                                                                      |
| [tf.ones_like](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/ones_like)         | [mindspore.ops.OnesLike](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.OnesLike.html)                                 |                                                                                                                      |
| [tf.pad](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/pad)                     | [mindspore.nn.Pad](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.Pad.html)                                              |                                                                                                                      |
| [tf.print](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/print)                 | [mindspore.ops.Print](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.Print.html)                                       |                                                                                                                      |
| [tf.repeat](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/repeat)                                                         |[mindspore.Tensor.repeat](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.repeat)                                                                                                |                                                                                                                      |
| [tf.reshape](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/reshape)             | [mindspore.ops.Reshape](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.Reshape.html)                                   |                                                                                                                      |
| [tf.reshape](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/reshape)                                                         |[mindspore.Tensor.reshape](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.reshape)                                                                                               |                                                                                                                      |
| [tf.shape](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/shape)                 | [mindspore.ops.Shape](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.Shape.html)                                       |                                                                                                                      |
| [tf.size](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/size)                   | [mindspore.ops.Size](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.Size.html)                                         |                                                                                                                      |
| [tf.slice](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/slice)                 | [mindspore.ops.Slice](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.Slice.html)                                       |                                                                                                                      |
| [tf.squeeze](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/squeeze)                                           |[mindspore.Tensor.squeeze](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.squeeze)                                                 |  |
| [tf.stop_gradient](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/stop_gradient) | [mindspore.ops.stop_gradient](https://mindspore.cn/tutorials/zh-CN/r1.6/autograd.html#%E5%81%9C%E6%AD%A2%E8%AE%A1%E7%AE%97%E6%A2%AF%E5%BA%A6) |                                                                                                                      |
| [tf.Tensor](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/Tensor)               | [mindspore.Tensor](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/mindspore/mindspore.Tensor.html)                                       |                                                                                                                      |
| [tf.tile](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/tile)                   | [mindspore.ops.Tile](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.Tile.html)                                         |                                                                                                                      |
| [tf.transpose](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/transpose)         | [mindspore.ops.Transpose](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.Transpose.html)                               |                                                                                                                      |
| [tf.zeros_like](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/zeros_like)       | [mindspore.ops.ZerosLike](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.ZerosLike.html)                               |                                                                                                                      |

## tf.distribute

| TensorFlow  1.15 APIs                                                                                     | MindSpore APIs                                                                                                                                                                                          | 说明                                                                                                                     |
| --------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------ |
| [tf.distribute.Strategy](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/distribute/Strategy) | [context.set_auto_parallel_context(parallel_mode=ParallelMode.DATA_PARALLEL)](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/mindspore.context.html#mindspore.context.set_auto_parallel_context) | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/DistributedTrain.html) |

## tf.image

| TensorFlow  1.15 APIs                                                                         | MindSpore APIs                                                                                                                                  | 说明                                                                                                                 |
| --------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------- |
| [tf.image.ssim](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/image/ssim)       | [mindspore.nn.SSIM](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.SSIM.html)                                            |                                                                                                                      |

## tf.keras

| TensorFlow  1.15 APIs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | MindSpore APIs                                                                                                                                                                       | 说明                                                                                                                      |
| --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------- |
| [tf.keras.initializers.Constant](https://www.tensorflow.org/api_docs/python/tf/keras/initializers/Constant)                                                                                                                                                                                                                                                                                                                                                                                                           | [mindspore.common.initializer.Constant](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/mindspore.common.initializer.html#mindspore.common.initializer.Constant)               | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/initConst.html)         |
| [tf.keras.initializers.Ones](https://www.tensorflow.org/api_docs/python/tf/keras/initializers/Ones)                                                                                                                                                                                                                                                                                                                                                                                                                   | [mindspore.common.initializer.One](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/mindspore.common.initializer.html#mindspore.common.initializer.One)                         |                                                                                                                           |
| [tf.keras.initializers.RandomNormal](https://www.tensorflow.org/api_docs/python/tf/keras/initializers/RandomNormal)                                                                                                                                                                                                                                                                                                                                                                                                   | [mindspore.common.initializer.Normal](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/mindspore.common.initializer.html#mindspore.common.initializer.Normal)                   | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/initNormal.html)        |
| [tf.keras.initializers.TruncatedNormal](https://www.tensorflow.org/api_docs/python/tf/keras/initializers/TruncatedNormal)                                                                                                                                                                                                                                                                                                                                                                                             | [mindspore.common.initializer.TruncatedNormal](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/mindspore.common.initializer.html#mindspore.common.initializer.TruncatedNormal) | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/initTruncNormal.html)   |
| [tf.keras.initializers.RandomUniform](https://www.tensorflow.org/api_docs/python/tf/keras/initializers/RandomUniform)                                                                                                                                                                                                                                                                                                                                                                                                 | [mindspore.common.initializer.Uniform](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/mindspore.common.initializer.html#mindspore.common.initializer.Uniform)                 | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/initUniform.html)       |
| [tf.keras.initializers.VarianceScaling](https://www.tensorflow.org/api_docs/python/tf/keras/initializers/VarianceScaling)                                                                                                                                                                                                                                                                                                                                                                                             | [mindspore.common.initializer.XavierUniform](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/mindspore.common.initializer.html#mindspore.common.initializer.XavierUniform)     | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/initXavierUniform.html) |
| [tf.keras.initializers.Zeros](https://www.tensorflow.org/api_docs/python/tf/keras/initializers/Zeros)                                                                                                                                                                                                                                                                                                                                                                                                                 | [mindspore.common.initializer.Zero](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/mindspore.common.initializer.html#mindspore.common.initializer.Zero)                       |                                                                                                                           |
| [tf.keras.backend.batch_dot](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/backend/batch_dot)                                                                                                                                                                                                                                                                                                                                                                                                     | [mindspore.ops.batch_dot](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.batch_dot.html)                                                                    |                                                                                                                           |
| [tf.keras.backend.dot](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/backend/dot)                                                                                                                                                                                                                                                                                                                                                                                                                 | [mindspore.ops.dot](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.batch_dot.html)                                                                          |                                                                                                                           |
| [tf.keras.layers.Embedding](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/layers/Embedding)                                                                                                                                                                                                                                                                                                                                                                                                       | [mindspore.nn.Embedding](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.Embedding.html)                                                                       |                                                                                                                           |
| [tf.keras.layers.Flatten](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/layers/Flatten)                                                                                                                                                                                                                                                                                                                                                                                                           | [mindspore.nn.Flatten](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.Flatten.html)                                                                           |                                                                                                                           |
| [tf.keras.layers.LayerNormalization](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/layers/LayerNormalization)                                                                                                                                                                                                                                                                                                                                                                                     | [mindspore.nn.LayerNorm](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.LayerNorm.html)                                                                       |                                                                                                                           |
| [tf.keras.layers.LSTM](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/layers/LSTM)                                                                                                                                                                                                                                                                                                                                                                                                                 | [mindspore.nn.LSTM](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.LSTM.html)                                                                                 |                                                                                                                           |
| [tf.keras.layers.PReLU](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/layers/PReLU)                                                                                                                                                                                                                                                                                                                                                                                                               | [mindspore.nn.PReLU](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.PReLU.html)                                                                               |                                                                                                                           |
| [tf.keras.layers.RNN](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/layers/RNN)                                                                                                                                                                                                                                                                                                                                                                                                                   | [mindspore.ops.DynamicRNN](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.DynamicRNN.html)                                                                  |                                                                                                                           |
| [tf.keras.Model](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/Model)                                                                                                                                                                        | [mindspore.Model](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/mindspore/mindspore.Model.html#mindspore.Model)                                                                                 | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/Model.html)              |
| [tf.keras.Model.fit](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/Model#fit) <br>  [tf.keras.Model.fit_generator]( https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/Model#fit_generator)                                                                                                                                                                       | [mindspore.Model.train](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/mindspore/mindspore.Model.html#mindspore.Model.train)                                                                                 | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/ModelTrain.html)              |
| [tf.keras.Model.predict]( https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/Model#predict) <br>  [tf.keras.Model.predict_generator]( https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/Model#predict_generator)                                                                                                                                                                      | [mindspore.Model.eval](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/mindspore/mindspore.Model.html#mindspore.Model.eval)                                                                                 | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/ModelEval.html)              |
| [tf.keras.optimizers.Adagrad](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/optimizers/Adagrad)                                                                                                                                                                                                                                                                                                                                                                                                   | [mindspore.nn.Adagrad](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.Adagrad.html)                                                                           | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/Adagrad.html)           |
| [tf.keras.optimizers.Adam](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/optimizers/Adam)                                                                                                                                                                                                                                                                                                                                                                                                         | [mindspore.nn.Adam](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.Adam.html)                                                                                 | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/Adam.html)              |
| [tf.keras.optimizers.Ftrl](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/optimizers/Ftrl)                                                                                                                                                                                                                                                                                                                                                                                                        | [mindspore.nn.FTRL](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.FTRL.html)                                                                                 | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/Ftrl.html)              |
| [tf.keras.optimizers.RMSprop](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/optimizers/RMSprop)                                                                                                                                                                                                                                                                                                                                                                                                  | [mindspore.nn.RMSProp](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.RMSProp.html#mindspore.nn.RMSProp)                                                      | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/RMSProp.html)           |
| [tf.keras.optimizers.SGD](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/optimizers/SGD)                                                                                                                                                                                                                                                                                                                                                                                                           | [mindspore.nn.SGD](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.SGD.html)                                                                                   | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/SGD.html)               |
| [tf.keras.metrics.Accuracy](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/Accuracy) <br> [tf.keras.metrics.BinaryAccuracy](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/BinaryAccuracy) <br> [tf.keras.metrics.CategoricalAccuracy](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/CategoricalAccuracy) <br>  [tf.keras.metrics.SparseCategoricalAccuracy](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/SparseCategoricalAccuracy) | [mindspore.nn.Accuracy](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.Accuracy.html#mindspore.nn.Accuracy)                                                   | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/metricAcc.html)         |
| [tf.keras.metrics.AUC](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/AUC)                                                                                                                                                                                                                                                                                                                                                                                                                | [mindspore.nn.auc](https://www.mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.auc.html)                                                                               | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/metricAUC.html)   |
| [tf.keras.metrics.CosineSimilarity](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/CosineSimilarity)                                                                                                                                                                                                                                                                                                                                                                                            | [mindspore.nn.CosineSimilarity](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.CosineSimilarity.html#mindspore.nn.CosineSimilarity)                           | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/metricCosineSim.html)   |
| [tf.keras.metrics.Mean](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/Mean)                                                                                                                                                                                                                                                                                                                                                                                                                    | [mindspore.nn.Loss](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.Loss.html#mindspore.nn.Loss)                                                               |                                                                                                                   |
| [tf.keras.metrics.MeanAbsoluteError](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/MeanAbsoluteError)                                                                                                                                                                                                                                                                                                                                                                                    | [mindspore.nn.MAE](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.MAE.html#mindspore.nn.MAE)                                                                  |                                                                                                                   |
| [tf.keras.metrics.MeanSquaredError](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/MeanSquaredError)                                                                                                                                                                                                                                                                                                                                                                                      | [mindspore.nn.MSE](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.MSE.html#mindspore.nn.MSE)                                                                  |                                                                                                                   |
| [tf.keras.metrics.Precision](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/Precision)                                                                                                                                                                                                                                                                                                                                                                                                          | [mindspore.nn.Precision](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.Precision.html#mindspore.nn.Precision)                                                | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/metricPrecision.html)   |
| [tf.keras.metrics.Recall](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/Recall)                                                                                                                                                                                                                                                                                                                                                                                                                | [mindspore.nn.Recall](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.Recall.html#mindspore.nn.Recall)                                                         | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/metricRecall.html)      |

## tf.layers

| TensorFlow  1.15 APIs                                                                       | MindSpore APIs                                                                                         | 说明 |
| ------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------ | ---- |
| [tf.layers.Dense](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/layers/Dense) | [mindspore.nn.Dense](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.Dense.html) |      |

## tf.linalg

| TensorFlow  1.15 APIs                                                                         | MindSpore APIs                                                                                           | 说明 |
| --------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | ---- |
| [tf.linalg.inv](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/linalg/inv)       | [mindspore.ops.Inv](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.Inv.html)    |      |
| [tf.linalg.matmul](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/linalg/matmul) | [mindspore.nn.MatMul](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.MatMul.html) |      |

## tf.math

| TensorFlow  1.15 APIs                                                                             | MindSpore APIs                                                                                                    | 说明 |
| ------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------- | ---- |
| [tf.math.add](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/add)               | [mindspore.ops.Add](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.Add.html)             |      |
| [tf.math.cumsum](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/cumsum)                                                           |[mindspore.Tensor.cumsum](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.cumsum)                                                   |[差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/TensorCumsum.html)|
| [tf.math.divide](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/divide)         | [mindspore.ops.Div](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.Div.html)             |      |
| [tf.math.erf](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/erf)               | [mindspore.ops.Erf](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.Erf.html)             |      |
| [tf.math.greater](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/greater)       | [mindspore.ops.Greater](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.Greater.html)     |      |
| [tf.math.less_equal](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/less_equal) | [mindspore.ops.LessEqual](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.LessEqual.html) |      |
| [tf.math.log](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/log)               | [mindspore.ops.Log](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.Log.html)             |      |
| [tf.math.multiply](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/multiply)     | [mindspore.ops.Mul](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.Mul.html)             |      |
| [tf.math.pow](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/pow)               | [mindspore.ops.Pow](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.Pow.html)             |      |
| [tf.math.reduce_std](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/reduce_std)                                                           |[mindspore.Tensor.std](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.std)                                                   |[差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/TensorStd.html)|
| [tf.math.reduce_sum](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/reduce_sum)                                                           |[mindspore.Tensor.sum](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.sum)                                                   |[差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/TensorSum.html)|
| [tf.math.reduce_variance](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/reduce_variance)                                                           |[mindspore.Tensor.var](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.var)                                                   |[差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/TensorVar.html)|
| [tf.math.sigmoid](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/sigmoid)       | [mindspore.nn.Sigmoid](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.Sigmoid.html)        |      |
| [tf.math.subtract](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/subtract)     | [mindspore.ops.Sub](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.Sub.html)             |      |

## tf.metrics

| TensorFlow  1.15 APIs                                                                               | MindSpore APIs                                                                                        | 说明     |
| --------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------- | -------- |
| [tf.metrics.mean_iou](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/metrics/mean_iou) | [mindspore.ops.IOU](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.IOU.html) |  |

## tf.nn

| TensorFlow  1.15 APIs                                                                                                                       | MindSpore APIs                                                                                                                                            | 说明                                                                                                                                  |
| ------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------- |
| [tf.nn.avg_pool2d](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/avg_pool2d)                                               | [mindspore.nn.AvgPool2d](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.AvgPool2d.html)                                            |                                                                                                                                       |
| [tf.nn.batch_normalization](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/batch_normalization)                             | [mindspore.ops.BatchNorm](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.BatchNorm.html)                                         |                                                                                                                                       |
| [tf.nn.bias_add](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/bias_add)                                                   | [mindspore.ops.BiasAdd](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.BiasAdd.html)                                             |                                                                                                                                       |
| [tf.nn.conv2d](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/conv2d)                                                       | [mindspore.nn.Conv2d](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.Conv2d.html)                                                  |                                                                                                                                       |
| [tf.nn.conv2d_transpose](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/conv2d_transpose)                                   | [mindspore.nn.Conv2dTranspose](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.Conv2dTranspose.html)                                |                                                                                                                                       |
| [tf.nn.ctc_loss](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/ctc_loss)                                                   | [mindspore.ops.CTCLoss](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.CTCLoss.html)                                             |                                                                                                                                       |
| [tf.nn.dropout](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/dropout)                                                     | [mindspore.nn.Dropout](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.Dropout.html)                                                |                                                                                                                                       |
| [tf.nn.elu](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/elu)                                                             | [mindspore.nn.ELU](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.ELU.html)                                                        |                                                                                                                                       |
| [tf.nn.l2_loss](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/l2_loss)                                                     | [mindspore.ops.L2Loss](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.L2Loss.html)                                               |                                                                                                                                       |
| [tf.nn.l2_normalize](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/l2_normalize)                                           | [mindspore.ops.L2Normalize](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.L2Normalize.html)                                     |                                                                                                                                       |
| [tf.nn.leaky_relu](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/leaky_relu)                                               | [mindspore.nn.LeakyReLU](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.LeakyReLU.html)                                            |                                                                                                                                       |
| [tf.nn.max_pool_with_argmax](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/max_pool_with_argmax)                           | [mindspore.ops.MaxPoolWithArgmax](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.MaxPoolWithArgmax.html)                         |                                                                                                                                       |
| [tf.nn.max_pool2d](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/max_pool2d)                                               | [mindspore.nn.MaxPool2d](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.MaxPool2d.html)                                            |                                                                                                                                       |
| [tf.nn.moments](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/moments)                                                     | [mindspore.nn.Moments](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.Moments.html)                                                |                                                                                                                                       |
| [tf.nn.relu](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/relu)                                                           | [mindspore.nn.ReLU](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.ReLU.html)                                                      |                                                                                                                                       |
| [tf.nn.selu](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/selu)                                                           | [mindspore.ops.SeLU](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.SeLU.html)                                                   |                                                                                                                                       |
| [tf.nn.sigmoid_cross_entropy_with_logits](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/sigmoid_cross_entropy_with_logits) | [mindspore.ops.SigmoidCrossEntropyWithLogits](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.SigmoidCrossEntropyWithLogits.html) |                                                                                                                                       |
| [tf.nn.softmax](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/softmax)                                                     | [mindspore.nn.Softmax](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.Softmax.html)                                                |                                                                                                                                       |
| [tf.nn.softmax_cross_entropy_with_logits](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/softmax_cross_entropy_with_logits) | [mindspore.nn.SoftmaxCrossEntropyWithLogits](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.SoftmaxCrossEntropyWithLogits.html)    | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/SoftmaxCrossEntropyWithLogits.html) |

## tf.random

| TensorFlow  1.15 APIs                                                                           | MindSpore APIs                                                                                                | 说明 |
| ----------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------- | ---- |
| [tf.random.gamma](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/random/gamma)     | [mindspore.ops.Gamma](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.Gamma.html)     |      |
| [tf.random.uniform](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/random/uniform) | [mindspore.ops.uniform](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/ops/mindspore.ops.uniform.html) |      |

## tf.sparse

| TensorFlow  1.15 APIs                                                                                     | MindSpore APIs                                                                                                        | 说明 |
| --------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------- | ---- |
| [tf.sparse.SparseTensor](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/sparse/SparseTensor) | [mindspore.SparseTensor](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/mindspore/mindspore.SparseTensor.html) |      |

## tf.train

| TensorFlow  1.15 APIs                                                                                                            | MindSpore APIs                                                                                                                                          | 说明                                                                                                                    |
| -------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------- |
| [tf.train.ProximalAdagradOptimizer](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/train/ProximalAdagradOptimizer) | [mindspore.nn.ProximalAdagrad](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.ProximalAdagrad.html#mindspore.nn.ProximalAdagrad) | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/ProximalAdagrad.html) |
| [tf.train.exponential_decay](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/train/exponential_decay)                | [mindspore.nn.ExponentialDecayLR](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.ExponentialDecayLR.html)                        |                                                                                                                         |
| [tf.train.linear_cosine_decay](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/train/linear_cosine_decay)            | [mindspore.nn.CosineDecayLR](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.CosineDecayLR.html)                                  | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/CosineDecayLR.html)   |
| [tf.train.MomentumOptimizer](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/train/MomentumOptimizer)                | [mindspore.nn.Momentum](https://mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn/mindspore.nn.Momentum.html)                                            | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_diff/Momentum.html)        |

## tfp

| TensorFlow Probability 0.14.1 APIs                                                                     | MindSpore APIs                                                                                                                                                         | 说明                                                                                                                                 |
| ------------------------------------------------------------------------------------------------------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------ |
| [tfp.bijectors.Softplus](https://www.tensorflow.org/probability/api_docs/python/tfp/bijectors/Softplus) | [mindspore.nn.probability.bijector.Softplus](https://www.mindspore.cn/docs/api/zh-CN/r1.6/api_python/nn_probability/mindspore.nn.probability.bijector.Softplus.html) | [差异对比](https://www.mindspore.cn/docs/migration_guide/zh-CN/r1.6/api_mapping/tensorflow_probability_diff/BijectorSoftplus.html) |
