/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.smartcomplete;

import com.intellij.notification.NotificationType;
import com.mindspore.ide.toolkit.common.utils.FileUtils;
import com.mindspore.ide.toolkit.common.utils.NotificationUtils;
import com.mindspore.ide.toolkit.protomessage.CompleteReply;
import com.mindspore.ide.toolkit.smartcomplete.CompleteConfig;
import com.mindspore.ide.toolkit.smartcomplete.grpc.CompletionException;
import com.mindspore.ide.toolkit.smartcomplete.grpc.PortUtil;
import com.mindspore.ide.toolkit.smartcomplete.grpc.SmartCompletionClient;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelProcess {
    private static final Logger log = LoggerFactory.getLogger(ModelProcess.class);
    private final CompleteConfig completeConfig = CompleteConfig.get();
    private Process proc;
    private int port;
    private static final Integer DEFAULT_PORT = 50053;
    private volatile boolean isInited = false;

    public void initModel(CompleteConfig.Model model) {
        this.isInited = false;
        String notifyContent = "Init smart complete model %s. Plugin version is " + model.getPluginVersion() + ". Model version is " + model.getModelVersion() + ".";
        try {
            this.initProcessAndPort(model);
        }
        catch (IOException ioException) {
            log.info("Init smart complete model failed. Plugin version is {}. Model version is {}.", new Object[]{model.getPluginVersion(), model.getModelVersion(), ioException});
        }
        if (this.isInited) {
            NotificationUtils.notify(NotificationUtils.NotifyGroup.SMART_COMPLETE, NotificationType.INFORMATION, String.format(notifyContent, "succeed"));
        } else {
            NotificationUtils.notify(NotificationUtils.NotifyGroup.SMART_COMPLETE, NotificationType.ERROR, String.format(notifyContent, "failed"));
        }
    }

    public void shutDownModel() {
        this.isInited = false;
        if (this.proc == null) {
            return;
        }
        this.proc.destroy();
        this.proc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<CompleteReply> retrieveCompletions(String before, String options) throws CompletionException {
        ManagedChannel channel = this.getChannel();
        try {
            SmartCompletionClient client = new SmartCompletionClient((Channel)channel);
            Optional<CompleteReply> optional = client.retrieveCompletions(before, options);
            return optional;
        }
        finally {
            channel.shutdownNow();
        }
    }

    public boolean isAlive() {
        if (this.proc == null) {
            return false;
        }
        return this.proc.isAlive();
    }

    public boolean isInited() {
        return this.isInited;
    }

    private void initProcessAndPort(CompleteConfig.Model model) throws IOException {
        this.port = PortUtil.findAnIdlePort(DEFAULT_PORT);
        if (this.port == 0) {
            log.info("Cannot find available port, init complete model failed. Model version is {}.", (Object)model.getModelVersion());
        } else {
            if (this.proc != null) {
                this.proc.destroy();
                this.proc = null;
            }
            this.initProcess(model);
            this.isInited = true;
        }
    }

    private void initProcess(CompleteConfig.Model model) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(this.completeConfig.getModelExeFullPath(model), "-p", String.valueOf(this.port));
        builder.directory(FileUtils.getFile(this.completeConfig.getModelUnzipFolderFullPath(model)));
        this.proc = builder.start();
    }

    private ManagedChannel getChannel() throws CompletionException {
        return ManagedChannelBuilder.forTarget((String)("localhost:" + this.port)).usePlaintext().build();
    }
}

