/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.search;

import com.mindspore.ide.toolkit.search.SearchEveryWhereDataHub;
import com.mindspore.ide.toolkit.search.structure.TrieNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum OperatorSearchService {
    INSTANCE;

    private TrieNode root = new TrieNode();
    private SearchEveryWhereDataHub<String> mdFile2Map = SearchEveryWhereDataHub.getOperatorDataHub();

    private OperatorSearchService() {
        this.mdFile2Map.searchable().forEach(this.root::addWord);
    }

    public Map<String, String> search(String inputString) {
        return this.search(inputString, Integer.MAX_VALUE);
    }

    public Map<String, String> search(String inputString, int count) {
        if (inputString == null || inputString.isEmpty()) {
            return new HashMap<String, String>();
        }
        List<String> topSearch = this.root.search(inputString, count);
        return this.mdFile2Map.assemble(topSearch, inputString, count);
    }
}

