/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.wizard;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.ui.DocumentAdapter;
import com.jetbrains.python.newProject.steps.ProjectSpecificSettingsStep;
import com.mindspore.ide.toolkit.common.utils.OSInfoUtils;
import com.mindspore.ide.toolkit.common.utils.PathUtils;
import com.mindspore.ide.toolkit.common.utils.RegularUtils;
import com.mindspore.ide.toolkit.ui.wizard.WizardMsSettingProjectPeer;
import com.mindspore.ide.toolkit.wizard.MiniCondaService;
import com.mindspore.ide.toolkit.wizard.MsCondaEnvService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomMSProjectStep
extends ProjectSpecificSettingsStep {
    private WizardMsSettingProjectPeer projectPeer;

    public CustomMSProjectStep(@NotNull DirectoryProjectGenerator projectGenerator, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AbstractNewProjectStep.AbstractCallback callback, WizardMsSettingProjectPeer projectPeer) {
        if (projectGenerator == null) {
            CustomMSProjectStep.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            CustomMSProjectStep.$$$reportNull$$$0(1);
        }
        super(projectGenerator, callback);
        this.projectPeer = projectPeer;
    }

    protected JPanel createBasePanel() {
        BorderLayout layout = new BorderLayout();
        JPanel locationPanel = new JPanel(layout);
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 2));
        LabeledComponent location = this.createLocationComponent();
        this.setProjectPath();
        locationPanel.add((Component)location, "Center");
        panel.add(locationPanel);
        panel.add(this.projectPeer.getMainPanel());
        return panel;
    }

    @Nullable
    protected JPanel createAdvancedSettings() {
        return null;
    }

    public boolean checkValid() {
        OSInfoUtils osInfoUtils = OSInfoUtils.INSTANCE;
        if (!(osInfoUtils.isLinux() || osInfoUtils.isWindows() || osInfoUtils.isMacOsX86())) {
            this.setWarningText("os not support");
            return false;
        }
        if (RegularUtils.isEmpty(this.projectPeer.getCondaPath()) || !Files.exists(Path.of(this.projectPeer.getCondaPath(), new String[0]), new LinkOption[0]) || !this.projectPeer.getCondaPath().endsWith("conda.exe") && !this.projectPeer.getCondaPath().endsWith("conda")) {
            this.setWarningText("Conda executable not exist or wrong");
            return false;
        }
        if (this.myLocationField.getText().endsWith(" ")) {
            this.setWarningText("Project Location end with space!");
            return false;
        }
        this.setWarningText("Project Location has been fixed!");
        if (osInfoUtils.isLinux() && !PathUtils.judgeIsChildPath(MiniCondaService.getCondaEnvsPath(this.projectPeer.getCondaPath()), this.projectPeer.getCondaEnvPath())) {
            this.setWarningText("This environment path is invalid. Please choose new environment location in Conda install path.");
            return false;
        }
        if (this.projectPeer.isUsingNewCondaEnv()) {
            if (RegularUtils.isEmpty(this.projectPeer.getCondaEnvPath())) {
                this.setWarningText("Env location is empty");
                return false;
            }
            if (Files.exists(Path.of(this.projectPeer.getCondaEnvPath(), new String[0]), new LinkOption[0])) {
                this.setWarningText("Env location exists!");
                return false;
            }
        } else {
            if (this.projectPeer.getExistSdkString().isEmpty()) {
                this.setWarningText("Please choose a conda env!");
                return false;
            }
            if (!Files.exists(Path.of(this.projectPeer.getExistSdk().getHomePath(), new String[0]), new LinkOption[0])) {
                this.setWarningText("Selected interpreter is broken. Please choose another one or create a new environment!");
                return false;
            }
        }
        return true;
    }

    @Nullable
    public Sdk getSdk() {
        if (this.projectPeer.isUsingNewCondaEnv()) {
            return MsCondaEnvService.newLazySdk(this.projectPeer.getCondaPath(), this.projectPeer.getCondaEnvPath(), this.projectPeer.getPythonVersion());
        }
        return this.projectPeer.getExistSdk();
    }

    private void setProjectPath() {
        this.myLocationField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                CustomMSProjectStep.this.projectPeer.setCondaEnvPath(CustomMSProjectStep.getProjectNameByOs(CustomMSProjectStep.this.myLocationField.getText()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/mindspore/ide/toolkit/wizard/CustomMSProjectStep$1", "textChanged"));
            }
        });
        this.projectPeer.setCondaEnvPath(CustomMSProjectStep.getProjectNameByOs(this.myLocationField.getText()));
    }

    private static String getProjectNameByOs(String projectPath) {
        return Path.of(RegularUtils.normalizeFilePath(projectPath), new String[0]).getFileName().toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "projectGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "callback";
                break;
            }
        }
        objectArray[1] = "com/mindspore/ide/toolkit/wizard/CustomMSProjectStep";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

