/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gitlab.internal;

import com.vladsch.flexmark.ext.gitlab.GitLabExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSetter;
import com.vladsch.flexmark.util.misc.CharPredicate;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class GitLabOptions
implements MutableDataSetter {
    public final boolean insParser;
    public final boolean delParser;
    public final boolean inlineMathParser;
    public final boolean blockQuoteParser;
    public final boolean nestedBlockQuotes;
    public final boolean renderBlockMath;
    public final boolean renderBlockMermaid;
    public final boolean renderVideoImages;
    public final boolean renderVideoLink;
    public final String inlineMathClass;
    public final String blockMathClass;
    public final String blockMermaidClass;
    public final String[] mathLanguages;
    public final String[] mermaidLanguages;
    public final String videoImageClass;
    public final String videoImageLinkTextFormat;
    public final String videoImageExtensions;
    public final HashSet<String> videoImageExtensionSet;
    @Deprecated
    public final String blockInfoDelimiters;
    @Deprecated
    public final CharPredicate blockInfoDelimiterSet;

    public GitLabOptions(DataHolder options) {
        String[] extensions;
        this.insParser = (Boolean)GitLabExtension.INS_PARSER.get(options);
        this.delParser = (Boolean)GitLabExtension.DEL_PARSER.get(options);
        this.inlineMathParser = (Boolean)GitLabExtension.INLINE_MATH_PARSER.get(options);
        this.blockQuoteParser = (Boolean)GitLabExtension.BLOCK_QUOTE_PARSER.get(options);
        this.nestedBlockQuotes = (Boolean)GitLabExtension.NESTED_BLOCK_QUOTES.get(options);
        this.inlineMathClass = (String)GitLabExtension.INLINE_MATH_CLASS.get(options);
        this.renderBlockMath = (Boolean)GitLabExtension.RENDER_BLOCK_MATH.get(options);
        this.renderBlockMermaid = (Boolean)GitLabExtension.RENDER_BLOCK_MERMAID.get(options);
        this.renderVideoImages = (Boolean)GitLabExtension.RENDER_VIDEO_IMAGES.get(options);
        this.renderVideoLink = (Boolean)GitLabExtension.RENDER_VIDEO_LINK.get(options);
        this.blockMathClass = (String)GitLabExtension.BLOCK_MATH_CLASS.get(options);
        this.blockMermaidClass = (String)GitLabExtension.BLOCK_MERMAID_CLASS.get(options);
        this.blockInfoDelimiters = (String)HtmlRenderer.FENCED_CODE_LANGUAGE_DELIMITERS.get(options);
        this.blockInfoDelimiterSet = CharPredicate.anyOf((CharSequence)this.blockInfoDelimiters);
        this.mathLanguages = (String[])GitLabExtension.MATH_LANGUAGES.get(options);
        this.mermaidLanguages = (String[])GitLabExtension.MERMAID_LANGUAGES.get(options);
        this.videoImageClass = (String)GitLabExtension.VIDEO_IMAGE_CLASS.get(options);
        this.videoImageLinkTextFormat = (String)GitLabExtension.VIDEO_IMAGE_LINK_TEXT_FORMAT.get(options);
        this.videoImageExtensions = (String)GitLabExtension.VIDEO_IMAGE_EXTENSIONS.get(options);
        this.videoImageExtensionSet = new HashSet();
        for (String ext : extensions = this.videoImageExtensions.split(",")) {
            String trimmed = ext.trim();
            if (trimmed.isEmpty()) continue;
            this.videoImageExtensionSet.add(trimmed);
        }
    }

    @NotNull
    public MutableDataHolder setIn(@NotNull MutableDataHolder dataHolder) {
        dataHolder.set(GitLabExtension.INS_PARSER, (Object)this.insParser);
        dataHolder.set(GitLabExtension.DEL_PARSER, (Object)this.delParser);
        dataHolder.set(GitLabExtension.INLINE_MATH_PARSER, (Object)this.inlineMathParser);
        dataHolder.set(GitLabExtension.BLOCK_QUOTE_PARSER, (Object)this.blockQuoteParser);
        dataHolder.set(GitLabExtension.NESTED_BLOCK_QUOTES, (Object)this.nestedBlockQuotes);
        dataHolder.set(GitLabExtension.INLINE_MATH_CLASS, (Object)this.inlineMathClass);
        dataHolder.set(GitLabExtension.RENDER_BLOCK_MATH, (Object)this.renderBlockMath);
        dataHolder.set(GitLabExtension.RENDER_BLOCK_MERMAID, (Object)this.renderBlockMermaid);
        dataHolder.set(GitLabExtension.RENDER_VIDEO_IMAGES, (Object)this.renderVideoImages);
        dataHolder.set(GitLabExtension.RENDER_VIDEO_LINK, (Object)this.renderVideoLink);
        dataHolder.set(GitLabExtension.BLOCK_MATH_CLASS, (Object)this.blockMathClass);
        dataHolder.set(GitLabExtension.BLOCK_MERMAID_CLASS, (Object)this.blockMermaidClass);
        dataHolder.set(HtmlRenderer.FENCED_CODE_LANGUAGE_DELIMITERS, (Object)this.blockInfoDelimiters);
        dataHolder.set(GitLabExtension.VIDEO_IMAGE_CLASS, (Object)this.videoImageClass);
        dataHolder.set(GitLabExtension.VIDEO_IMAGE_LINK_TEXT_FORMAT, (Object)this.videoImageLinkTextFormat);
        dataHolder.set(GitLabExtension.VIDEO_IMAGE_EXTENSIONS, (Object)this.videoImageExtensions);
        return dataHolder;
    }
}

