/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.ui.wizard;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.mindspore.ide.toolkit.common.utils.FileUtils;
import com.mindspore.ide.toolkit.common.utils.NotificationUtils;
import com.mindspore.ide.toolkit.common.utils.OSInfoUtils;
import com.mindspore.ide.toolkit.common.utils.PathUtils;
import com.mindspore.ide.toolkit.common.utils.RegularUtils;
import com.mindspore.ide.toolkit.common.utils.VersionUtils;
import com.mindspore.ide.toolkit.ui.wizard.AbstractMsSettingProjectPeer;
import com.mindspore.ide.toolkit.ui.wizard.CondaDownloadAndInstallDialog;
import com.mindspore.ide.toolkit.wizard.MSVersionInfo;
import com.mindspore.ide.toolkit.wizard.MindSporeService;
import com.mindspore.ide.toolkit.wizard.MiniCondaService;
import com.mindspore.ide.toolkit.wizard.MsVersionManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardMsSettingProjectPeer
extends AbstractMsSettingProjectPeer {
    private static final Logger log = LoggerFactory.getLogger(WizardMsSettingProjectPeer.class);
    private HashMap<String, Sdk> condaMap = new HashMap();
    private HashSet<MSVersionInfo> hardwarePlatformSet;

    public WizardMsSettingProjectPeer() {
        this.addItemsToHardwareSelector();
        this.setCondExePath("");
        this.buttonListener();
        this.initCondaMap();
        this.initTemplateSelector();
    }

    public void resetBrowserButton() {
        this.buttonListener();
    }

    public String getCondaPath() {
        return RegularUtils.normalizeFilePath(this.condaExecutableTextField.getText());
    }

    public String getPythonVersion() {
        return this.pythonVersionSelector.getSelectedItem().toString();
    }

    public boolean isUsingNewCondaEnv() {
        return this.newEnvironmentUsingRadioButton.isSelected();
    }

    public String getTemplate() {
        return this.templateSelector.getSelectedItem().toString();
    }

    public Sdk getExistSdk() {
        return this.condaMap.get(this.existEnvSelector.getSelectedItem().toString());
    }

    public Optional<String> getExistSdkString() {
        return this.existEnvSelector.getSelectedItem() == null ? Optional.empty() : Optional.of(this.existEnvSelector.getSelectedItem().toString());
    }

    @Override
    public void addItemsToHardwareSelector() {
        this.hardwarePlatformSet = MsVersionManager.INSTANCE.hardwarePlatformInfo();
        this.hardwareSelector.setModel(new DefaultComboBoxModel<MSVersionInfo>(this.hardwarePlatformSet.toArray(new MSVersionInfo[0])));
        this.hardwareSelector.setRenderer((list, value, index, isSelected, isCellHasFocus) -> {
            JPanel panel = new JPanel();
            if (value instanceof MSVersionInfo) {
                MSVersionInfo info = (MSVersionInfo)value;
                panel.setLayout(new BorderLayout());
                JLabel hardware = new JLabel(info.getName());
                JLabel desc = new JLabel(info.getDes());
                desc.setForeground(new Color(255, 180, 35));
                panel.add((Component)hardware, "West");
                panel.add((Component)desc, "East");
                if (isSelected) {
                    panel.setBackground(new Color(75, 110, 175));
                }
            }
            return panel;
        });
        this.hardwareSelector.setSelectedIndex(-1);
        if (this.hardwareSelector.getItemCount() > 0) {
            this.hardwareSelector.setSelectedIndex(0);
        }
    }

    public String getHardwareValue() {
        if (this.hardwareSelector.getSelectedItem() instanceof MSVersionInfo) {
            return ((MSVersionInfo)this.hardwareSelector.getSelectedItem()).getName();
        }
        return "";
    }

    public void initCondaMap() {
        this.condaMap.clear();
        List condaList = ContainerUtil.filter((Object[])ProjectJdkTable.getInstance().getAllJdks(), PythonSdkUtil::isConda);
        condaList.forEach(conda -> this.condaMap.put(String.join((CharSequence)", ", conda.getName(), conda.getHomePath(), conda.getVersionString()), (Sdk)conda));
        this.existEnvSelector.removeAllItems();
        this.condaMap.keySet().forEach(this.existEnvSelector::addItem);
    }

    private void buttonListener() {
        this.condaEnvTextField.getButton().setEnabled(true);
        this.condaExecutableTextField.getButton().setEnabled(true);
        this.condaExecutableTextField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                WizardMsSettingProjectPeer.this.resetCondaEnvPath(WizardMsSettingProjectPeer.this.getCondaPath());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/mindspore/ide/toolkit/ui/wizard/WizardMsSettingProjectPeer$1", "textChanged"));
            }
        });
        if (this.condaEnvTextField.getButton().getActionListeners().length > 0 || this.condaExecutableTextField.getButton().getActionListeners().length > 0) {
            return;
        }
        FileChooserDescriptor condaEnvBrowserChooser = this.initFileChooser();
        this.condaEnvTextField.addBrowseFolderListener(new TextBrowseFolderListener(condaEnvBrowserChooser){

            @NotNull
            @NlsSafe
            protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    2.$$$reportNull$$$0(0);
                }
                String fileName = chosenFile.getPresentableUrl() + File.separator + "mindspore";
                String condaEnvPath = WizardMsSettingProjectPeer.this.autoIncrementFileName(fileName);
                log.info("Select the conda env location path : {}", (Object)condaEnvPath);
                String string = condaEnvPath;
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "chosenFile";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/mindspore/ide/toolkit/ui/wizard/WizardMsSettingProjectPeer$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/mindspore/ide/toolkit/ui/wizard/WizardMsSettingProjectPeer$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "chosenFileToResultingText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "chosenFileToResultingText";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.condaExecutableTextField.addBrowseFolderListener(new TextBrowseFolderListener(new FileChooserDescriptor(FileChooserDescriptorFactory.createSingleFileDescriptor())){

            @NotNull
            @NlsSafe
            protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    3.$$$reportNull$$$0(0);
                }
                log.info("Select the conda exe address path : {}", (Object)chosenFile.getPath());
                WizardMsSettingProjectPeer.this.initCondaEnvPath(chosenFile.getPath());
                String string = super.chosenFileToResultingText(chosenFile);
                if (string == null) {
                    3.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "chosenFile";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/mindspore/ide/toolkit/ui/wizard/WizardMsSettingProjectPeer$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/mindspore/ide/toolkit/ui/wizard/WizardMsSettingProjectPeer$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "chosenFileToResultingText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "chosenFileToResultingText";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.addDownloadButtonListener();
    }

    private FileChooserDescriptor initFileChooser() {
        FileChooserDescriptor condaEnvBrowserChooser;
        if (OSInfoUtils.INSTANCE.isLinux()) {
            condaEnvBrowserChooser = new FileChooserDescriptor(false, true, false, false, false, false){

                public boolean isFileVisible(VirtualFile file, boolean isShowHiddenFiles) {
                    if (PathUtils.judgeIsChildPath(MiniCondaService.getCondaEnvsPath(WizardMsSettingProjectPeer.this.getCondaPath()), file.getPath())) {
                        return false;
                    }
                    return super.isFileVisible(file, isShowHiddenFiles);
                }
            };
            condaEnvBrowserChooser.setRoots(new VirtualFile[]{VirtualFileManager.getInstance().findFileByNioPath(Path.of(MiniCondaService.getCondaEnvsPath(this.getCondaPath()), new String[0]))});
            condaEnvBrowserChooser.withTreeRootVisible(true);
            condaEnvBrowserChooser.setTitle("Select Path (Notice: on Linux, Only 'envs' Can Be Selected!)");
        } else {
            condaEnvBrowserChooser = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        }
        return condaEnvBrowserChooser;
    }

    private void addDownloadButtonListener() {
        this.downloadMiniCondaButton.addActionListener(actionEvent -> {
            CondaDownloadAndInstallDialog condaDownloadAndInstallDialog = new CondaDownloadAndInstallDialog();
            condaDownloadAndInstallDialog.setCondaDownloadAndInstallListener(path -> {
                if (path.isEmpty()) {
                    NotificationUtils.notify(NotificationUtils.NotifyGroup.NEW_PROJECT, NotificationType.INFORMATION, "Please select the conda download and installation path first.");
                } else {
                    condaDownloadAndInstallDialog.dispose();
                    this.downloadAction(path);
                }
            });
            condaDownloadAndInstallDialog.setVisible(true);
        });
    }

    private void downloadAction(String path) {
        if (MiniCondaService.downloadMiniCondaTask(path)) {
            if (VersionUtils.getIdeBaselineVersion() <= 203 && OSInfoUtils.INSTANCE.isMacOsX86()) {
                Messages.showMessageDialog((String)"Miniconda3 setup completed. Please restart PyCharm.", (String)"restart", (Icon)Messages.getInformationIcon());
                this.setCondExePath(path);
            } else {
                this.restartIde(path);
            }
        } else {
            Messages.showErrorDialog((String)"Miniconda download installation failed. Please check network.", (String)"Miniconda installation failed");
        }
    }

    private void restartIde(String path) {
        Application app;
        int result = Messages.showYesNoDialog((String)"Install MiniConda success\uff0cPlease restart Ide!", (String)"restart ide", (String)"Restart", (String)"Cancel", (Icon)Messages.getInformationIcon());
        this.setCondExePath(path);
        if (result == 0 && (app = ApplicationManager.getApplication()) instanceof ApplicationEx) {
            log.info("Restart IDE conda path : {}", (Object)path);
            ((ApplicationEx)app).restart(true);
        }
    }

    public void setCondExePath(String path) {
        this.initCondaEnvPath(MiniCondaService.setCondaExePathToIde(path));
    }

    public void initCondaEnvPath(String condaPath) {
        log.info("condaPath:{}", (Object)condaPath);
        boolean isFile = FileUtils.isFile(condaPath);
        if (!StringUtil.isEmptyOrSpaces((String)condaPath) && isFile) {
            this.downloadMiniCondaButton.setEnabled(false);
            this.downloadMiniCondaButton.setVisible(false);
            this.condaExecutableTextField.getTextField().setText(condaPath);
            this.setCondaEnvPath("mindspore");
        } else {
            this.downloadMiniCondaButton.setVisible(true);
            this.downloadMiniCondaButton.setEnabled(true);
        }
    }

    private void resetCondaEnvPath(String condaPath) {
        boolean isFile = FileUtils.isFile(condaPath);
        if (!StringUtil.isEmptyOrSpaces((String)condaPath) && isFile) {
            this.condaExecutableTextField.getTextField().setText(condaPath);
            this.setCondaEnvPath("mindspore");
        }
    }

    public void setCondaEnvPath(String projectName) {
        String name = projectName;
        if (projectName.contains(":")) {
            name = projectName.replace(":", "");
        }
        String envPath = MiniCondaService.getCondaEnvsPath(this.getCondaPath()) + name;
        this.condaEnvTextField.setText(this.autoIncrementFileName(envPath));
    }

    private String autoIncrementFileName(String fileName) {
        if (Files.exists(Path.of(fileName, new String[0]), new LinkOption[0])) {
            int suffix = 0;
            while (Files.exists(Path.of(fileName + ++suffix, new String[0]), new LinkOption[0])) {
            }
            return fileName + suffix;
        }
        return fileName;
    }

    public String getCondaEnvPath() {
        if (this.newEnvironmentUsingRadioButton.isSelected()) {
            return RegularUtils.normalizeFilePath(this.condaEnvTextField.getText());
        }
        return this.condaMap.get(this.existEnvSelector.getSelectedItem().toString()).getHomePath();
    }

    private void initTemplateSelector() {
        this.templateSelector.addItem("<empty>");
        MindSporeService.listTemplates().stream().forEach(this.templateSelector::addItem);
    }
}

