/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.common.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipCompressingUtils {
    private static final int CACHE_SIZE = 1024;
    private static final String TEMPORARY_FILE_NAME = "templateModel.zip";

    private ZipCompressingUtils() {
    }

    public static void unzipFile(String filePath, String targetDirPath) throws IOException {
        boolean mkDir;
        File pathFile = new File(targetDirPath);
        if (!pathFile.exists() && !(mkDir = pathFile.mkdirs())) {
            return;
        }
        Object tempTargetDirPath = targetDirPath;
        if (!((String)tempTargetDirPath).equals("")) {
            tempTargetDirPath = (String)tempTargetDirPath + File.separator;
        }
        File zipFile = new File(pathFile.getCanonicalPath() + File.separator + TEMPORARY_FILE_NAME);
        try (InputStream inputStream = ZipCompressingUtils.class.getResourceAsStream(filePath);
             FileOutputStream outputStream = new FileOutputStream(zipFile);){
            if (inputStream == null) {
                throw new FileNotFoundException("unable to find zip file");
            }
            byte[] bytes = new byte[1024];
            while (inputStream.read(bytes) != -1) {
                ((OutputStream)outputStream).write(bytes);
            }
            outputStream.flush();
        }
        try (ZipFile zip = new ZipFile(zipFile);){
            ZipCompressingUtils.traversalFiles(zip, (String)tempTargetDirPath, false);
        }
        boolean suc = zipFile.delete();
    }

    private static void readInputStreamAndWriteToTargetFile(ZipFile zip, ZipEntry entry, String outPath) throws IOException {
        try (InputStream inputStream = zip.getInputStream(entry);
             FileOutputStream outputStream = new FileOutputStream(outPath);){
            int length;
            byte[] buff = new byte[1024];
            while ((length = inputStream.read(buff)) > 0) {
                ((OutputStream)outputStream).write(buff, 0, length);
            }
        }
    }

    private static void traversalFiles(ZipFile zip, String targetPath, boolean isNeedRename) throws IOException {
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            String outPath;
            ZipEntry zipEntry = entries.nextElement();
            if (!(zipEntry instanceof ZipEntry)) continue;
            ZipEntry entry = zipEntry;
            String zipEntryName = entry.getName();
            String string = outPath = isNeedRename ? targetPath + File.separator + zipEntryName : (targetPath + zipEntryName).replace("\\*", File.pathSeparator);
            if (entry.isDirectory()) {
                boolean isMade = new File(outPath).mkdir();
                continue;
            }
            ZipCompressingUtils.readInputStreamAndWriteToTargetFile(zip, entry, outPath);
        }
    }
}

