/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.hdc.msjtable;

import com.mindspore.ide.toolkit.hdc.msjtable.GridBagModel;
import java.awt.Point;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class DefaultGridBagTableModel
implements GridBagModel,
TableModelListener {
    private AbstractTableModel model;
    private List<List<Point>> gridInfo = new Vector<List<Point>>();

    DefaultGridBagTableModel(AbstractTableModel model) {
        this.setTableModel(model);
    }

    public void setTableModel(AbstractTableModel model) {
        if (model != null && model != this.model) {
            if (this.model != null) {
                this.model.removeTableModelListener(this);
            }
            model.removeTableModelListener(this);
            model.addTableModelListener(this);
            this.model = model;
            this.clearMergence();
        }
    }

    @Override
    public void clearMergence() {
        if (this.gridInfo == null) {
            this.gridInfo = new Vector<List<Point>>();
        } else {
            this.gridInfo.clear();
        }
        if (this.model == null) {
            return;
        }
        int row = this.model.getRowCount();
        while (--row >= 0) {
            Vector<Point> infos = new Vector<Point>();
            this.gridInfo.add(infos);
            int col = this.model.getColumnCount();
            while (--col >= 0) {
                infos.add(this.getDefaultPoint());
            }
        }
    }

    public Point getDefaultPoint() {
        return new Point(1, 1);
    }

    @Override
    public boolean canMergeCells(int[] rows, int[] columns) {
        int index;
        if (rows == null || columns == null) {
            return false;
        }
        Arrays.sort(rows);
        for (index = 0; index < rows.length - 1; ++index) {
            if (rows[index + 1] - rows[index] <= 1) continue;
            return false;
        }
        Arrays.sort(columns);
        for (index = 0; index < columns.length - 1; ++index) {
            if (columns[index + 1] - columns[index] <= 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCellState(int row, int column) {
        Point grid = this.getGrid(row, column);
        if (grid == null) {
            return 0;
        }
        if (grid.x > 1 || grid.y > 1) {
            return 1;
        }
        if (grid.x <= 0 || grid.y <= 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public int getColumnGrid(int row, int column) {
        Point point;
        List<Point> gridRow;
        if (this.gridInfo != null && row >= 0 && row < this.gridInfo.size() && (gridRow = this.gridInfo.get(row)) != null && column >= 0 && column < gridRow.size() && (point = gridRow.get(column)) != null) {
            return point.x;
        }
        return 1;
    }

    @Override
    public Point getGrid(int row, int column) {
        List<Point> gridRow;
        if (this.gridInfo != null && row >= 0 && row < this.gridInfo.size() && (gridRow = this.gridInfo.get(row)) != null && column >= 0 && column < gridRow.size()) {
            return gridRow.get(column);
        }
        return this.getDefaultPoint();
    }

    @Override
    public int getRowGrid(int row, int column) {
        Point point;
        List<Point> gridRow;
        if (this.gridInfo != null && row >= 0 && row < this.gridInfo.size() && (gridRow = this.gridInfo.get(row)) != null && column >= 0 && column < gridRow.size() && (point = gridRow.get(column)) != null) {
            return point.y;
        }
        return 1;
    }

    private boolean setGrid(int row, int column, Point grid) {
        List<Point> gridRow;
        if (this.gridInfo != null && row >= 0 && row < this.gridInfo.size() && (gridRow = this.gridInfo.get(row)) != null && column >= 0 && column < gridRow.size()) {
            Point point = gridRow.get(column);
            if (point != null) {
                point.setLocation(grid);
            } else {
                gridRow.set(column, grid.getLocation());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean spliteCellAt(int row, int column) {
        List<Point> gridRow;
        if (this.gridInfo != null && row >= 0 && row < this.gridInfo.size() && (gridRow = this.gridInfo.get(row)) != null && column >= 0 && column < gridRow.size()) {
            Point point = gridRow.get(column);
            this.forData(point, row, column, gridRow);
            return true;
        }
        return false;
    }

    private void forData(Point inputPo, int row, int column, List<Point> gridRow) {
        Point inputPoNew = inputPo;
        if (inputPoNew != null) {
            inputPoNew = inputPo.getLocation();
            for (int a = 0; a < inputPoNew.y; ++a) {
                for (int b = 0; b < inputPoNew.x; ++b) {
                    this.setGrid(row + a, column + b, this.getDefaultPoint());
                }
            }
        } else {
            gridRow.set(column, this.getDefaultPoint());
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    @Override
    public boolean mergeCells(int[] rows, int[] columns) {
        if (!this.canMergeCells(rows, columns)) {
            return false;
        }
        Arrays.sort(rows);
        Arrays.sort(columns);
        return this.mergeCells(rows[0], rows[rows.length - 1], columns[0], columns[columns.length - 1]);
    }

    @Override
    public boolean mergeCells(int startRow, int endRow, int startColumn, int endColumn) {
        this.setGrid(startRow, startColumn, new Point(endColumn - startColumn + 1, endRow - startRow + 1));
        for (int row = startRow; row <= endRow; ++row) {
            for (int col = startColumn; col <= endColumn; ++col) {
                if (row == startRow && col == startColumn) continue;
                this.setGrid(row, col, new Point(-1, -1));
            }
        }
        return true;
    }

    public String toString() {
        if (this.gridInfo == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (List<Point> rowInfo : this.gridInfo) {
            for (Point grid : rowInfo) {
                sb.append("[" + grid.x + "," + grid.y + "], ");
            }
            sb.append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }
}

