/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.smartcomplete.grpc;

import com.mindspore.ide.toolkit.protomessage.CompleteReply;
import com.mindspore.ide.toolkit.protomessage.CompleteRequest;
import com.mindspore.ide.toolkit.protomessage.GreeterGrpc;
import io.grpc.Channel;
import io.grpc.StatusRuntimeException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartCompletionClient {
    private static final Logger log = LoggerFactory.getLogger(SmartCompletionClient.class);
    private final GreeterGrpc.GreeterBlockingStub blockingStub;

    public SmartCompletionClient(Channel channel) {
        this.blockingStub = GreeterGrpc.newBlockingStub(channel);
    }

    public Optional<CompleteReply> retrieveCompletions(String before, String prefix) {
        CompleteRequest request = CompleteRequest.newBuilder().setPrefix(prefix).setBefore(before).setAfter("").build();
        try {
            long startTime = System.currentTimeMillis();
            Optional<CompleteReply> response = Optional.of(((GreeterGrpc.GreeterBlockingStub)this.blockingStub.withDeadlineAfter(300L, TimeUnit.MILLISECONDS)).getRecommendation(request));
            long endTime = System.currentTimeMillis();
            log.info("retrieveCompletion cost: {}", (Object)(endTime - startTime));
            return response;
        }
        catch (StatusRuntimeException statusRuntimeException) {
            log.warn("SmartCompletionClient.retrieveCompletions failed.", (Throwable)statusRuntimeException);
            return Optional.empty();
        }
    }
}

