/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.wizard;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.sdk.flavors.PyCondaRunKt;
import com.mindspore.ide.toolkit.common.dialoginfo.DialogInfo;
import com.mindspore.ide.toolkit.common.dialoginfo.ExceptionDialogInfo;
import com.mindspore.ide.toolkit.common.enums.EnumError;
import com.mindspore.ide.toolkit.common.exceptions.MsToolKitException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CondaCmdProcessor {
    private static final Logger log = LoggerFactory.getLogger(CondaCmdProcessor.class);

    private CondaCmdProcessor() {
    }

    public static DialogInfo executeCondaCmd(Sdk sdk, String condaPath, List<String> cmdList) throws MsToolKitException {
        if (sdk == null && (condaPath == null || condaPath.equals(""))) {
            throw new MsToolKitException(EnumError.CONDA_EXECUTABLE_NOT_SPECIFIED);
        }
        try {
            ProcessOutput result;
            String command = String.join((CharSequence)" ", cmdList);
            if (sdk != null) {
                log.info("conda sdk:{}, exec:{}", (Object)sdk, (Object)PyCondaPackageService.getCondaExecutable((String)sdk.getHomePath()));
            }
            ProcessOutput processOutput = result = sdk == null ? PyCondaRunKt.runConda((String)condaPath, cmdList) : PyCondaRunKt.runConda((Sdk)sdk, cmdList);
            if (log.isInfoEnabled()) {
                log.info("execute conda command {}." + System.lineSeparator() + "------command: {}" + System.lineSeparator() + "------exitCode: {}" + System.lineSeparator() + "------stdout: {}" + System.lineSeparator() + "------stderr: {}", new Object[]{result.getExitCode() == 0 ? "succeed" : "failed", command, result.getExitCode(), result.getStdout(), result.getStderr()});
            }
            return new ExceptionDialogInfo.Builder().isSuccessful(result.getExitCode() == 0).command(command).output(result.getStdout()).build();
        }
        catch (ExecutionException executionException) {
            log.warn("execute conda cmd failed.", (Throwable)executionException);
            return ExceptionDialogInfo.parseException((Exception)((Object)executionException), sdk);
        }
    }
}

