# TensorFlow与MindSpore

<a href="https://gitee.com/mindspore/docs/blob/r1.7/docs/mindspore/source_zh_cn/note/api_mapping/tensorflow_api_mapping.md" target="_blank"><img src="https://mindspore-website.obs.cn-north-4.myhuaweicloud.com/website-images/r1.7/resource/_static/logo_source.png"></a>

由社区提供的TensorFlow APIs和MindSpore APIs之间的映射，可能在参数、输入、输出、逻辑功能和特定场景等方面存在差异，可详见各API描述或已提供的差异对比。

也欢迎更多的MindSpore开发者参与完善映射内容。

## tf

| TensorFlow  1.15 APIs                                                                          | MindSpore APIs                                                                                                                                  | 说明                                                                                                                  |
| ---------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------- |
| [tf.arg_max](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/arg_max)             | [mindspore.Tensor.argmax](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.argmax)        | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/TensorArgmax.html)  |
| [tf.arg_min](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/arg_min)             | [mindspore.Tensor.argmin](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.argmin)        | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/TensorArgmin.html)  |
| [tf.clip_by_value](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/clip_by_value) | [mindspore.Tensor.clip](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.clip)            | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/TensorClip.html)    |
| [tf.expand_dims](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/expand_dims)     | [mindspore.ops.ExpandDims](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.ExpandDims.html)                             |                                                                                                                       |
| [tf.eye](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/eye)                     | [mindspore.ops.Eye](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Eye.html)                                           |                                                                                                                       |
| [tf.fill](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/fill)                   | [mindspore.ops.Fill](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Fill.html)                                         |                                                                                                                       |
| [tf.gather](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/gather)               | [mindspore.ops.Gather](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Gather.html)                                     |                                                                                                                       |
| [tf.gradients](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/gradients)         | [mindspore.ops.GradOperation](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.GradOperation.html)                       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/GradOperation.html) |
| [tf.norm](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/norm)                   | [mindspore.nn.Norm](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Norm.html)                                            |                                                                                                                       |
| [tf.one_hot](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/one_hot)             | [mindspore.nn.OneHot](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.OneHot.html)                                        |                                                                                                                       |
| [tf.ones_like](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/ones_like)         | [mindspore.ops.OnesLike](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.OnesLike.html)                                 |                                                                                                                       |
| [tf.pad](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/pad)                     | [mindspore.nn.Pad](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Pad.html)                                              |                                                                                                                       |
| [tf.print](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/print)                 | [mindspore.ops.Print](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Print.html)                                       |                                                                                                                       |
| [tf.repeat](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/repeat)               | [mindspore.Tensor.repeat](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.repeat)        |                                                                                                                       |
| [tf.reshape](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/reshape)             | [mindspore.ops.Reshape](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Reshape.html)                                   |                                                                                                                       |
| [tf.reshape](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/reshape)             | [mindspore.Tensor.reshape](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.reshape)      |                                                                                                                       |
| [tf.shape](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/shape)                 | [mindspore.ops.Shape](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Shape.html)                                       |                                                                                                                       |
| [tf.size](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/size)                   | [mindspore.ops.Size](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Size.html)                                         |                                                                                                                       |
| [tf.slice](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/slice)                 | [mindspore.ops.Slice](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Slice.html)                                       |                                                                                                                       |
| [tf.squeeze](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/squeeze)             | [mindspore.Tensor.squeeze](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.squeeze)      |                                                                                                                       |
| [tf.stop_gradient](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/stop_gradient) | [mindspore.ops.stop_gradient](https://mindspore.cn/tutorials/zh-CN/r1.7/beginner/autograd.html#停止计算梯度) |                                                                                                                       |
| [tf.Tensor](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/Tensor)               | [mindspore.Tensor](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html)                                       |                                                                                                                       |
| [tf.tile](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/tile)                   | [mindspore.ops.Tile](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Tile.html)                                         |                                                                                                                       |
| [tf.transpose](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/transpose)         | [mindspore.ops.Transpose](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Transpose.html)                               |                                                                                                                       |
| [tf.zeros_like](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/zeros_like)       | [mindspore.ops.ZerosLike](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.ZerosLike.html)                               |                                                                                                                       |

## tf.data

MindSpore中的许多数据处理方法为各数据集类共有，下面以 `GeneratorDataset` 为例进行API差异对比，其他数据集类也是同理。

| TensorFlow  1.15 APIs                                                                                                                                      | MindSpore APIs                                                                                                                                                                                                               | 说明                                                                                                                              |
| ---------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------- |
| [tf.data.Dataset.apply](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/data/Dataset#apply)                                                   | [mindspore.dataset.GeneratorDataset.apply](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.GeneratorDataset.html#mindspore.dataset.GeneratorDataset.apply)                                   |                                                                                                                                   |
| [tf.data.Dataset.batch](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/data/Dataset#batch)                                                   | [mindspore.dataset.GeneratorDataset.batch](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.GeneratorDataset.html#mindspore.dataset.GeneratorDataset.batch)                                   |                                                                                                                                   |
| [tf.data.Dataset.concatenate](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/data/Dataset#concatenate)                                       | [mindspore.dataset.GeneratorDataset.concat](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.GeneratorDataset.html#mindspore.dataset.GeneratorDataset.concat)                                 |                                                                                                                                   |
| [tf.data.Dataset.filter](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/data/Dataset#filter)                                                 | [mindspore.dataset.GeneratorDataset.filter](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.GeneratorDataset.html#mindspore.dataset.GeneratorDataset.filter)                                 |                                                                                                                                   |
| [tf.data.Dataset.flat_map](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/data/Dataset#flat_map)                                             | [mindspore.dataset.GeneratorDataset.flat_map](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.GeneratorDataset.html#mindspore.dataset.GeneratorDataset.flat_map)                             |                                                                                                                                   |
| [tf.data.Dataset.from_generator](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/data/Dataset#from_generator)                                 | [mindspore.dataset.GeneratorDataset](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.GeneratorDataset.html#mindspore.dataset.GeneratorDataset)                                           | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/from_generator.html)            |
| [tf.data.Dataset.from_tensor_slices](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/data/Dataset#from_tensor_slices)                         | [mindspore.dataset.NumpySlicesDataset](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.NumpySlicesDataset.html#mindspore.dataset.NumpySlicesDataset)                                     | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/from_tensor_slices.html)        |
| [tf.data.Dataset.map](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/data/Dataset#map)                                                       | [mindspore.dataset.GeneratorDataset.map](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.GeneratorDataset.html#mindspore.dataset.GeneratorDataset.map)                                       |                                                                                                                                   |
| [tf.data.Dataset.prefetch](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/data/Dataset#prefetch)                                             | [mindspore.dataset.config.set_prefetch_size](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.dataset.config.html#mindspore.dataset.config.set_prefetch_size)                                                 | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/prefetch.html)                  |
| [tf.data.Dataset.repeat](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/data/Dataset#repeat)                                                 | [mindspore.dataset.GeneratorDataset.repeat](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.GeneratorDataset.html#mindspore.dataset.GeneratorDataset.repeat)                                 |                                                                                                                                   |
| [tf.data.Dataset.shuffle](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/data/Dataset#shuffle)                                               | [mindspore.dataset.GeneratorDataset.shuffle](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.GeneratorDataset.html#mindspore.dataset.GeneratorDataset.shuffle)                               | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/shuffle.html)                   |
| [tf.data.Dataset.skip](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/data/Dataset#skip)                                                     | [mindspore.dataset.GeneratorDataset.skip](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.GeneratorDataset.html#mindspore.dataset.GeneratorDataset.skip)                                     |                                                                                                                                   |
| [tf.data.Dataset.take](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/data/Dataset#take)                                                     | [mindspore.dataset.GeneratorDataset.take](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.GeneratorDataset.html#mindspore.dataset.GeneratorDataset.take)                                     |                                                                                                                                   |
| [tf.data.Dataset.zip](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/data/Dataset#zip)                                                       | [mindspore.dataset.GeneratorDataset.zip](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.GeneratorDataset.html#mindspore.dataset.GeneratorDataset.zip)                                       |                                                                                                                                   |
| [tf.data.TextLineDataset](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/data/TextLineDataset)                                               | [mindspore.dataset.TextFileDataset](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.TextFileDataset.html#mindspore.dataset.TextFileDataset)                                                  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/TextLineDataset.html)           |
| [tf.data.TFRecordDataset](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/data/TFRecordDataset)                                               | [mindspore.dataset.TFRecordDataset](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.TFRecordDataset.html#mindspore.dataset.TFRecordDataset)                                                  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/TFRecordDataset.html)           |
| [tf.data.experimental.bucket_by_sequence_length](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/data/experimental/bucket_by_sequence_length) | [mindspore.dataset.GeneratorDataset.bucket_batch_by_length](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.GeneratorDataset.html#mindspore.dataset.GeneratorDataset.bucket_batch_by_length) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/bucket_by_sequence_length.html) |
| [tf.data.experimental.CsvDataset](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/data/experimental/CsvDataset)                               | [mindspore.dataset.CSVDataset](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.CSVDataset.html#mindspore.dataset.CSVDataset)                                                             | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/CsvDataset.html)                |

## tf.distribute

| TensorFlow  1.15 APIs                                                                                      | MindSpore APIs                                                                                                                                                                                          | 说明                                                                                                                     |
| ---------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------ |
| [tf.distribute.Strategy](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/distribute/Strategy) | [context.set_auto_parallel_context(parallel_mode=ParallelMode.DATA_PARALLEL)](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.context.html#mindspore.context.set_auto_parallel_context) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/DistributedTrain.html) |

## tf.image

| TensorFlow  1.15 APIs                                                                                                              | MindSpore APIs                                                                                                                                                                                                                                                | 说明                                                                                                                              |
| ---------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------- |
| [tf.image.ssim](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/image/ssim)                                           | [mindspore.nn.SSIM](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.SSIM.html)                                                                                                                                                          |                                                                                                                                   |
| [tf.image.central_crop](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/image/central_crop)                           | [mindspore.dataset.vision.c_transforms.CenterCrop](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.CenterCrop.html#mindspore.dataset.vision.c_transforms.CenterCrop)                               | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/central_crop.html)              |
| [tf.image.convert_image_dtype](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/image/convert_image_dtype)             | [mindspore.dataset.vision.py_transforms.ToType](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.py_transforms.ToType.html#mindspore.dataset.vision.py_transforms.ToType)                                        | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/convert_image_dtype.html)       |
| [tf.image.crop_to_bounding_box](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/image/crop_to_bounding_box)           | [mindspore.dataset.vision.c_transforms.Crop](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.Crop.html#mindspore.dataset.vision.c_transforms.Crop)                                                 | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/crop_to_bounding_box.html)      |
| [tf.image.flip_left_right](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/image/flip_left_right)                     | [mindspore.dataset.vision.c_transforms.HorizontalFlip](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.HorizontalFlip.html#mindspore.dataset.vision.c_transforms.HorizontalFlip)                   |                                                                                                                                   |
| [tf.image.flip_up_down](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/image/flip_up_down)                           | [mindspore.dataset.vision.c_transforms.VerticalFlip](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.VerticalFlip.html#mindspore.dataset.vision.c_transforms.VerticalFlip)                         |                                                                                                                                   |
| [tf.image.grayscale_to_rgb](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/image/grayscale_to_rgb)                   | [mindspore.dataset.vision.c_transforms.ConvertColor](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.ConvertColor.html#mindspore.dataset.vision.c_transforms.ConvertColor)                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/grayscale_to_rgb.html)          |
| [tf.image.hsv_to_rgb](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/image/hsv_to_rgb)                               | [mindspore.dataset.vision.py_transforms.HsvToRgb](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.py_transforms.HsvToRgb.html#mindspore.dataset.vision.py_transforms.HsvToRgb)                                  |                                                                                                                                   |
| [tf.image.pad_to_bounding_box](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/image/pad_to_bounding_box)             | [mindspore.dataset.vision.c_transforms.Pad](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.Pad.html#mindspore.dataset.vision.c_transforms.Pad)                                                    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/pad_to_bounding_box.html)       |
| [tf.image.per_image_standardization](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/image/per_image_standardization) | [mindspore.dataset.vision.c_transforms.Normalize](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.Normalize.html#mindspore.dataset.vision.c_transforms.Normalize)                                  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/per_image_standardization.html) |
| [tf.image.random_crop](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/image/random_crop)                             | [mindspore.dataset.vision.c_transforms.RandomCrop](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.RandomCrop.html#mindspore.dataset.vision.c_transforms.RandomCrop)                               | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/random_crop.html)               |
| [tf.image.random_flip_left_right](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/image/random_flip_left_right)       | [mindspore.dataset.vision.c_transforms.RandomHorizontalFlip](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.RandomHorizontalFlip.html#mindspore.dataset.vision.c_transforms.RandomHorizontalFlip) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/random_flip_left_right.html)    |
| [tf.image.random_flip_up_down](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/image/random_flip_up_down)             | [mindspore.dataset.vision.c_transforms.RandomVerticalFlip](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.RandomVerticalFlip.html#mindspore.dataset.vision.c_transforms.RandomVerticalFlip)       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/random_flip_up_down.html)       |
| [tf.image.ResizeMethod](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/image/ResizeMethod)                           | [mindspore.dataset.vision.Inter](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.Inter.html#mindspore.dataset.vision.Inter)                                                                                     |                                                                                                                                   |
| [tf.image.resize_images](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/image/resize_images)                         | [mindspore.dataset.vision.c_transforms.Resize](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.Resize.html#mindspore.dataset.vision.c_transforms.Resize)                                           | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/resize_images.html)             |
| [tf.image.rgb_to_grayscale](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/image/rgb_to_grayscale)                   | [mindspore.dataset.vision.c_transforms.ConvertColor](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.ConvertColor.html#mindspore.dataset.vision.c_transforms.ConvertColor)                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/rgb_to_grayscale.html)          |
| [tf.image.rot90](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/image/rot90)                                         | [mindspore.dataset.vision.c_transforms.Rotate](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.Rotate.html#mindspore.dataset.vision.c_transforms.Rotate)                                           | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/rot90.html)                     |

## tf.io

| TensorFlow  1.15 APIs                                                                              | MindSpore APIs                                                                                                                                                                                                      | 说明                                                                                                                 |
| -------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------- |
| [tf.io.decode_image](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/io/decode_image) | [mindspore.dataset.vision.c_transforms.Decode](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.Decode.html#mindspore.dataset.vision.c_transforms.Decode) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/decode_image.html) |

## tf.keras

| TensorFlow  1.15 APIs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | MindSpore APIs                                                                                                                                                                                                                              | 说明                                                                                                                      |
| ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------- |
| [tf.keras.Model](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/Model)                                                                                                                                                                                                                                                                                                                                                                                                                                                              | [mindspore.Model](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Model.html#mindspore.Model)                                                                                                                     | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/Model.html)             |
| [tf.keras.Model.fit](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/Model#fit) <br> [tf.keras.Model.fit_generator]( https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/Model#fit_generator)                                                                                                                                                                                                                                                                                                                         | [mindspore.Model.train](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Model.html#mindspore.Model.train)                                                                                                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/ModelTrain.html)        |
| [tf.keras.Model.predict]( https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/Model#predict) <br> [tf.keras.Model.predict_generator]( https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/Model#predict_generator)                                                                                                                                                                                                                                                                                                        | [mindspore.Model.eval](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Model.html#mindspore.Model.eval)                                                                                                           | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/ModelEval.html)         |
| [tf.keras.backend.batch_dot](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/backend/batch_dot)                                                                                                                                                                                                                                                                                                                                                                                                                                      | [mindspore.ops.batch_dot](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.batch_dot.html)                                                                                                                           |                                                                                                                           |
| [tf.keras.backend.dot](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/backend/dot)                                                                                                                                                                                                                                                                                                                                                                                                                                                  | [mindspore.ops.dot](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.batch_dot.html)                                                                                                                                 |                                                                                                                           |
| [tf.keras.datasets.cifar10](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/datasets/cifar10)                                                                                                                                                                                                                                                                                                                                                                                                                                        | [mindspore.dataset.Cifar10Dataset](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.Cifar10Dataset.html#mindspore.dataset.Cifar10Dataset)                                                                    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/cifar10.html)           |
| [tf.keras.datasets.cifar100](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/datasets/cifar100)                                                                                                                                                                                                                                                                                                                                                                                                                                      | [mindspore.dataset.Cifar100Dataset](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.Cifar100Dataset.html#mindspore.dataset.Cifar100Dataset)                                                                 | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/cifar100.html)          |
| [tf.keras.datasets.fashion_mnist](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/datasets/fashion_mnist)                                                                                                                                                                                                                                                                                                                                                                                                                            | [mindspore.dataset.FashionMnistDataset](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.FashionMnistDataset.html#mindspore.dataset.FashionMnistDataset)                                                     | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/fashion_mnist.html)     |
| [tf.keras.datasets.imdb](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/datasets/imdb)                                                                                                                                                                                                                                                                                                                                                                                                                                              | [mindspore.dataset.IMDBDataset](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.IMDBDataset.html#mindspore.dataset.IMDBDataset)                                                                             | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/imdb.html)              |
| [tf.keras.datasets.mnist](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/datasets/mnist)                                                                                                                                                                                                                                                                                                                                                                                                                                            | [mindspore.dataset.MnistDataset](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.MnistDataset.html#mindspore.dataset.MnistDataset)                                                                          | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/mnist.html)             |
| [tf.keras.initializers.Constant](https://www.tensorflow.org/api_docs/python/tf/keras/initializers/Constant)                                                                                                                                                                                                                                                                                                                                                                                                                                             | [mindspore.common.initializer.Constant](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.common.initializer.html#mindspore.common.initializer.Constant)                                                                      | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/initConst.html)         |
| [tf.keras.initializers.Ones](https://www.tensorflow.org/api_docs/python/tf/keras/initializers/Ones)                                                                                                                                                                                                                                                                                                                                                                                                                                                     | [mindspore.common.initializer.One](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.common.initializer.html#mindspore.common.initializer.One)                                                                                |                                                                                                                           |
| [tf.keras.initializers.RandomNormal](https://www.tensorflow.org/api_docs/python/tf/keras/initializers/RandomNormal)                                                                                                                                                                                                                                                                                                                                                                                                                                     | [mindspore.common.initializer.Normal](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.common.initializer.html#mindspore.common.initializer.Normal)                                                                          | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/initNormal.html)        |
| [tf.keras.initializers.RandomUniform](https://www.tensorflow.org/api_docs/python/tf/keras/initializers/RandomUniform)                                                                                                                                                                                                                                                                                                                                                                                                                                   | [mindspore.common.initializer.Uniform](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.common.initializer.html#mindspore.common.initializer.Uniform)                                                                        | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/initUniform.html)       |
| [tf.keras.initializers.TruncatedNormal](https://www.tensorflow.org/api_docs/python/tf/keras/initializers/TruncatedNormal)                                                                                                                                                                                                                                                                                                                                                                                                                               | [mindspore.common.initializer.TruncatedNormal](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.common.initializer.html#mindspore.common.initializer.TruncatedNormal)                                                        | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/initTruncNormal.html)   |
| [tf.keras.initializers.VarianceScaling](https://www.tensorflow.org/api_docs/python/tf/keras/initializers/VarianceScaling)                                                                                                                                                                                                                                                                                                                                                                                                                               | [mindspore.common.initializer.XavierUniform](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.common.initializer.html#mindspore.common.initializer.XavierUniform)                                                            | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/initXavierUniform.html) |
| [tf.keras.initializers.Zeros](https://www.tensorflow.org/api_docs/python/tf/keras/initializers/Zeros)                                                                                                                                                                                                                                                                                                                                                                                                                                                   | [mindspore.common.initializer.Zero](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.common.initializer.html#mindspore.common.initializer.Zero)                                                                              |                                                                                                                           |
| [tf.keras.layers.Embedding](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/layers/Embedding)                                                                                                                                                                                                                                                                                                                                                                                                                                        | [mindspore.nn.Embedding](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Embedding.html)                                                                                                                              |                                                                                                                           |
| [tf.keras.layers.Flatten](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/layers/Flatten)                                                                                                                                                                                                                                                                                                                                                                                                                                            | [mindspore.nn.Flatten](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Flatten.html)                                                                                                                                  |                                                                                                                           |
| [tf.keras.layers.LayerNormalization](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/layers/LayerNormalization)                                                                                                                                                                                                                                                                                                                                                                                                                      | [mindspore.nn.LayerNorm](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.LayerNorm.html)                                                                                                                              |                                                                                                                           |
| [tf.keras.layers.LSTM](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/layers/LSTM)                                                                                                                                                                                                                                                                                                                                                                                                                                                  | [mindspore.nn.LSTM](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.LSTM.html)                                                                                                                                        |                                                                                                                           |
| [tf.keras.layers.PReLU](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/layers/PReLU)                                                                                                                                                                                                                                                                                                                                                                                                                                                | [mindspore.nn.PReLU](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.PReLU.html)                                                                                                                                      |                                                                                                                           |
| [tf.keras.layers.RNN](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/layers/RNN)                                                                                                                                                                                                                                                                                                                                                                                                                                                    | [mindspore.ops.DynamicRNN](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.DynamicRNN.html)                                                                                                                         |                                                                                                                           |
| [tf.keras.metrics.Accuracy](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/Accuracy)  <br> [tf.keras.metrics.BinaryAccuracy](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/BinaryAccuracy) <br> [tf.keras.metrics.CategoricalAccuracy](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/CategoricalAccuracy) <br> [tf.keras.metrics.SparseCategoricalAccuracy](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/SparseCategoricalAccuracy) | [mindspore.nn.Accuracy](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Accuracy.html#mindspore.nn.Accuracy)                                                                                                          | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/metricAcc.html)         |
| [tf.keras.metrics.AUC](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/AUC)                                                                                                                                                                                                                                                                                                                                                                                                                                                  | [mindspore.nn.auc](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.auc.html)                                                                                                                                      | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/metricAUC.html)         |
| [tf.keras.metrics.CosineSimilarity](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/CosineSimilarity)                                                                                                                                                                                                                                                                                                                                                                                                                        | [mindspore.nn.CosineSimilarity](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.CosineSimilarity.html#mindspore.nn.CosineSimilarity)                                                                                  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/metricCosineSim.html)   |
| [tf.keras.metrics.Mean](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/Mean)                                                                                                                                                                                                                                                                                                                                                                                                                                                | [mindspore.nn.Loss](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Loss.html#mindspore.nn.Loss)                                                                                                                      |                                                                                                                           |
| [tf.keras.metrics.MeanAbsoluteError](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/MeanAbsoluteError)                                                                                                                                                                                                                                                                                                                                                                                                                      | [mindspore.nn.MAE](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.MAE.html#mindspore.nn.MAE)                                                                                                                         |                                                                                                                           |
| [tf.keras.metrics.MeanSquaredError](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/MeanSquaredError)                                                                                                                                                                                                                                                                                                                                                                                                                        | [mindspore.nn.MSE](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.MSE.html#mindspore.nn.MSE)                                                                                                                         |                                                                                                                           |
| [tf.keras.metrics.Precision](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/Precision)                                                                                                                                                                                                                                                                                                                                                                                                                                      | [mindspore.nn.Precision](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Precision.html#mindspore.nn.Precision)                                                                                                       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/metricPrecision.html)   |
| [tf.keras.metrics.Recall](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/metrics/Recall)                                                                                                                                                                                                                                                                                                                                                                                                                                            | [mindspore.nn.Recall](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Recall.html#mindspore.nn.Recall)                                                                                                                | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/metricRecall.html)      |
| [tf.keras.optimizers.Adagrad](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/optimizers/Adagrad)                                                                                                                                                                                                                                                                                                                                                                                                                                    | [mindspore.nn.Adagrad](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Adagrad.html)                                                                                                                                  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/Adagrad.html)           |
| [tf.keras.optimizers.Adam](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/optimizers/Adam)                                                                                                                                                                                                                                                                                                                                                                                                                                          | [mindspore.nn.Adam](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Adam.html)                                                                                                                                        | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/Adam.html)              |
| [tf.keras.optimizers.Ftrl](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/optimizers/Ftrl)                                                                                                                                                                                                                                                                                                                                                                                                                                          | [mindspore.nn.FTRL](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.FTRL.html)                                                                                                                                        | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/Ftrl.html)              |
| [tf.keras.optimizers.RMSprop](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/optimizers/RMSprop)                                                                                                                                                                                                                                                                                                                                                                                                                                    | [mindspore.nn.RMSProp](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.RMSProp.html#mindspore.nn.RMSProp)                                                                                                             | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/RMSProp.html)           |
| [tf.keras.optimizers.SGD](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/optimizers/SGD)                                                                                                                                                                                                                                                                                                                                                                                                                                            | [mindspore.nn.SGD](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.SGD.html)                                                                                                                                          | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/SGD.html)               |
| [tf.keras.preprocessing.image.random_rotation](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/preprocessing/image/random_rotation)                                                                                                                                                                                                                                                                                                                                                                                                  | [mindspore.dataset.vision.c_transforms.RandomRotation](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.RandomRotation.html#mindspore.dataset.vision.c_transforms.RandomRotation) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/random_rotation.html)   |
| [tf.keras.preprocessing.image.random_shear](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/preprocessing/image/random_shear)                                                                                                                                                                                                                                                                                                                                                                                                        | [mindspore.dataset.vision.c_transforms.RandomAffine](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.RandomAffine.html#mindspore.dataset.vision.c_transforms.RandomAffine)       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/random_shear.html)      |
| [tf.keras.preprocessing.image.random_shift](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/keras/preprocessing/image/random_shift)                                                                                                                                                                                                                                                                                                                                                                                                        | [mindspore.dataset.vision.c_transforms.RandomAffine](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.RandomAffine.html#mindspore.dataset.vision.c_transforms.RandomAffine)       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/random_shift.html)      |

## tf.layers

| TensorFlow  1.15 APIs                                                                        | MindSpore APIs                                                                                         | 说明 |
| -------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------ | ---- |
| [tf.layers.Dense](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/layers/Dense) | [mindspore.nn.Dense](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Dense.html) |      |

## tf.linalg

| TensorFlow  1.15 APIs                                                                          | MindSpore APIs                                                                                           | 说明 |
| ---------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | ---- |
| [tf.linalg.inv](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/linalg/inv)       | [mindspore.ops.Inv](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Inv.html)    |      |
| [tf.linalg.matmul](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/linalg/matmul) | [mindspore.nn.MatMul](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.MatMul.html) |      |

## tf.math

| TensorFlow  1.15 APIs                                                                                        | MindSpore APIs                                                                                                                           | 说明                                                                                                                 |
| ------------------------------------------------------------------------------------------------------------ | ---------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------- |
| [tf.math.add](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/add)                         | [mindspore.ops.Add](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Add.html)                                    |                                                                                                                      |
| [tf.math.cumsum](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/cumsum)                   | [mindspore.Tensor.cumsum](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.cumsum) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/TensorCumsum.html) |
| [tf.math.divide](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/divide)                   | [mindspore.ops.Div](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Div.html)                                    |                                                                                                                      |
| [tf.math.erf](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/erf)                         | [mindspore.ops.Erf](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Erf.html)                                    |                                                                                                                      |
| [tf.math.greater](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/greater)                 | [mindspore.ops.Greater](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Greater.html)                            |                                                                                                                      |
| [tf.math.less_equal](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/less_equal)           | [mindspore.ops.LessEqual](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.LessEqual.html)                        |                                                                                                                      |
| [tf.math.log](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/log)                         | [mindspore.ops.Log](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Log.html)                                    |                                                                                                                      |
| [tf.math.multiply](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/multiply)               | [mindspore.ops.Mul](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Mul.html)                                    |                                                                                                                      |
| [tf.math.pow](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/pow)                         | [mindspore.ops.Pow](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Pow.html)                                    |                                                                                                                      |
| [tf.math.reduce_std](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/reduce_std)           | [mindspore.Tensor.std](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.std)       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/TensorStd.html)    |
| [tf.math.reduce_sum](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/reduce_sum)           | [mindspore.Tensor.sum](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.sum)       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/TensorSum.html)    |
| [tf.math.reduce_variance](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/reduce_variance) | [mindspore.Tensor.var](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.var)       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/TensorVar.html)    |
| [tf.math.sigmoid](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/sigmoid)                 | [mindspore.nn.Sigmoid](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Sigmoid.html)                               |                                                                                                                      |
| [tf.math.subtract](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/math/subtract)               | [mindspore.ops.Sub](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Sub.html)                                    |                                                                                                                      |

## tf.metrics

| TensorFlow  1.15 APIs                                                                                | MindSpore APIs                                                                                        | 说明 |
| ---------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------- | ---- |
| [tf.metrics.mean_iou](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/metrics/mean_iou) | [mindspore.ops.IOU](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.IOU.html) |      |

## tf.nn

| TensorFlow  1.15 APIs                                                                                                                        | MindSpore APIs                                                                                                                                            | 说明                                                                                                                                  |
| -------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------- |
| [tf.nn.avg_pool2d](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/avg_pool2d)                                               | [mindspore.nn.AvgPool2d](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.AvgPool2d.html)                                            |                                                                                                                                       |
| [tf.nn.batch_normalization](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/batch_normalization)                             | [mindspore.ops.BatchNorm](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.BatchNorm.html)                                         |                                                                                                                                       |
| [tf.nn.bias_add](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/bias_add)                                                   | [mindspore.ops.BiasAdd](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.BiasAdd.html)                                             |                                                                                                                                       |
| [tf.nn.conv2d](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/conv2d)                                                       | [mindspore.nn.Conv2d](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Conv2d.html)                                                  |                                                                                                                                       |
| [tf.nn.conv2d_transpose](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/conv2d_transpose)                                   | [mindspore.nn.Conv2dTranspose](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Conv2dTranspose.html)                                |                                                                                                                                       |
| [tf.nn.ctc_loss](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/ctc_loss)                                                   | [mindspore.ops.CTCLoss](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.CTCLoss.html)                                             |                                                                                                                                       |
| [tf.nn.dropout](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/dropout)                                                     | [mindspore.nn.Dropout](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Dropout.html)                                                |                                                                                                                                       |
| [tf.nn.elu](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/elu)                                                             | [mindspore.nn.ELU](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.ELU.html)                                                        |                                                                                                                                       |
| [tf.nn.l2_loss](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/l2_loss)                                                     | [mindspore.ops.L2Loss](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.L2Loss.html)                                               |                                                                                                                                       |
| [tf.nn.l2_normalize](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/l2_normalize)                                           | [mindspore.ops.L2Normalize](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.L2Normalize.html)                                     |                                                                                                                                       |
| [tf.nn.leaky_relu](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/leaky_relu)                                               | [mindspore.nn.LeakyReLU](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.LeakyReLU.html)                                            |                                                                                                                                       |
| [tf.nn.max_pool_with_argmax](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/max_pool_with_argmax)                           | [mindspore.ops.MaxPoolWithArgmax](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.MaxPoolWithArgmax.html)                         |                                                                                                                                       |
| [tf.nn.max_pool2d](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/max_pool2d)                                               | [mindspore.nn.MaxPool2d](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.MaxPool2d.html)                                            |                                                                                                                                       |
| [tf.nn.moments](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/moments)                                                     | [mindspore.nn.Moments](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Moments.html)                                                |                                                                                                                                       |
| [tf.nn.relu](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/relu)                                                           | [mindspore.nn.ReLU](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.ReLU.html)                                                      |                                                                                                                                       |
| [tf.nn.selu](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/selu)                                                           | [mindspore.ops.SeLU](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.SeLU.html)                                                   |                                                                                                                                       |
| [tf.nn.sigmoid_cross_entropy_with_logits](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/sigmoid_cross_entropy_with_logits) | [mindspore.ops.SigmoidCrossEntropyWithLogits](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.SigmoidCrossEntropyWithLogits.html) |                                                                                                                                       |
| [tf.nn.softmax](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/softmax)                                                     | [mindspore.nn.Softmax](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Softmax.html)                                                |                                                                                                                                       |
| [tf.nn.softmax_cross_entropy_with_logits](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn/softmax_cross_entropy_with_logits) | [mindspore.nn.SoftmaxCrossEntropyWithLogits](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.SoftmaxCrossEntropyWithLogits.html)    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/SoftmaxCrossEntropyWithLogits.html) |

## tf.random

| TensorFlow  1.15 APIs                                                                            | MindSpore APIs                                                                                                | 说明 |
| ------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------- | ---- |
| [tf.random.gamma](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/random/gamma)     | [mindspore.ops.Gamma](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Gamma.html)     |      |
| [tf.random.uniform](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/random/uniform) | [mindspore.ops.uniform](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.uniform.html) |      |

## tf.sparse

| TensorFlow  1.15 APIs                                                                                      | MindSpore APIs                                                                                                        | 说明 |
| ---------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------- | ---- |
| [tf.sparse.SparseTensor](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/sparse/SparseTensor) | [mindspore.SparseTensor](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.SparseTensor.html) |      |

## tf.train

| TensorFlow  1.15 APIs                                                                                                            | MindSpore APIs                                                                                                                                          | 说明                                                                                                                    |
| -------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------- |
| [tf.train.ProximalAdagradOptimizer](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/train/ProximalAdagradOptimizer) | [mindspore.nn.ProximalAdagrad](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.ProximalAdagrad.html#mindspore.nn.ProximalAdagrad) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/ProximalAdagrad.html) |
| [tf.train.exponential_decay](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/train/exponential_decay)               | [mindspore.nn.ExponentialDecayLR](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.ExponentialDecayLR.html)                        |                                                                                                                         |
| [tf.train.linear_cosine_decay](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/train/linear_cosine_decay)           | [mindspore.nn.CosineDecayLR](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.CosineDecayLR.html)                                  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/CosineDecayLR.html)   |
| [tf.train.MomentumOptimizer](https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/train/MomentumOptimizer)               | [mindspore.nn.Momentum](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Momentum.html)                                            | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_diff/Momentum.html)        |

## tfp

| TensorFlow Probability 0.14.1 APIs                                                                      | MindSpore APIs                                                                                                                                                         | 说明                                                                                                                                 |
| ------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------ |
| [tfp.bijectors.Softplus](https://www.tensorflow.org/probability/api_docs/python/tfp/bijectors/Softplus) | [mindspore.nn.probability.bijector.Softplus](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/nn_probability/mindspore.nn.probability.bijector.Softplus.html) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/tensorflow_probability_diff/BijectorSoftplus.html) |
