/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.common.utils;

import com.intellij.openapi.application.PathManager;
import com.mindspore.ide.toolkit.common.config.GlobalConfig;
import com.mindspore.ide.toolkit.common.utils.FileUtils;
import com.mindspore.ide.toolkit.common.utils.RegularUtils;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public class PathUtils {
    private static final String MINDSPORE_PATH = "mindspore";
    private static final int FREE_SPACE = 0x40000000;

    public static String getInstallRootPath() {
        File[] allRoots;
        String installPath = System.getProperty("user.home");
        String rootPath = System.getenv("SystemDrive");
        if (RegularUtils.isEmpty(rootPath)) {
            return installPath;
        }
        for (File file : allRoots = File.listRoots()) {
            if (file.getPath().startsWith(rootPath) || file.getUsableSpace() <= 0x40000000L) continue;
            installPath = file.getPath();
            break;
        }
        return installPath;
    }

    public static String getDefaultResourcePath() {
        return PathUtils.getInstallRootPath() + File.separator + GlobalConfig.get().getResourceFolder();
    }

    public static void initResourceFolder() {
        File file = FileUtils.getFile(PathUtils.getDefaultResourcePath());
        if (!file.exists() && file.mkdir()) {
            FileUtils.hideFile(file);
        }
    }

    public static Path getUserCommonDataPath() {
        return PathManager.getCommonDataPath();
    }

    public static Path getIdeHomePath() {
        return Paths.get(PathManager.getHomePath(), new String[0]);
    }

    public static Path getIdePluginsPath() {
        return Paths.get(PathManager.getPluginsPath(), new String[0]);
    }

    public static Path getMindSporePath() {
        return Paths.get(PathUtils.getIdePluginsPath().toString(), MINDSPORE_PATH);
    }

    public static boolean judgeIsChildPath(String parentPath, String childPath) {
        return Objects.equals(Path.of(childPath, new String[0]).getParent(), Path.of(parentPath, new String[0]));
    }
}

