/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.format;

import com.vladsch.flexmark.util.format.NodeContext;
import com.vladsch.flexmark.util.misc.BitFieldSet;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.LineAppendable;
import com.vladsch.flexmark.util.sequence.LineAppendableImpl;
import com.vladsch.flexmark.util.sequence.LineInfo;
import com.vladsch.flexmark.util.sequence.builder.ISequenceBuilder;
import java.io.IOException;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MarkdownWriterBase<T extends MarkdownWriterBase<T, N, C>, N, C extends NodeContext<N, C>>
implements LineAppendable {
    protected final LineAppendableImpl appendable;
    protected C context;

    public MarkdownWriterBase() {
        this(0);
    }

    public String toString() {
        return this.appendable.toString();
    }

    public MarkdownWriterBase(int formatOptions) {
        this(null, formatOptions);
    }

    public MarkdownWriterBase(@Nullable Appendable builder, int formatOptions) {
        this.appendable = new LineAppendableImpl(builder, formatOptions);
        this.appendable.setOptions(this.appendable.getOptions() | LineAppendable.F_PREFIX_PRE_FORMATTED);
    }

    public void setContext(C context) {
        this.context = context;
    }

    public C getContext() {
        return this.context;
    }

    @NotNull
    public T tailBlankLine() {
        return this.tailBlankLine(1);
    }

    @NotNull
    public abstract BasedSequence lastBlockQuoteChildPrefix(BasedSequence var1);

    @NotNull
    public T tailBlankLine(int count) {
        BasedSequence prefix = this.appendable.getPrefix();
        BasedSequence replacedPrefix = this.lastBlockQuoteChildPrefix(prefix);
        if (!replacedPrefix.equals(prefix)) {
            this.appendable.setPrefix((CharSequence)replacedPrefix, false);
            this.appendable.blankLine(count);
            this.appendable.setPrefix((CharSequence)prefix, false);
        } else {
            this.appendable.blankLine(count);
        }
        return (T)this;
    }

    @NotNull
    public Iterator<LineInfo> iterator() {
        return this.appendable.iterator();
    }

    @NotNull
    public Iterable<BasedSequence> getLines(int maxTrailingBlankLines, int startLine, int endLine, boolean withPrefixes) {
        return this.appendable.getLines(maxTrailingBlankLines, startLine, endLine, true);
    }

    @NotNull
    public Iterable<LineInfo> getLinesInfo(int maxTrailingBlankLines, int startLine, int endLine) {
        return this.appendable.getLinesInfo(maxTrailingBlankLines, startLine, endLine);
    }

    public void setPrefixLength(int lineIndex, int prefixEndIndex) {
        this.appendable.setPrefixLength(lineIndex, prefixEndIndex);
    }

    public void insertLine(int lineIndex, @NotNull CharSequence prefix, @NotNull CharSequence text) {
        this.appendable.insertLine(lineIndex, prefix, text);
    }

    public void setLine(int lineIndex, @NotNull CharSequence prefix, @NotNull CharSequence text) {
        this.appendable.setLine(lineIndex, prefix, text);
    }

    public <T extends Appendable> T appendTo(@NotNull T out, boolean withPrefixes, int maxBlankLines, int maxTrailingBlankLines, int startLine, int endLine) throws IOException {
        return (T)this.appendable.appendTo(out, withPrefixes, maxBlankLines, maxTrailingBlankLines, startLine, endLine);
    }

    public boolean endsWithEOL() {
        return this.appendable.endsWithEOL();
    }

    public boolean isPendingSpace() {
        return this.appendable.isPendingSpace();
    }

    public boolean isPreFormatted() {
        return this.appendable.isPreFormatted();
    }

    public int getTrailingBlankLines(int endLine) {
        return this.appendable.getTrailingBlankLines(endLine);
    }

    public int column() {
        return this.appendable.column();
    }

    public int getLineCount() {
        return this.appendable.getLineCount();
    }

    public int getLineCountWithPending() {
        return this.appendable.getLineCountWithPending();
    }

    public int getOptions() {
        return this.appendable.getOptions();
    }

    public int getPendingSpace() {
        return this.appendable.getPendingSpace();
    }

    public int getPendingEOL() {
        return this.appendable.getPendingEOL();
    }

    public int offset() {
        return this.appendable.offset();
    }

    public int offsetWithPending() {
        return this.appendable.offsetWithPending();
    }

    public int getAfterEolPrefixDelta() {
        return this.appendable.getAfterEolPrefixDelta();
    }

    @NotNull
    public ISequenceBuilder<?, ?> getBuilder() {
        return this.appendable.getBuilder();
    }

    @NotNull
    public BasedSequence getPrefix() {
        return this.appendable.getPrefix();
    }

    @NotNull
    public BasedSequence getBeforeEolPrefix() {
        return this.appendable.getBeforeEolPrefix();
    }

    @NotNull
    public LineInfo getLineInfo(int lineIndex) {
        return this.appendable.getLineInfo(lineIndex);
    }

    @NotNull
    public BasedSequence getLine(int lineIndex) {
        return this.appendable.getLine(lineIndex);
    }

    @NotNull
    public BasedSequence getIndentPrefix() {
        return this.appendable.getIndentPrefix();
    }

    @NotNull
    public CharSequence toSequence(int maxBlankLines, int maxTrailingBlankLines, boolean withPrefixes) {
        return this.appendable.toSequence(maxBlankLines, maxTrailingBlankLines, withPrefixes);
    }

    @NotNull
    public String toString(int maxBlankLines, int maxTrailingBlankLines, boolean withPrefixes) {
        return this.appendable.toString(maxBlankLines, maxTrailingBlankLines, withPrefixes);
    }

    @NotNull
    public BitFieldSet<LineAppendable.Options> getOptionSet() {
        return this.appendable.getOptionSet();
    }

    @NotNull
    public T removeExtraBlankLines(int maxBlankLines, int maxTrailingBlankLines, int startLine, int endLine) {
        this.appendable.removeExtraBlankLines(maxBlankLines, maxTrailingBlankLines, startLine, endLine);
        return (T)this;
    }

    @NotNull
    public T removeLines(int startLine, int endLine) {
        this.appendable.removeLines(startLine, endLine);
        return (T)this;
    }

    @NotNull
    public T pushOptions() {
        this.appendable.pushOptions();
        return (T)this;
    }

    @NotNull
    public T popOptions() {
        this.appendable.popOptions();
        return (T)this;
    }

    @NotNull
    public T changeOptions(int addFlags, int removeFlags) {
        this.appendable.changeOptions(addFlags, removeFlags);
        return (T)this;
    }

    @NotNull
    public T addIndentOnFirstEOL(@NotNull Runnable listener) {
        this.appendable.addIndentOnFirstEOL(listener);
        return (T)this;
    }

    @NotNull
    public T addPrefix(@NotNull CharSequence prefix) {
        this.appendable.addPrefix(prefix);
        return (T)this;
    }

    @NotNull
    public T addPrefix(@NotNull CharSequence prefix, boolean afterEol) {
        this.appendable.addPrefix(prefix, afterEol);
        return (T)this;
    }

    @NotNull
    public T append(char c) {
        this.appendable.append(c);
        return (T)this;
    }

    @NotNull
    public T append(@NotNull CharSequence csq) {
        this.appendable.append(csq);
        return (T)this;
    }

    @NotNull
    public T append(@NotNull CharSequence csq, int start, int end) {
        this.appendable.append(csq, start, end);
        return (T)this;
    }

    @NotNull
    public T append(@NotNull LineAppendable lines, int startLine, int endLine, boolean withPrefixes) {
        this.appendable.append(lines, startLine, endLine, withPrefixes);
        return (T)this;
    }

    @NotNull
    public T blankLine() {
        this.appendable.blankLine();
        return (T)this;
    }

    @NotNull
    public T blankLine(int count) {
        this.appendable.blankLine(count);
        return (T)this;
    }

    @NotNull
    public T blankLineIf(boolean predicate) {
        this.appendable.blankLineIf(predicate);
        return (T)this;
    }

    @NotNull
    public T closePreFormatted() {
        this.appendable.closePreFormatted();
        return (T)this;
    }

    @NotNull
    public T indent() {
        this.appendable.indent();
        return (T)this;
    }

    @NotNull
    public T line() {
        this.appendable.line();
        return (T)this;
    }

    @NotNull
    public T lineIf(boolean predicate) {
        this.appendable.lineIf(predicate);
        return (T)this;
    }

    @NotNull
    public T lineOnFirstText(boolean value) {
        this.appendable.lineOnFirstText(value);
        return (T)this;
    }

    @NotNull
    public T lineWithTrailingSpaces(int count) {
        this.appendable.lineWithTrailingSpaces(count);
        return (T)this;
    }

    @NotNull
    public T openPreFormatted(boolean keepIndent) {
        this.appendable.openPreFormatted(keepIndent);
        return (T)this;
    }

    @NotNull
    public T popPrefix() {
        this.appendable.popPrefix();
        return (T)this;
    }

    @NotNull
    public T popPrefix(boolean afterEol) {
        this.appendable.popPrefix(afterEol);
        return (T)this;
    }

    @NotNull
    public T pushPrefix() {
        this.appendable.pushPrefix();
        return (T)this;
    }

    @NotNull
    public T removeIndentOnFirstEOL(@NotNull Runnable listener) {
        this.appendable.removeIndentOnFirstEOL(listener);
        return (T)this;
    }

    @NotNull
    public T append(char c, int count) {
        this.appendable.append(c, count);
        return (T)this;
    }

    @NotNull
    public T setIndentPrefix(@Nullable CharSequence prefix) {
        this.appendable.setIndentPrefix(prefix);
        return (T)this;
    }

    @NotNull
    public T setOptions(int flags) {
        this.appendable.setOptions(flags);
        return (T)this;
    }

    @NotNull
    public T setPrefix(@NotNull CharSequence prefix) {
        this.appendable.setPrefix(prefix);
        return (T)this;
    }

    @NotNull
    public T setPrefix(@Nullable CharSequence prefix, boolean afterEol) {
        this.appendable.setPrefix(prefix, afterEol);
        return (T)this;
    }

    @NotNull
    public T unIndent() {
        this.appendable.unIndent();
        return (T)this;
    }

    @NotNull
    public T unIndentNoEol() {
        this.appendable.unIndentNoEol();
        return (T)this;
    }
}

