/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.common.utils;

import com.intellij.util.net.HttpConfigurable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;

public class HttpUtils {
    private static final int CONNECT_TIMEOUT_TIME = 15000;
    private static final String CHARSET_UTF_8 = "UTF-8";

    public static CloseableHttpResponse doGet(String url, Map<String, String> headerMap) throws IOException {
        return HttpClients.createDefault().execute((HttpUriRequest)HttpUtils.initHttpGet(url, headerMap, -1));
    }

    public static CloseableHttpResponse doGet(String url, Map<String, String> headerMap, int timeout) throws IOException {
        return HttpClients.createDefault().execute((HttpUriRequest)HttpUtils.initHttpGet(url, headerMap, timeout));
    }

    public static HttpResponse doPost(String url, Map<String, String> headerMap, Map<String, String> bodymap) throws IOException {
        HttpPost request = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(15000).setConnectionRequestTimeout(15000).build();
        request.setConfig(requestConfig);
        if (headerMap != null && !headerMap.isEmpty()) {
            headerMap.forEach((arg_0, arg_1) -> ((HttpPost)request).setHeader(arg_0, arg_1));
        }
        ArrayList<BasicNameValuePair> content = new ArrayList<BasicNameValuePair>();
        if (headerMap != null && !bodymap.isEmpty()) {
            for (Map.Entry<String, String> elem : bodymap.entrySet()) {
                content.add(new BasicNameValuePair(elem.getKey(), elem.getValue()));
            }
        }
        request.setEntity((HttpEntity)new UrlEncodedFormEntity(content, CHARSET_UTF_8));
        return HttpClients.createDefault().execute((HttpUriRequest)request);
    }

    public static void download(String url, String filePath) throws IOException {
        HttpUtils.download(url, filePath, 600000);
    }

    public static void download(String url, String filePath, int timeOut) throws IOException {
        boolean mkDirs;
        File file = new File(filePath);
        if (!file.getParentFile().exists() && !(mkDirs = file.getParentFile().mkdirs())) {
            return;
        }
        HttpURLConnection httpUrlConnect = HttpConfigurable.getInstance().openHttpConnection(url);
        httpUrlConnect.setReadTimeout(timeOut);
        httpUrlConnect.connect();
        try (ReadableByteChannel readableByteChannel = Channels.newChannel(httpUrlConnect.getInputStream());
             FileOutputStream fileOutputStream = new FileOutputStream(filePath);
             FileChannel fileChannel = fileOutputStream.getChannel();){
            long index = 0L;
            long memory = 0x1400000L;
            while (fileChannel.size() < (long)httpUrlConnect.getContentLength()) {
                fileChannel.transferFrom(readableByteChannel, index, memory);
                index = fileChannel.size();
            }
        }
    }

    private static HttpGet initHttpGet(String url, Map<String, String> headerMap, int timeout) {
        HttpGet httpGet = new HttpGet();
        httpGet.setURI(URI.create(url));
        if (!headerMap.isEmpty()) {
            headerMap.forEach((arg_0, arg_1) -> ((HttpGet)httpGet).setHeader(arg_0, arg_1));
        }
        if (timeout != -1) {
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(timeout).setConnectTimeout(timeout).setSocketTimeout(timeout).build();
            httpGet.setConfig(requestConfig);
        }
        return httpGet;
    }
}

