/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.hdc.msjtable;

import com.mindspore.ide.toolkit.hdc.msjtable.GridBagTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class GridBagTableUI
extends BasicTableUI {
    private Color dropLineColor = UIManager.getColor("Table.dropLineColor");
    private Color dropLineShortColor = UIManager.getColor("Table.dropLineShortColor");
    private int columnMarginPaintCells;
    private Rectangle cellRectPaintCells;
    private TableColumn aColumnPaintCells;
    private int oldHeightPaintCells;
    private JTableHeader headerPaintCells;
    private TableColumn draggedColumnPaintCells;
    private TableColumnModel cmPaintCells;
    private int columnWidthPaintCells;

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        int columnPointMax;
        int columnPointMin;
        int rowPointMax;
        Rectangle clipRectangle = graphics.getClipBounds();
        Rectangle boundsRectangle = this.table.getBounds();
        boundsRectangle.x = 0;
        boundsRectangle.y = 0;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0 || !boundsRectangle.intersects(clipRectangle)) {
            this.paintDropLines(graphics);
            return;
        }
        boolean isLtr = this.table.getComponentOrientation().isLeftToRight();
        Point locationLeft = clipRectangle.getLocation();
        if (!isLtr) {
            ++locationLeft.x;
        }
        Point locationRight = new Point(clipRectangle.x + clipRectangle.width - (isLtr ? 1 : 0), clipRectangle.y + clipRectangle.height);
        int rowPointMin = this.table.rowAtPoint(locationLeft);
        if (rowPointMin == -1) {
            rowPointMin = 0;
        }
        if ((rowPointMax = this.table.rowAtPoint(locationRight)) == -1) {
            rowPointMax = this.table.getRowCount() - 1;
        }
        if (isLtr) {
            columnPointMin = this.table.columnAtPoint(locationLeft);
            columnPointMax = this.table.columnAtPoint(locationRight);
        } else {
            columnPointMin = this.table.columnAtPoint(locationRight);
            columnPointMax = this.table.columnAtPoint(locationLeft);
        }
        if (columnPointMin == -1) {
            columnPointMin = 0;
        }
        if (columnPointMax == -1) {
            columnPointMax = this.table.getColumnCount() - 1;
        }
        this.paintCells(graphics, rowPointMin, rowPointMax, columnPointMin, columnPointMax);
        this.paintDropLines(graphics);
    }

    private void paintCell(Graphics gr, Rectangle cellRect, int row, int column) {
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            this.paintCellOne(cellRect);
        } else {
            this.paintCellTwo(gr, cellRect, row, column);
        }
    }

    private void paintCellOne(Rectangle cellRect) {
        Component component = this.table.getEditorComponent();
        component.setBounds(cellRect);
        component.validate();
    }

    private void paintCellTwo(Graphics gr, Rectangle cellRect, int row, int column) {
        TableCellRenderer renderer = this.table.getCellRenderer(row, column);
        Component component = this.table.prepareRenderer(renderer, row, column);
        if (component instanceof JComponent) {
            ((JComponent)component).setBorder(BorderFactory.createLineBorder(Color.gray));
        }
        this.rendererPane.paintComponent(gr, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    private void paintCells(Graphics gr, int rMin, int rMax, int cMin, int cMax) {
        this.headerPaintCells = this.table.getTableHeader();
        this.draggedColumnPaintCells = this.headerPaintCells == null ? null : this.headerPaintCells.getDraggedColumn();
        this.cmPaintCells = this.table.getColumnModel();
        this.columnMarginPaintCells = this.cmPaintCells.getColumnMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            this.ifPaintCells(gr, rMin, rMax, cMin, cMax);
        } else {
            this.elsePaintCells(gr, rMin, rMax, cMin, cMax);
        }
        if (this.draggedColumnPaintCells != null) {
            this.paintDraggedArea(gr, rMin, rMax, this.draggedColumnPaintCells, this.headerPaintCells.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void ifPaintCells(Graphics gr, int rMin, int rMax, int cMin, int cMax) {
        for (int row = rMin; row <= rMax; ++row) {
            this.cellRectPaintCells = this.table instanceof GridBagTable ? ((GridBagTable)this.table).getGridCellRect(row, cMin, false) : this.table.getCellRect(row, cMin, false);
            for (int column = cMin; column <= cMax; ++column) {
                this.aColumnPaintCells = this.cmPaintCells.getColumn(column);
                this.columnWidthPaintCells = this.aColumnPaintCells.getWidth();
                this.cellRectPaintCells.width = this.columnWidthPaintCells - this.columnMarginPaintCells;
                this.oldHeightPaintCells = this.cellRectPaintCells.height;
                this.ifPaintCellsTwo(row, column);
                if (this.aColumnPaintCells != this.draggedColumnPaintCells) {
                    this.paintCell(gr, this.cellRectPaintCells, row, column);
                }
                this.cellRectPaintCells.height = this.oldHeightPaintCells;
                this.cellRectPaintCells.x += this.columnWidthPaintCells;
            }
        }
    }

    private void ifPaintCellsTwo(int row, int column) {
        if (this.table instanceof GridBagTable) {
            GridBagTable gridBagTable = (GridBagTable)this.table;
            if (gridBagTable.getGridBagModel().getCellState(row, column) == -1) {
                this.cellRectPaintCells.width = 0;
                this.cellRectPaintCells.height = 0;
            } else {
                this.ifPaintCellsThree(row, column, gridBagTable);
            }
        }
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.table.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    private void ifPaintCellsThree(int row, int column, GridBagTable gridBagTable) {
        int vr;
        int th = gridBagTable.getGridBagModel().getColumnGrid(row, column);
        if (th > 1) {
            for (int n = 1; n < th; ++n) {
                this.cellRectPaintCells.width += this.cmPaintCells.getColumn(column + n).getWidth();
            }
        }
        if ((vr = gridBagTable.getGridBagModel().getRowGrid(row, column)) > 1) {
            for (int n = 1; n < vr; ++n) {
                this.cellRectPaintCells.height += this.table.getRowHeight(row + n);
            }
        }
    }

    private void elsePaintCells(Graphics gr, int rMin, int rMax, int cMin, int cMax) {
        for (int row = rMin; row <= rMax; ++row) {
            this.cellRectPaintCells = this.table.getCellRect(row, cMin, false);
            this.aColumnPaintCells = this.cmPaintCells.getColumn(cMin);
            if (this.aColumnPaintCells != this.draggedColumnPaintCells) {
                this.columnWidthPaintCells = this.aColumnPaintCells.getWidth();
                this.cellRectPaintCells.width = this.columnWidthPaintCells - this.columnMarginPaintCells;
                this.paintCell(gr, this.cellRectPaintCells, row, cMin);
            }
            for (int column = cMin + 1; column <= cMax; ++column) {
                this.aColumnPaintCells = this.cmPaintCells.getColumn(column);
                this.columnWidthPaintCells = this.aColumnPaintCells.getWidth();
                this.cellRectPaintCells.width = this.columnWidthPaintCells - this.columnMarginPaintCells;
                this.cellRectPaintCells.x -= this.columnWidthPaintCells;
                if (this.aColumnPaintCells == this.draggedColumnPaintCells) continue;
                this.paintCell(gr, this.cellRectPaintCells, row, column);
            }
        }
    }

    private void paintDraggedArea(Graphics gr, int rMin, int rMax, TableColumn draggedColumn, int distance) {
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
        Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        this.paintDraggedAreaZero(vacatedColumnRect, gr, distance);
        this.paintDraggedAreaOne(gr, vacatedColumnRect);
        this.paintDraggedAreaTwo(rMin, rMax, distance, gr, draggedColumnIndex);
    }

    private void paintDraggedAreaZero(Rectangle vacatedColumnRect, Graphics gr, int distance) {
        gr.setColor(this.table.getParent().getBackground());
        gr.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        vacatedColumnRect.x += distance;
        gr.setColor(this.table.getBackground());
        gr.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
    }

    private void paintDraggedAreaOne(Graphics gr, Rectangle vacatedColumnRect) {
        if (this.table.getShowVerticalLines()) {
            gr.setColor(this.table.getGridColor());
            int x1 = vacatedColumnRect.x;
            int y1 = vacatedColumnRect.y;
            int x2 = x1 + vacatedColumnRect.width - 1;
            int y2 = y1 + vacatedColumnRect.height - 1;
            gr.drawLine(x1 - 1, y1, x1 - 1, y2);
            gr.drawLine(x2, y1, x2, y2);
        }
    }

    private void paintDraggedAreaTwo(int rMin, int rMax, int distance, Graphics gr, int draggedColumnIndex) {
        for (int row = rMin; row <= rMax; ++row) {
            Rectangle re = this.table.getCellRect(row, draggedColumnIndex, false);
            re.x += distance;
            this.paintCell(gr, re, row, draggedColumnIndex);
            if (!this.table.getShowHorizontalLines()) continue;
            gr.setColor(this.table.getGridColor());
            Rectangle rcr = this.table.getCellRect(row, draggedColumnIndex, true);
            rcr.x += distance;
            int x1 = rcr.x;
            int y1 = rcr.y;
            int x2 = x1 + rcr.width - 1;
            int y2 = y1 + rcr.height - 1;
            gr.drawLine(x1, y2, x2, y2);
        }
    }

    private void paintDropLines(Graphics gr) {
        JTable.DropLocation loc = this.table.getDropLocation();
        if (loc == null) {
            return;
        }
        if (this.dropLineColor == null && this.dropLineShortColor == null) {
            return;
        }
        Rectangle inputRect = this.getHDropLineRect(loc);
        this.initPaintDropLines(inputRect, this.dropLineColor, gr, this.dropLineShortColor, loc);
    }

    private void getVDropLineRectOne(JTable.DropLocation loc, boolean isLtr, int col, Rectangle rect) {
        if (col >= this.table.getColumnCount()) {
            rect = this.table.getCellRect(loc.getRow(), --col, true);
            if (isLtr) {
                rect.x += rect.width;
            }
        } else if (!isLtr) {
            rect.x += rect.width;
        } else {
            rect.getX();
        }
        rect.x = rect.x == 0 ? -1 : (rect.x -= 2);
        rect.width = 3;
    }

    private Rectangle getVDropLineRect(JTable.DropLocation loc) {
        if (!loc.isInsertColumn()) {
            return new Rectangle();
        }
        boolean isLtr = this.table.getComponentOrientation().isLeftToRight();
        int col = loc.getColumn();
        Rectangle rect = this.table.getCellRect(loc.getRow(), col, true);
        this.getVDropLineRectOne(loc, isLtr, col, rect);
        return rect;
    }

    private void initPaintDropLines(Rectangle inputRect, Color color, Graphics gr, Color shortColor, JTable.DropLocation loc) {
        if (inputRect != null) {
            int rx = inputRect.x;
            int rw = inputRect.width;
            if (color != null) {
                this.extendRect(inputRect, true);
                gr.setColor(color);
                gr.fillRect(inputRect.x, inputRect.y, inputRect.width, inputRect.height);
            }
            if (!loc.isInsertColumn() && shortColor != null) {
                gr.setColor(shortColor);
                gr.fillRect(rx, inputRect.y, rw, inputRect.height);
            }
        }
        Rectangle lineInputRect = this.getVDropLineRect(loc);
        int ry = lineInputRect.y;
        int rh = lineInputRect.height;
        if (color != null) {
            this.extendRect(lineInputRect, false);
            gr.setColor(color);
            gr.fillRect(lineInputRect.x, lineInputRect.y, lineInputRect.width, lineInputRect.height);
        }
        if (!loc.isInsertRow() && shortColor != null) {
            gr.setColor(shortColor);
            gr.fillRect(lineInputRect.x, ry, lineInputRect.width, rh);
        }
    }

    private Rectangle getHDropLineRectOne(JTable.DropLocation loc, int row, int col) {
        if (col >= this.table.getColumnCount()) {
            --col;
        }
        Rectangle rect = this.table.getCellRect(row, col, true);
        if (row >= this.table.getRowCount()) {
            Rectangle prevRect = this.table.getCellRect(--row, col, true);
            rect.y = prevRect.y + prevRect.height;
        }
        rect.y = rect.y == 0 ? -1 : (rect.y -= 2);
        rect.height = 3;
        return rect;
    }

    private Rectangle getHDropLineRect(JTable.DropLocation loc) {
        if (!loc.isInsertRow()) {
            return new Rectangle();
        }
        int row = loc.getRow();
        int col = loc.getColumn();
        return this.getHDropLineRectOne(loc, row, col);
    }

    private void extendRectOne(Rectangle rectangle) {
        rectangle.y = 0;
        if (this.table.getRowCount() != 0) {
            Rectangle lastRect = this.table.getCellRect(this.table.getRowCount() - 1, 0, true);
            rectangle.height = lastRect.y + lastRect.height;
        } else {
            rectangle.height = this.table.getHeight();
        }
    }

    private void extendRect(Rectangle rectangle, boolean isHorizontal) {
        if (rectangle == null) {
            return;
        }
        if (isHorizontal) {
            rectangle.x = 0;
            rectangle.width = this.table.getWidth();
        } else {
            this.extendRectOne(rectangle);
        }
    }
}

