/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.search;

import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdPathString {
    private static final Logger log = LoggerFactory.getLogger(MdPathString.class);
    public static final String PYTORCH_MD_STR = MdPathString.readMdFile("/markdown/pytorch_api_mapping.md");
    public static final String TENSORFLOW_MD_STR = MdPathString.readMdFile("/markdown/tensorflow_api_mapping.md");
    private static final String SLASH = "/";

    private static String readMdFile(String mdPath) {
        StringBuilder stringBuilder = new StringBuilder();
        try (InputStream inputStream = MdPathString.class.getResourceAsStream(mdPath);
             InputStreamReader fileReader = new InputStreamReader(inputStream, "UTF-8");
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            boolean isFirstLine = true;
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (!isFirstLine) {
                    stringBuilder.append(System.getProperty("line.separator"));
                } else {
                    isFirstLine = false;
                }
                stringBuilder.append(line);
            }
        }
        catch (JsonParseException | IOException exception) {
            log.info(exception.getMessage());
        }
        return stringBuilder.toString();
    }
}

