/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.services.complete;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.project.Project;
import com.mindspore.ide.toolkit.common.events.EventCenter;
import com.mindspore.ide.toolkit.common.events.SmartCompleteEvents;
import com.mindspore.ide.toolkit.services.complete.SmartCompletionLookupListener;
import com.mindspore.ide.toolkit.services.filter.FilterContext;
import com.mindspore.ide.toolkit.services.filter.FilterManager;
import com.mindspore.ide.toolkit.services.weigher.CompleteSortWeigher;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.SwingUtilities;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartCompletion
extends CompletionContributor {
    private static final Logger log = LoggerFactory.getLogger(SmartCompletion.class);
    private static final long LONGEST_WAITING_TIME = 500L;
    private final SmartCompletionLookupListener smartCompletionLookupListener = new SmartCompletionLookupListener();

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        FilterContext filterContext;
        if (parameters == null) {
            SmartCompletion.$$$reportNull$$$0(0);
        }
        if (result == null) {
            SmartCompletion.$$$reportNull$$$0(1);
        }
        super.fillCompletionVariants(parameters, result);
        CompletionSorter sorter = CompletionService.getCompletionService().defaultSorter(parameters, result.getPrefixMatcher()).weighBefore("liftShorterClasses", new LookupElementWeigher[]{new CompleteSortWeigher()});
        CompletionResultSet resultNew = result.withRelevanceSorter(sorter);
        resultNew.restartCompletionOnAnyPrefixChange();
        this.registerLookupListener(parameters);
        SmartCompleteEvents.CodeRecommendStart codeCompleteStart = new SmartCompleteEvents.CodeRecommendStart();
        this.publishInitData(codeCompleteStart, parameters, resultNew);
        CopyOnWriteArraySet<LookupElement> myProcessResults = new CopyOnWriteArraySet<LookupElement>();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.uiThreadData(parameters, resultNew, myProcessResults, countDownLatch);
        Long startTime = System.currentTimeMillis();
        try {
            Set<LookupElement> smartCompleteResult = codeCompleteStart.getPredictResult().get(500L, TimeUnit.MILLISECONDS);
            if (CollectionUtils.isNotEmpty(smartCompleteResult)) {
                EventCenter.INSTANCE.publish(new SmartCompleteEvents.CodeRecommendEnd());
                this.smartCompletionLookupListener.setMindspore(true);
                this.smartCompletionLookupListener.setPrefix(resultNew.getPrefixMatcher().getPrefix());
            }
            this.countDownLatchAwait(countDownLatch);
            filterContext = new FilterContext(parameters, codeCompleteStart, resultNew, smartCompleteResult, myProcessResults);
            FilterManager.INSTANCE.doFilter(filterContext);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            Long endTime = System.currentTimeMillis();
            this.countDownLatchAwait(countDownLatch);
            resultNew.addAllElements(myProcessResults);
            SmartCompleteEvents.CodeCompleteFailed completeException = new SmartCompleteEvents.CodeCompleteFailed();
            completeException.setException(exception);
            completeException.setDuration(endTime - startTime);
            EventCenter.INSTANCE.publish(completeException);
            log.info("failed to get smartcomplete result,", (Throwable)exception);
            return;
        }
        resultNew.addAllElements(filterContext.getElementSet());
    }

    private void registerLookupListener(CompletionParameters parameters) {
        LookupEx lookupEx = Objects.requireNonNull(LookupManager.getInstance((Project)Objects.requireNonNull(parameters.getEditor().getProject())).getActiveLookup());
        this.smartCompletionLookupListener.setMindspore(false);
        lookupEx.removeLookupListener((LookupListener)this.smartCompletionLookupListener);
        lookupEx.addLookupListener((LookupListener)this.smartCompletionLookupListener);
    }

    private void publishInitData(SmartCompleteEvents.CodeRecommendStart codeCompleteStart, @NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            SmartCompletion.$$$reportNull$$$0(2);
        }
        if (result == null) {
            SmartCompletion.$$$reportNull$$$0(3);
        }
        codeCompleteStart.setDoc(parameters.getEditor().getDocument());
        codeCompleteStart.setMyOffset(parameters.getOffset());
        codeCompleteStart.setPrefix(result.getPrefixMatcher().getPrefix());
        EventCenter.INSTANCE.publish(codeCompleteStart);
    }

    private void uiThreadData(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, Set<LookupElement> myProcessResults, CountDownLatch countDownLatch) {
        if (parameters == null) {
            SmartCompletion.$$$reportNull$$$0(4);
        }
        if (result == null) {
            SmartCompletion.$$$reportNull$$$0(5);
        }
        SwingUtilities.invokeLater(() -> {
            result.runRemainingContributors(parameters, completionResult -> myProcessResults.add(completionResult.getLookupElement()));
            countDownLatch.countDown();
        });
    }

    private void countDownLatchAwait(CountDownLatch countDownLatch) {
        try {
            boolean isCountDownLatch = countDownLatch.await(500L, TimeUnit.MILLISECONDS);
            if (!isCountDownLatch) {
                log.warn("countDownLatchAwait failed");
            }
        }
        catch (InterruptedException interruptedException) {
            log.warn("countDownLatchAwait failed", (Throwable)interruptedException);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/mindspore/ide/toolkit/services/complete/SmartCompletion";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "publishInitData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "uiThreadData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

