/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.smartcomplete;

import com.google.gson.Gson;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.SystemInfo;
import com.mindspore.ide.toolkit.common.ResourceManager;
import com.mindspore.ide.toolkit.common.config.GlobalConfig;
import com.mindspore.ide.toolkit.common.utils.FileUtils;
import com.mindspore.ide.toolkit.common.utils.PathUtils;
import com.mindspore.ide.toolkit.common.utils.YamlUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompleteConfig {
    private static final Logger log = LoggerFactory.getLogger(CompleteConfig.class);
    public static final int DOWNLOAD_TIMEOUT = 300000;
    private static final String DEFAULT_RESOURCE_PATH = PathUtils.getDefaultResourcePath();
    private static final String PLUGIN_VERSION = CompleteConfig.getPluginVersion();
    private static final String PRODUCT_NAME_WITH_EDITION = ApplicationNamesInfo.getInstance().getFullProductNameWithEdition();
    private final String defaultPluginVersion = "default_plugin_version";
    private final String lowLine = "_";
    private boolean extranet;
    private String localDir;
    private String modelFolder;
    private Map<String, ModelOfSpecificOs> modelMap;

    public static CompleteConfig get() {
        return ConfigBuilder.CONFIG;
    }

    public String getModelZipFullPath(Model model) {
        return String.join((CharSequence)File.separator, PathUtils.getDefaultResourcePath(), this.localDir, PRODUCT_NAME_WITH_EDITION, this.modelFolder, model.pluginVersion, model.modelVersion, model.modelZipName);
    }

    public String getModelZipParentPath(Model model) {
        return String.join((CharSequence)File.separator, PathUtils.getDefaultResourcePath(), this.localDir, PRODUCT_NAME_WITH_EDITION, this.modelFolder, model.pluginVersion, model.modelVersion);
    }

    public String getModelUnzipFolderFullPath(Model model) {
        return String.join((CharSequence)File.separator, PathUtils.getDefaultResourcePath(), this.localDir, PRODUCT_NAME_WITH_EDITION, this.modelFolder, model.pluginVersion, model.modelVersion, model.modelUnzipFolderName);
    }

    public String getModelExeFullPath(Model model) {
        return String.join((CharSequence)File.separator, PathUtils.getDefaultResourcePath(), this.localDir, PRODUCT_NAME_WITH_EDITION, this.modelFolder, model.pluginVersion, model.modelVersion, model.modelUnzipFolderName, model.modelExePath);
    }

    public String getModelFolderPath() {
        return String.join((CharSequence)File.separator, PathUtils.getDefaultResourcePath(), this.localDir, PRODUCT_NAME_WITH_EDITION, this.modelFolder);
    }

    public String getPluginVersionFolderPath(@NotNull String pluginVersion) {
        if (pluginVersion == null) {
            CompleteConfig.$$$reportNull$$$0(0);
        }
        return String.join((CharSequence)File.separator, PathUtils.getDefaultResourcePath(), this.localDir, PRODUCT_NAME_WITH_EDITION, this.modelFolder, pluginVersion);
    }

    public Model getCurrentModel() {
        ModelOfSpecificOs modelOfSpecificOs = this.modelMap.get(PLUGIN_VERSION);
        Model model = null;
        if (modelOfSpecificOs != null) {
            model = modelOfSpecificOs.getModelOfCurrentOs();
        }
        if (model == null) {
            model = this.modelMap.get("default_plugin_version").getModelOfCurrentOs();
            model.setPluginVersion("default_plugin_version");
        } else {
            model.setPluginVersion(PLUGIN_VERSION);
        }
        return model;
    }

    public Optional<Model> getOldModelInDisk() {
        Set<Object> pluginVersionSet = Collections.emptySet();
        try {
            pluginVersionSet = FileUtils.listAllDirectory(Paths.get(this.getModelFolderPath(), new String[0]));
        }
        catch (IOException ioException) {
            log.warn("List model file failed, cannot list plugin version.", (Throwable)ioException);
        }
        for (String string : pluginVersionSet) {
            Set<Object> modelVersionSet = Collections.emptySet();
            try {
                modelVersionSet = FileUtils.listAllDirectory(Paths.get(this.getPluginVersionFolderPath(string), new String[0]));
            }
            catch (IOException ioException) {
                log.warn("List model file failed, cannot list model version.", (Throwable)ioException);
            }
            Model currentModel = this.getCurrentModel();
            for (String string2 : modelVersionSet) {
                if (Objects.equals(string, currentModel.pluginVersion) && Objects.equals(string2, currentModel.modelVersion)) continue;
                Model oldModel = this.cloneModel(currentModel);
                oldModel.setModelVersion(string2);
                oldModel.setPluginVersion(string);
                return Optional.of(oldModel);
            }
        }
        return Optional.empty();
    }

    private Model cloneModel(Model model) {
        Gson gson = new Gson();
        return (Model)gson.fromJson(gson.toJson((Object)model), Model.class);
    }

    private static String getPluginVersion() {
        String pluginIdStr = "com.mindspore";
        return PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)pluginIdStr)).getVersion();
    }

    public String getDefaultPluginVersion() {
        return this.defaultPluginVersion;
    }

    public String getLowLine() {
        return this.lowLine;
    }

    public boolean isExtranet() {
        return this.extranet;
    }

    public String getLocalDir() {
        return this.localDir;
    }

    public String getModelFolder() {
        return this.modelFolder;
    }

    public Map<String, ModelOfSpecificOs> getModelMap() {
        return this.modelMap;
    }

    public void setExtranet(boolean extranet) {
        this.extranet = extranet;
    }

    public void setLocalDir(String localDir) {
        this.localDir = localDir;
    }

    public void setModelFolder(String modelFolder) {
        this.modelFolder = modelFolder;
    }

    public void setModelMap(Map<String, ModelOfSpecificOs> modelMap) {
        this.modelMap = modelMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompleteConfig)) {
            return false;
        }
        CompleteConfig other = (CompleteConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$defaultPluginVersion = this.getDefaultPluginVersion();
        String other$defaultPluginVersion = other.getDefaultPluginVersion();
        if (this$defaultPluginVersion == null ? other$defaultPluginVersion != null : !this$defaultPluginVersion.equals(other$defaultPluginVersion)) {
            return false;
        }
        String this$lowLine = this.getLowLine();
        String other$lowLine = other.getLowLine();
        if (this$lowLine == null ? other$lowLine != null : !this$lowLine.equals(other$lowLine)) {
            return false;
        }
        if (this.isExtranet() != other.isExtranet()) {
            return false;
        }
        String this$localDir = this.getLocalDir();
        String other$localDir = other.getLocalDir();
        if (this$localDir == null ? other$localDir != null : !this$localDir.equals(other$localDir)) {
            return false;
        }
        String this$modelFolder = this.getModelFolder();
        String other$modelFolder = other.getModelFolder();
        if (this$modelFolder == null ? other$modelFolder != null : !this$modelFolder.equals(other$modelFolder)) {
            return false;
        }
        Map<String, ModelOfSpecificOs> this$modelMap = this.getModelMap();
        Map<String, ModelOfSpecificOs> other$modelMap = other.getModelMap();
        return !(this$modelMap == null ? other$modelMap != null : !((Object)this$modelMap).equals(other$modelMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CompleteConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $defaultPluginVersion = this.getDefaultPluginVersion();
        result = result * 59 + ($defaultPluginVersion == null ? 43 : $defaultPluginVersion.hashCode());
        String $lowLine = this.getLowLine();
        result = result * 59 + ($lowLine == null ? 43 : $lowLine.hashCode());
        result = result * 59 + (this.isExtranet() ? 79 : 97);
        String $localDir = this.getLocalDir();
        result = result * 59 + ($localDir == null ? 43 : $localDir.hashCode());
        String $modelFolder = this.getModelFolder();
        result = result * 59 + ($modelFolder == null ? 43 : $modelFolder.hashCode());
        Map<String, ModelOfSpecificOs> $modelMap = this.getModelMap();
        result = result * 59 + ($modelMap == null ? 43 : ((Object)$modelMap).hashCode());
        return result;
    }

    public String toString() {
        return "CompleteConfig(defaultPluginVersion=" + this.getDefaultPluginVersion() + ", lowLine=" + this.getLowLine() + ", extranet=" + this.isExtranet() + ", localDir=" + this.getLocalDir() + ", modelFolder=" + this.getModelFolder() + ", modelMap=" + this.getModelMap() + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginVersion", "com/mindspore/ide/toolkit/smartcomplete/CompleteConfig", "getPluginVersionFolderPath"));
    }

    public static class Model {
        private String modelDownloadUrl;
        private String accessToken;
        private String modelZipName;
        private String modelUnzipFolderName;
        private String modelExePath;
        private String modelVersion;
        private String pluginVersion;

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Model)) {
                return false;
            }
            Model other = (Model)obj;
            if (!Objects.equals(this.modelDownloadUrl, other.modelDownloadUrl)) {
                return false;
            }
            if (!Objects.equals(this.accessToken, other.accessToken)) {
                return false;
            }
            if (!Objects.equals(this.modelZipName, other.modelZipName)) {
                return false;
            }
            if (!Objects.equals(this.modelUnzipFolderName, other.modelUnzipFolderName)) {
                return false;
            }
            if (!Objects.equals(this.modelExePath, other.modelExePath)) {
                return false;
            }
            if (!Objects.equals(this.modelVersion, other.modelVersion)) {
                return false;
            }
            return Objects.equals(this.pluginVersion, other.pluginVersion);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + (this.modelDownloadUrl == null ? 0 : this.modelDownloadUrl.hashCode());
            result = 31 * result + (this.accessToken == null ? 0 : this.accessToken.hashCode());
            result = 31 * result + (this.modelZipName == null ? 0 : this.modelZipName.hashCode());
            result = 31 * result + (this.modelUnzipFolderName == null ? 0 : this.modelUnzipFolderName.hashCode());
            result = 31 * result + (this.modelExePath == null ? 0 : this.modelExePath.hashCode());
            result = 31 * result + (this.modelVersion == null ? 0 : this.modelVersion.hashCode());
            return 31 * result + (this.pluginVersion == null ? 0 : this.pluginVersion.hashCode());
        }

        public String getModelDownloadUrl() {
            return this.modelDownloadUrl;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getModelZipName() {
            return this.modelZipName;
        }

        public String getModelUnzipFolderName() {
            return this.modelUnzipFolderName;
        }

        public String getModelExePath() {
            return this.modelExePath;
        }

        public String getModelVersion() {
            return this.modelVersion;
        }

        public String getPluginVersion() {
            return this.pluginVersion;
        }

        public void setModelDownloadUrl(String modelDownloadUrl) {
            this.modelDownloadUrl = modelDownloadUrl;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public void setModelZipName(String modelZipName) {
            this.modelZipName = modelZipName;
        }

        public void setModelUnzipFolderName(String modelUnzipFolderName) {
            this.modelUnzipFolderName = modelUnzipFolderName;
        }

        public void setModelExePath(String modelExePath) {
            this.modelExePath = modelExePath;
        }

        public void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        public void setPluginVersion(String pluginVersion) {
            this.pluginVersion = pluginVersion;
        }
    }

    public static class ModelOfSpecificOs {
        private Model windows;
        private Model linux;

        public Model getModelOfCurrentOs() {
            if (SystemInfo.isWindows) {
                return this.windows;
            }
            return this.linux;
        }

        public Model getWindows() {
            return this.windows;
        }

        public Model getLinux() {
            return this.linux;
        }

        public void setWindows(Model windows) {
            this.windows = windows;
        }

        public void setLinux(Model linux) {
            this.linux = linux;
        }
    }

    private static class ConfigBuilder {
        private static final CompleteConfig CONFIG;
        private static final GlobalConfig.CompleteModelInfo MODEL_INFO;
        private static final String OLD_FILE;
        private static final String NEW_FILE;
        private static final String RESOURCE_FILE = "config/complete.yaml";

        private ConfigBuilder() {
        }

        private static Optional<CompleteConfig> getInstance() {
            Optional<CompleteConfig> instance;
            if (Files.exists(Paths.get(OLD_FILE, new String[0]), new LinkOption[0]) && Files.exists(Paths.get(NEW_FILE, new String[0]), new LinkOption[0])) {
                if (FileUtils.isSame(Paths.get(OLD_FILE, new String[0]), Paths.get(NEW_FILE, new String[0]))) {
                    instance = ConfigBuilder.getLocalInstance(OLD_FILE);
                } else {
                    instance = ConfigBuilder.getLocalInstance(NEW_FILE);
                    FileUtils.rename(OLD_FILE, NEW_FILE);
                }
            } else if (Files.exists(Paths.get(NEW_FILE, new String[0]), new LinkOption[0])) {
                instance = ConfigBuilder.getLocalInstance(NEW_FILE);
                FileUtils.rename(OLD_FILE, NEW_FILE);
            } else {
                instance = Files.exists(Paths.get(OLD_FILE, new String[0]), new LinkOption[0]) ? ConfigBuilder.getLocalInstance(OLD_FILE) : ConfigBuilder.getResourceInstance(RESOURCE_FILE);
            }
            return instance;
        }

        private static Optional<CompleteConfig> getLocalInstance(String file) {
            return YamlUtils.INSTANCE.readLocalFile(file, CompleteConfig.class);
        }

        private static Optional<CompleteConfig> getResourceInstance(String file) {
            return YamlUtils.INSTANCE.readResourceFile(file, CompleteConfig.class);
        }

        static {
            MODEL_INFO = GlobalConfig.get().getCompleteModelInfo();
            OLD_FILE = String.join((CharSequence)File.separator, DEFAULT_RESOURCE_PATH, MODEL_INFO.getParentDir(), PRODUCT_NAME_WITH_EDITION, MODEL_INFO.getOldConfig());
            NEW_FILE = String.join((CharSequence)File.separator, DEFAULT_RESOURCE_PATH, MODEL_INFO.getParentDir(), PRODUCT_NAME_WITH_EDITION, MODEL_INFO.getNewConfig());
            if (SystemInfo.isWindows || SystemInfo.isLinux) {
                int maxDownloadTimes = 3;
                boolean downloadSucceed = false;
                for (int i = 0; i < maxDownloadTimes && !(downloadSucceed = ResourceManager.downloadResource(MODEL_INFO.getDownloadUrl(), NEW_FILE, MODEL_INFO.getToken(), 300000)); ++i) {
                }
                if (!downloadSucceed) {
                    log.warn("Download complete model config failed.");
                }
                CONFIG = ConfigBuilder.getInstance().get();
            } else {
                CONFIG = ConfigBuilder.getResourceInstance(RESOURCE_FILE).get();
            }
        }
    }
}

