/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.smartcomplete;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.TextRange;
import com.mindspore.ide.toolkit.common.events.SmartCompleteEvents;
import com.mindspore.ide.toolkit.protomessage.CompleteReply;
import com.mindspore.ide.toolkit.protomessage.ResultEntries;
import com.mindspore.ide.toolkit.protomessage.ResultEntry;
import com.mindspore.ide.toolkit.services.complete.MindSporeLookupElement;
import com.mindspore.ide.toolkit.smartcomplete.ModelManager;
import com.mindspore.ide.toolkit.smartcomplete.grpc.CompletionException;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CompleteService {
    COMPLETE;

    private static final Logger log;

    public void onPredicting(SmartCompleteEvents.CodeRecommendStart codeRecommendStart) {
        String formattedContent = this.getContentBeforeCursor(codeRecommendStart);
        log.info("Data send to model is: {}", (Object)formattedContent);
        Set<String> backMsgSet = this.getBackMsgFormModelToGrpc(formattedContent, codeRecommendStart.getPrefix());
        Set<LookupElement> lookupElements = this.getLookupElementSet(backMsgSet);
        codeRecommendStart.getPredictResult().complete(lookupElements);
    }

    private String getContentBeforeCursor(SmartCompleteEvents.CodeRecommendStart codeRecommendStart) {
        if (codeRecommendStart.getDoc() == null) {
            return "";
        }
        int maxContentLength = 500;
        int endIndex = codeRecommendStart.getMyOffset();
        int beginIndex = Integer.max(0, endIndex - 500);
        return codeRecommendStart.getDoc().getText(new TextRange(beginIndex, endIndex));
    }

    private Set<String> getBackMsgFormModelToGrpc(String content, String prefix) {
        LinkedHashSet<String> predictSet = new LinkedHashSet<String>();
        try {
            Optional<CompleteReply> completeReply = ModelManager.INSTANCE.communicateWithModel(content, prefix);
            if (completeReply.isPresent()) {
                String oldPrefix = completeReply.get().getOldPrefix();
                ResultEntries resultEntries = completeReply.get().getResults();
                log.info("Has data from model. Data count: {}", (Object)resultEntries.getResultEntryCount());
                for (int index = 0; index < resultEntries.getResultEntryCount(); ++index) {
                    ResultEntry entry = resultEntries.getResultEntry(index);
                    log.info("  Data from model is: {}:{}", (Object)entry.getNewPrefix(), (Object)entry.getDetails());
                    String newPrefix = this.trimEnd(entry.getNewPrefix().toCharArray());
                    if (!Objects.equals(prefix, oldPrefix) && newPrefix.startsWith(oldPrefix)) {
                        newPrefix = newPrefix.replaceFirst(Pattern.quote(oldPrefix), prefix);
                    }
                    if (!Objects.equals(prefix, newPrefix) && !newPrefix.isBlank()) {
                        predictSet.add(newPrefix);
                        log.info("  Data presented to user is: {}:{}", (Object)newPrefix, (Object)entry.getDetails());
                        continue;
                    }
                    log.info("  Data is not displayed to user: {}:{}", (Object)entry.getNewPrefix(), (Object)entry.getDetails());
                }
            } else {
                log.info("No data from model.");
            }
        }
        catch (CompletionException completionException) {
            log.warn("Get message from completion model failed.", (Throwable)completionException);
        }
        return predictSet;
    }

    private Set<LookupElement> getLookupElementSet(Set<String> predictSet) {
        int maxResult = 5;
        LinkedHashSet<LookupElement> lookupElements = new LinkedHashSet<LookupElement>(maxResult);
        for (String code : predictSet) {
            lookupElements.add(new MindSporeLookupElement((LookupElement)LookupElementBuilder.create((String)code).withBoldness(true)));
        }
        return lookupElements;
    }

    private String trimEnd(char[] value) {
        int len;
        int startIndex = 0;
        for (len = value.length; startIndex < len && value[len - 1] <= ' '; --len) {
        }
        String finalValue = new String(value);
        return len < value.length ? finalValue.substring(startIndex, len) : finalValue;
    }

    static {
        log = LoggerFactory.getLogger(CompleteService.class);
    }
}

