/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.wizard;

import com.google.gson.reflect.TypeToken;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.mindspore.ide.toolkit.common.dialoginfo.DialogInfo;
import com.mindspore.ide.toolkit.common.dialoginfo.ExceptionDialogInfo;
import com.mindspore.ide.toolkit.common.enums.EnumHardWarePlatform;
import com.mindspore.ide.toolkit.common.enums.EnumProperties;
import com.mindspore.ide.toolkit.common.exceptions.MsToolKitException;
import com.mindspore.ide.toolkit.common.utils.GsonUtils;
import com.mindspore.ide.toolkit.common.utils.NotificationUtils;
import com.mindspore.ide.toolkit.common.utils.ZipCompressingUtils;
import com.mindspore.ide.toolkit.wizard.CondaCmdProcessor;
import com.mindspore.ide.toolkit.wizard.MsEnvValidator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MindSporeService {
    private static final Logger log = LoggerFactory.getLogger(MindSporeService.class);
    private static final String TEMP_PATH = EnumProperties.MIND_SPORE_PROPERTIES.getProperty("mindspore.template.zip.path");
    private static final String TEMP_PATH_ENTRIES = EnumProperties.MIND_SPORE_PROPERTIES.getProperty("mindspore.template.zip.path.entries");
    private static final String TEMP_PATH_STRUCTURE = EnumProperties.MIND_SPORE_PROPERTIES.getProperty("mindspore.path.structure");

    public static Boolean createMindSporeTemplate(String targetFilePath, String fileName) {
        if (fileName.isEmpty() || fileName.equals("<empty>")) {
            return true;
        }
        try {
            ZipCompressingUtils.unzipFile(TEMP_PATH + fileName + ".zip", targetFilePath);
            return true;
        }
        catch (FileNotFoundException exception) {
            NotificationUtils.notify(NotificationUtils.NotifyGroup.NEW_PROJECT, NotificationType.ERROR, "Unable to create MindSpore template.");
            log.warn("zip file not find, unable to create MindSpore template", (Throwable)exception);
            return false;
        }
        catch (IOException exception) {
            NotificationUtils.notify(NotificationUtils.NotifyGroup.NEW_PROJECT, NotificationType.ERROR, "Unable to create MindSpore template.");
            log.warn("Unable to create MindSpore template.", (Throwable)exception);
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<String> listTemplates() {
        try (InputStream input = MindSporeService.class.getResourceAsStream(TEMP_PATH_ENTRIES);){
            List list;
            try (InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);){
                list = (List)GsonUtils.INSTANCE.getGson().fromJson((Reader)reader, TypeToken.getParameterized(List.class, (Type[])new Type[]{String.class}).getType());
            }
            return list;
        }
        catch (IOException exception) {
            return new ArrayList<String>();
        }
    }

    public static Boolean createStructure(String baseDir) {
        List dirs;
        try (InputStream input = MindSporeService.class.getResourceAsStream(TEMP_PATH_STRUCTURE);
             InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);){
            dirs = (List)GsonUtils.INSTANCE.getGson().fromJson((Reader)reader, TypeToken.getParameterized(List.class, (Type[])new Type[]{String.class}).getType());
        }
        catch (IOException exception) {
            return false;
        }
        for (String dir : dirs) {
            try {
                Files.createDirectories(Path.of(baseDir + File.separator + dir, new String[0]), new FileAttribute[0]);
            }
            catch (IOException exception) {
                return false;
            }
        }
        return true;
    }

    public static DialogInfo installMindSporeIntoConda(String hardwarePlatform, Sdk sdk) throws MsToolKitException {
        List<String> cmdList;
        if (hardwarePlatform.contains(EnumHardWarePlatform.CPU.getCode())) {
            cmdList = Arrays.asList("install", String.format("mindspore-%s", EnumHardWarePlatform.CPU.getCode().toLowerCase(Locale.ROOT)), "-c", "mindspore", "-c", "conda-forge", "-y");
        } else if (hardwarePlatform.contains(EnumHardWarePlatform.GPU.getCode())) {
            String version = hardwarePlatform.split(" ")[2];
            cmdList = Arrays.asList("install", String.format("mindspore-%s", EnumHardWarePlatform.GPU.getCode().toLowerCase(Locale.ROOT)), String.format("cudatoolkit=%s", version), "cudnn", "-c", "mindspore", "-c", "conda-forge", "-y");
        } else if (hardwarePlatform.contains(EnumHardWarePlatform.ASCEND.getCode())) {
            cmdList = Arrays.asList("install", String.format("mindspore-%s", EnumHardWarePlatform.ASCEND.getCode().toLowerCase(Locale.ROOT)), "-c", "mindspore", "-c", "conda-forge", "-y");
        } else {
            throw new MsToolKitException("install MindSpore: hardware platform not supported");
        }
        return CondaCmdProcessor.executeCondaCmd(sdk, null, cmdList);
    }

    public static Task.WithResult<Boolean, Exception> installMindSporeTask(Project project, final String hardware, final Sdk sdk) {
        return new Task.WithResult(project, "Install MindSpore into Conda", true){

            public Boolean compute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    boolean isMsEnvValidate;
                    DialogInfo dialogInfo = MindSporeService.installMindSporeIntoConda(hardware, sdk);
                    dialogInfo.showDialog("Install MindSpore into conda");
                    boolean bl = isMsEnvValidate = MsEnvValidator.validateMindSpore(sdk) == MsEnvValidator.MsEnvStatus.AVAILABLE;
                    if (!isMsEnvValidate && dialogInfo.isSuccessful()) {
                        new ExceptionDialogInfo.Builder().isSuccessful(false).description("Failed to run the verification script. There maybe something wrong. If MindSpore is abnormal, you can reinstall it.").build().showDialog("Install MindSpore into conda");
                    }
                    return isMsEnvValidate && dialogInfo.isSuccessful();
                }
                catch (MsToolKitException msToolKitException) {
                    ExceptionDialogInfo.parseException(msToolKitException, new Object[0]).showDialog("Install MindSpore into conda");
                    return false;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/mindspore/ide/toolkit/wizard/MindSporeService$1", "compute"));
            }
        };
    }
}

