/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.wizard;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.mindspore.ide.toolkit.common.utils.GsonUtils;
import com.mindspore.ide.toolkit.common.utils.OSInfoUtils;
import com.mindspore.ide.toolkit.wizard.MSVersionInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MsVersionManager {
    INSTANCE;

    private final Logger LOG = LoggerFactory.getLogger(MsVersionManager.class);
    private LinkedHashMap<String, MSVersionInfo> mindSporeMap = new LinkedHashMap();
    private String curOsDesc = OSInfoUtils.INSTANCE.getOsName().toLowerCase(Locale.ENGLISH);

    private MsVersionManager() {
        this.parseJsonFile("/jsons/MSVersionInfo.json", this.mindSporeMap);
    }

    private void parseJsonFile(@NotNull String jsonFile, @NotNull HashMap map) {
        if (jsonFile == null) {
            MsVersionManager.$$$reportNull$$$0(0);
        }
        if (map == null) {
            MsVersionManager.$$$reportNull$$$0(1);
        }
        try (InputStream inputStream = MsVersionManager.class.getResourceAsStream(jsonFile);
             InputStreamReader fileReader = new InputStreamReader(inputStream, "UTF-8");
             JsonReader reader = new JsonReader((Reader)fileReader);){
            Type collectionType = new TypeToken<Collection<MSVersionInfo>>(){}.getType();
            Collection msVersionInfos = (Collection)GsonUtils.INSTANCE.getGson().fromJson(reader, collectionType);
            for (MSVersionInfo msVersionInfo : msVersionInfos) {
                map.put(msVersionInfo.getName(), msVersionInfo);
            }
        }
        catch (JsonParseException | IOException exception) {
            this.LOG.warn("Error of reading from file : path is {}", (Object)jsonFile);
        }
    }

    public HashSet<MSVersionInfo> hardwarePlatformInfo() {
        HashSet<MSVersionInfo> resList = new HashSet<MSVersionInfo>();
        this.mindSporeMap.forEach((key, value) -> value.getOsInfoList().forEach(info -> {
            if (info.contains(this.curOsDesc)) {
                resList.add((MSVersionInfo)value);
            }
        }));
        return resList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "jsonFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "map";
                break;
            }
        }
        objectArray[1] = "com/mindspore/ide/toolkit/wizard/MsVersionManager";
        objectArray[2] = "parseJsonFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

