# PyTorch与MindSpore

<a href="https://gitee.com/mindspore/docs/blob/r1.7/docs/mindspore/source_zh_cn/note/api_mapping/pytorch_api_mapping.md" target="_blank"><img src="https://mindspore-website.obs.cn-north-4.myhuaweicloud.com/website-images/r1.7/resource/_static/logo_source.png"></a>

由社区提供的PyTorch APIs和MindSpore APIs之间的映射，可能在参数、输入、输出、逻辑功能和特定场景等方面存在差异，可详见各API描述或已提供的差异对比。

也欢迎更多的MindSpore开发者参与完善映射内容。

## torch

| PyTorch 1.5.0 APIs                                                                           | MindSpore APIs                                                                                                                                                          | 说明                                                                                                                     |
| -------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------ |
| [torch.abs](https://pytorch.org/docs/1.5.0/torch.html#torch.abs)                             | [mindspore.ops.Abs](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Abs.html#mindspore.ops.Abs)                                                 |                                                                                                                          |
| [torch.acos](https://pytorch.org/docs/1.5.0/torch.html#torch.acos)                           | [mindspore.ops.ACos](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.ACos.html#mindspore.ops.ACos)                                              |                                                                                                                          |
| [torch.add](https://pytorch.org/docs/1.5.0/torch.html#torch.add)                             | [mindspore.ops.Add](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Add.html#mindspore.ops.Add)                                                 |                                                                                                                          |
| [torch.arange](https://pytorch.org/docs/1.5.0/torch.html#torch.arange)                       | [mindspore.numpy.arange](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.arange.html#mindspore.numpy.arange)                                |                                                                                                                          |
| [torch.argmax](https://pytorch.org/docs/1.5.0/torch.html#torch.argmax)                       | [mindspore.ops.Argmax](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Argmax.html#mindspore.ops.Argmax)                                        |                                                                                                                          |
| [torch.argmin](https://pytorch.org/docs/1.5.0/torch.html#torch.argmin)                       | [mindspore.ops.Argmin](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Argmin.html#mindspore.ops.Argmin)                                        |                                                                                                                          |
| [torch.argsort](https://pytorch.org/docs/1.5.0/torch.html#torch.argsort)                     | [mindspore.ops.Sort](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Sort.html#mindspore.ops.Sort)                                              | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/Sort.html)                |
| [torch.asin](https://pytorch.org/docs/1.5.0/torch.html#torch.asin)                           | [mindspore.ops.Asin](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Asin.html#mindspore.ops.Asin)                                              |                                                                                                                          |
| [torch.atan](https://pytorch.org/docs/1.5.0/torch.html#torch.atan)                           | [mindspore.ops.Atan](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Atan.html#mindspore.ops.Atan)                                              |                                                                                                                          |
| [torch.atan2](https://pytorch.org/docs/1.5.0/torch.html#torch.atan2)                         | [mindspore.ops.Atan2](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Atan2.html#mindspore.ops.Atan2)                                           |                                                                                                                          |
| [torch.bartlett_window](https://pytorch.org/docs/1.5.0/torch.html#torch.bartlett_window)     | [mindspore.numpy.bartlett](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.bartlett.html#mindspore.numpy.bartlett)                          |                                                                                                                          |
| [torch.bincount](https://pytorch.org/docs/1.5.0/torch.html#torch.bincount)                   | [mindspore.numpy.bincount](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.bincount.html#mindspore.numpy.bincount)                          |                                                                                                                          |
| [torch.bitwise_and](https://pytorch.org/docs/1.5.0/torch.html#torch.bitwise_and)             | [mindspore.ops.BitwiseAnd](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.BitwiseAnd.html#mindspore.ops.BitwiseAnd)                            |                                                                                                                          |
| [torch.bitwise_or](https://pytorch.org/docs/1.5.0/torch.html#torch.bitwise_or)               | [mindspore.ops.BitwiseOr](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.BitwiseOr.html#mindspore.ops.BitwiseOr)                               |                                                                                                                          |
| [torch.bitwise_xor](https://pytorch.org/docs/1.5.0/torch.html#torch.bitwise_xor)             | [mindspore.ops.BitwiseXor](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.BitwiseXor.html#mindspore.ops.BitwiseXor)                            |                                                                                                                          |
| [torch.blackman_window](https://pytorch.org/docs/1.5.0/torch.html#torch.blackman_window)     | [mindspore.numpy.blackman](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.blackman.html#mindspore.numpy.blackman)                          |                                                                                                                          |
| [torch.bmm](https://pytorch.org/docs/1.5.0/torch.html#torch.bmm)                             | [mindspore.ops.BatchMatMul](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.BatchMatMul.html#mindspore.ops.BatchMatMul)                         |                                                                                                                          |
| [torch.broadcast_tensors](https://pytorch.org/docs/1.5.0/torch.html#torch.broadcast_tensors) | [mindspore.ops.BroadcastTo](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.BroadcastTo.html#mindspore.ops.BroadcastTo)                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/BroadcastTo.html)         |
| [torch.cat](https://pytorch.org/docs/1.5.0/torch.html#torch.cat)                             | [mindspore.ops.Concat](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Concat.html#mindspore.ops.Concat)                                        | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/Concat.html)              |
| [torch.ceil](https://pytorch.org/docs/1.5.0/torch.html#torch.ceil)                           | [mindspore.ops.Ceil](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Ceil.html#mindspore.ops.Ceil)                                              |                                                                                                                          |
| [torch.chunk](https://pytorch.org/docs/1.5.0/torch.html#torch.chunk)                         | [mindspore.ops.Split](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Split.html#mindspore.ops.Split)                                           |                                                                                                                          |
| [torch.clamp](https://pytorch.org/docs/1.5.0/torch.html#torch.clamp)                         | [mindspore.ops.clip_by_value](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.clip_by_value.html#mindspore.ops.clip_by_value)                   | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/clip_by_value.html)                                                                                                                         |
| [torch.conj](https://pytorch.org/docs/1.5.0/torch.html#torch.conj)                           | [mindspore.ops.Conj](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Conj.html#mindspore.ops.Conj)                                              |                                                                                                                          |
| [torch.cos](https://pytorch.org/docs/1.5.0/torch.html#torch.cos)                             | [mindspore.ops.Cos](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Cos.html#mindspore.ops.Cos)                                                 |                                                                                                                          |
| [torch.cosh](https://pytorch.org/docs/1.5.0/torch.html#torch.cosh)                           | [mindspore.ops.Cosh](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Cosh.html#mindspore.ops.Cosh)                                              |                                                                                                                          |
| [torch.cross](https://pytorch.org/docs/1.5.0/torch.html#torch.cross)                         | [mindspore.numpy.cross](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.cross.html#mindspore.numpy.cross)                                   | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/cross.html)               |
| [torch.cumprod](https://pytorch.org/docs/1.5.0/torch.html#torch.cumprod)                     | [mindspore.ops.CumProd](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.CumProd.html#mindspore.ops.CumProd)                                     |                                                                                                                          |
| [torch.cumsum](https://pytorch.org/docs/1.5.0/torch.html#torch.cumsum)                       | [mindspore.ops.CumSum](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.CumSum.html#mindspore.ops.CumSum)                                        |                                                                                                                          |
| [torch.diag](https://pytorch.org/docs/1.5.0/torch.html#torch.diag)                           | [mindspore.nn.MatrixDiag](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.MatrixDiag.html#mindspore.nn.MatrixDiag)                                | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/MatrixDiag.html)          |
| [torch.diagflat](https://pytorch.org/docs/1.5.0/torch.html#torch.diagflat)                   | [mindspore.numpy.diagflat](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.diagflat.html#mindspore.numpy.diagflat)                          |                                                                                                                          |
| [torch.diagonal](https://pytorch.org/docs/1.5.0/torch.html#torch.diagonal)                   | [mindspore.numpy.diagonal](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.diagonal.html#mindspore.numpy.diagonal)                          |                                                                                                                          |
| [torch.div](https://pytorch.org/docs/1.5.0/torch.html#torch.div)                             | [mindspore.ops.Div](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Div.html#mindspore.ops.Div)                                                 |                                                                                                                          |
| [torch.dot](https://pytorch.org/docs/1.5.0/torch.html#torch.dot)                             | [mindspore.ops.tensor_dot](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.tensor_dot.html#mindspore.ops.tensor_dot)                            | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/tensor_dot.html)          |
| [torch.empty](https://pytorch.org/docs/1.5.0/torch.html#torch.empty)                         | [mindspore.numpy.empty](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.empty.html#mindspore.numpy.empty)                                   |                                                                                                                          |
| [torch.empty_like](https://pytorch.org/docs/1.5.0/torch.html#torch.empty_like)               | [mindspore.numpy.empty_like](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.empty_like.html#mindspore.numpy.empty_like)                    |                                                                                                                          |
| [torch.eq](https://pytorch.org/docs/1.5.0/torch.html#torch.eq)                               | [mindspore.ops.Equal](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Equal.html#mindspore.ops.Equal)                                           |                                                                                                                          |
| [torch.erfc](https://pytorch.org/docs/1.5.0/torch.html#torch.erfc)                           | [mindspore.ops.Erfc](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Erfc.html#mindspore.ops.Erfc)                                              |                                                                                                                          |
| [torch.erfinv](https://pytorch.org/docs/1.5.0/torch.html#torch.erfinv)                       | [mindspore.ops.Erfinv](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Erfinv.html#mindspore.ops.Erfinv)                                        |                                                                                                                          |
| [torch.exp](https://pytorch.org/docs/1.5.0/torch.html#torch.exp)                             | [mindspore.ops.Exp](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Exp.html#mindspore.ops.Exp)                                                 |                                                                                                                          |
| [torch.expm1](https://pytorch.org/docs/1.5.0/torch.html#torch.expm1)                         | [mindspore.ops.Expm1](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Expm1.html#mindspore.ops.Expm1)                                           |                                                                                                                          |
| [torch.eye](https://pytorch.org/docs/1.5.0/torch.html#torch.eye)                             | [mindspore.ops.Eye](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Eye.html#mindspore.ops.Eye)                                                 |                                                                                                                          |
| [torch.flatten](https://pytorch.org/docs/1.5.0/torch.html#torch.flatten)                     | [mindspore.ops.Flatten](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Flatten.html#mindspore.ops.Flatten)                                     | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/Flatten.html)             |
| [torch.flip](https://pytorch.org/docs/1.5.0/torch.html#torch.flip)                           | [mindspore.ops.ReverseV2](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.ReverseV2.html#mindspore.ops.ReverseV2)                               |                                                                                                                          |
| [torch.floor](https://pytorch.org/docs/1.5.0/torch.html#torch.floor)                         | [mindspore.ops.Floor](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Floor.html#mindspore.ops.Floor)                                           |                                                                                                                          |
| [torch.floor_divide](https://pytorch.org/docs/1.5.0/torch.html#torch.floor_divide)           | [mindspore.ops.FloorDiv](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.FloorDiv.html#mindspore.ops.FloorDiv)                                  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/FloorDiv.html)            |
| [torch.fmod](https://pytorch.org/docs/1.5.0/torch.html#torch.fmod)                           | [mindspore.ops.Mod](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Mod.html#mindspore.ops.Mod)                                                 |                                                                                                                          |
| [torch.from_numpy](https://pytorch.org/docs/1.5.0/torch.html#torch.from_numpy)               | [mindspore.tensor.from_numpy](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html?#mindspore.Tensor.from_numpy)                       |                                                                                                                          |
| [torch.full](https://pytorch.org/docs/1.5.0/torch.html#torch.full)                           | [mindspore.numpy.full](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.full.html#mindspore.numpy.full)                                      |                                                                                                                          |
| [torch.full_like](https://pytorch.org/docs/1.5.0/torch.html#torch.full_like)                 | [mindspore.numpy.full_like](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.full_like.html#mindspore.numpy.full_like)                       |                                                                                                                          |
| [torch.gather](https://pytorch.org/docs/1.5.0/torch.html#torch.gather)                       | [mindspore.ops.GatherD](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.GatherD.html#mindspore.ops.GatherD)                                     |                                                                                                                          |
| [torch.ge](https://pytorch.org/docs/1.5.0/torch.html#torch.ge)                               | [mindspore.ops.GreaterEqual](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.GreaterEqual.html#mindspore.ops.GreaterEqual)                      |                                                                                                                          |
| [torch.gt](https://pytorch.org/docs/1.5.0/torch.html#torch.gt)                               | [mindspore.ops.Greater](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Greater.html#mindspore.ops.Greater)                                     |                                                                                                                          |
| [torch.hamming_window](https://pytorch.org/docs/1.5.0/torch.html#torch.hamming_window)       | [mindspore.numpy.hamming](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.hamming.html#mindspore.numpy.hamming)                             |                                                                                                                          |
| [torch.hann_window](https://pytorch.org/docs/1.5.0/torch.html#torch.hann_window)             | [mindspore.numpy.hanning](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.hanning.html#mindspore.numpy.hanning)                             |                                                                                                                          |
| [torch.histc](https://pytorch.org/docs/1.5.0/torch.html#torch.histc)                         | [mindspore.ops.HistogramFixedWidth](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.HistogramFixedWidth.html#mindspore.ops.HistogramFixedWidth) |                                                                                                                          |
| [torch.imag](https://pytorch.org/docs/1.5.0/torch.html#torch.imag)                           | [mindspore.ops.Imag](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Imag.html#mindspore.ops.Imag)                                              |                                                                                                                          |
| [torch.isfinite](https://pytorch.org/docs/1.5.0/torch.html#torch.isfinite)                   | [mindspore.ops.IsFinite](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.IsFinite.html#mindspore.ops.IsFinite)                                  |                                                                                                                          |
| [torch.isinf](https://pytorch.org/docs/1.5.0/torch.html#torch.isinf)                         | [mindspore.ops.IsInf](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.IsInf.html#mindspore.ops.IsInf)                                           |                                                                                                                          |
| [torch.isnan](https://pytorch.org/docs/1.5.0/torch.html#torch.isnan)                         | [mindspore.ops.IsNan](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.IsNan.html#mindspore.ops.IsNan)                                           |                                                                                                                          |
| [torch.le](https://pytorch.org/docs/1.5.0/torch.html#torch.le)                               | [mindspore.ops.LessEqual](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.LessEqual.html#mindspore.ops.LessEqual)                               |                                                                                                                          |
| [torch.lerp](https://pytorch.org/docs/1.5.0/torch.html#torch.lerp)                           | [mindspore.ops.Lerp](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Lerp.html#mindspore.ops.Lerp)                                              |                                                                                                                          |
| [torch.linspace](https://pytorch.org/docs/1.5.0/torch.html#torch.linspace)                   | [mindspore.ops.LinSpace](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.LinSpace.html#mindspore.ops.LinSpace)                                  |                                                                                                                          |
| [torch.load](https://pytorch.org/docs/1.5.0/torch.html#torch.load)                           | [mindspore.load_checkpoint](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.load_checkpoint.html#mindspore-load-checkpoint)               |                                                                                                                          |
| [torch.log](https://pytorch.org/docs/1.5.0/torch.html#torch.log)                             | [mindspore.ops.Log](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Log.html#mindspore.ops.Log)                                                 |                                                                                                                          |
| [torch.log1p](https://pytorch.org/docs/1.5.0/torch.html#torch.log1p)                         | [mindspore.ops.Log1p](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Log1p.html#mindspore.ops.Log1p)                                           |                                                                                                                          |
| [torch.log2](https://pytorch.org/docs/1.5.0/torch.html#torch.log2)                           | [mindspore.numpy.log2](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.log2.html#mindspore.numpy.log2)                                      |                                                                                                                          |
| [torch.logical_and](https://pytorch.org/docs/1.5.0/torch.html#torch.logical_and)             | [mindspore.ops.LogicalAnd](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.LogicalAnd.html#mindspore.ops.LogicalAnd)                            | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/LogicalAnd.html)          |
| [torch.logical_not](https://pytorch.org/docs/1.5.0/torch.html#torch.logical_not)             | [mindspore.numpy.logical_not](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.logical_not.html#mindspore.numpy.logical_not)                 | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/logical_not.html)         |
| [torch.logical_or](https://pytorch.org/docs/1.5.0/torch.html#torch.logical_or)               | [mindspore.ops.LogicalOr](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.LogicalOr.html#mindspore.ops.LogicalOr)                               | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/LogicalOr.html)           |
| [torch.logical_xor](https://pytorch.org/docs/1.5.0/torch.html#torch.logical_xor)             | [mindspore.numpy.logical_xor](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.logical_xor.html#mindspore.numpy.logical_xor)                 | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/logical_xor.html)         |
| [torch.logspace](https://pytorch.org/docs/1.5.0/torch.html#torch.logspace)                   | [mindspore.numpy.logspace](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.logspace.html#mindspore.numpy.logspace)                          |                                                                                                                          |
| [torch.lt](https://pytorch.org/docs/1.5.0/torch.html#torch.lt)                               | [mindspore.ops.Less](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Less.html#mindspore.ops.Less)                                              |                                                                                                                          |
| [torch.matmul](https://pytorch.org/docs/1.5.0/torch.html#torch.matmul)                       | [mindspore.nn.MatMul](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.MatMul.html#mindspore.nn.MatMul)                                            |                                                                                                                          |
| [torch.matrix_power](https://pytorch.org/docs/1.5.0/torch.html#torch.matrix_power)           | [mindspore.numpy.matrix_power](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.matrix_power.html#mindspore.numpy.matrix_power)              |                                                                                                                          |
| [torch.matrix_rank](https://pytorch.org/docs/1.5.0/torch.html#torch.matrix_rank)             | [mindspore.ops.Rank](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Rank.html#mindspore.ops.Rank)                                              |                                                                                                                          |
| [torch.max](https://pytorch.org/docs/1.5.0/torch.html#torch.max)                             | [mindspore.ops.ArgMaxWithValue](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.ArgMaxWithValue.html#mindspore.ops.ArgMaxWithValue)             | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/ArgMaxWithValue.html)     |
| [torch.maximum](https://pytorch.org/docs/1.9.0/torch.html#torch.maximum)                     | [mindspore.ops.Maximum](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Maximum.html#mindspore.ops.Maximum)                                     |                                                                                                                          |
| [torch.mean](https://pytorch.org/docs/1.5.0/torch.html#torch.mean)                           | [mindspore.ops.ReduceMean](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.ReduceMean.html#mindspore.ops.ReduceMean)                            |                                                                                                                          |
| [torch.meshgrid](https://pytorch.org/docs/1.5.0/torch.html#torch.meshgrid)                   | [mindspore.ops.Meshgrid](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Meshgrid.html#mindspore.ops.Meshgrid)                                  |                                                                                                                          |
| [torch.min](https://pytorch.org/docs/1.5.0/torch.html#torch.min)                             | [mindspore.ops.ArgMinWithValue](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.ArgMinWithValue.html#mindspore.ops.ArgMinWithValue)             | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/ArgMinWithValue.html)     |
| [torch.mm](https://pytorch.org/docs/1.5.0/torch.html#torch.mm)                               | [mindspore.ops.MatMul](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.MatMul.html#mindspore.ops.MatMul)                                        |                                                                                                                          |
| [torch.mul](https://pytorch.org/docs/1.5.0/torch.html#torch.mul)                             | [mindspore.ops.Mul](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Mul.html#mindspore.ops.Mul)                                                 |                                                                                                                          |
| [torch.multinomial](https://pytorch.org/docs/1.5.0/torch.html#torch.multinomial)             | [mindspore.ops.multinomial](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.multinomial.html#mindspore.ops.multinomial)                         |                                                                                                                          |
| [torch.ne](https://pytorch.org/docs/1.5.0/torch.html#torch.ne)                               | [mindspore.ops.NotEqual](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.NotEqual.html#mindspore.ops.NotEqual)                                  |                                                                                                                          |
| [torch.neg](https://pytorch.org/docs/1.5.0/torch.html#torch.neg)                             | [mindspore.ops.Neg](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Neg.html#mindspore.ops.Neg)                                                 |                                                                                                                          |
| [torch.norm](https://pytorch.org/docs/1.5.0/torch.html#torch.norm)                           | [mindspore.ops.LpNorm](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.LpNorm.html#mindspore.ops.LpNorm)                                        | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/LpNorm.html)                |
| [torch.numel](https://pytorch.org/docs/1.5.0/torch.html#torch.numel)                         | [mindspore.ops.Size](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Size.html#mindspore.ops.Size)                                              |                                                                                                                          |
| [torch.ones](https://pytorch.org/docs/1.5.0/torch.html#torch.ones)                           | [mindspore.ops.Ones](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Ones.html#mindspore.ops.Ones)                                              |                                                                                                                          |
| [torch.ones_like](https://pytorch.org/docs/1.5.0/torch.html#torch.ones_like)                 | [mindspore.ops.OnesLike](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.OnesLike.html#mindspore.ops.OnesLike)                                  |                                                                                                                          |
| [torch.poisson](https://pytorch.org/docs/1.5.0/torch.html#torch.poisson)                     | [mindspore.ops.poisson](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.poisson.html#mindspore.ops.poisson)                                     |                                                                                                                          |
| [torch.pow](https://pytorch.org/docs/1.5.0/torch.html#torch.pow)                             | [mindspore.ops.Pow](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Pow.html#mindspore.ops.Pow)                                                 |                                                                                                                          |
| [torch.prod](https://pytorch.org/docs/1.5.0/torch.html#torch.prod)                           | [mindspore.ops.ReduceProd](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.ReduceProd.html#mindspore.ops.ReduceProd)                            |                                                                                                                          |
| [torch.promote_types](https://pytorch.org/docs/1.5.0/torch.html#torch.promote_types)         | [mindspore.numpy.promote_types](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.promote_types.html#mindspore.numpy.promote_types)           |                                                                                                                          |
| [torch.rand](https://pytorch.org/docs/1.5.0/torch.html#torch.rand)                           | [mindspore.ops.UniformReal](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.UniformReal.html#mindspore.ops.UniformReal)                         |                                                                                                                          |
| [torch.rand_like](https://pytorch.org/docs/1.5.0/torch.html#torch.rand_like)                 | [mindspore.ops.UniformReal](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.UniformReal.html#mindspore.ops.UniformReal)                         |                                                                                                                          |
| [torch.randint](https://pytorch.org/docs/1.5.0/torch.html#torch.randint)                     | [mindspore.ops.UniformInt](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.UniformInt.html#mindspore.ops.UniformInt)                            |                                                                                                                          |
| [torch.randint_like](https://pytorch.org/docs/1.5.0/torch.html#torch.randint_like)           | [mindspore.ops.UniformInt](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.UniformInt.html#mindspore.ops.UniformInt)                            |                                                                                                                          |
| [torch.randn](https://pytorch.org/docs/1.5.0/torch.html#torch.randn)                         | [mindspore.ops.StandardNormal](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.StandardNormal.html#mindspore.ops.StandardNormal)                |                                                                                                                          |
| [torch.randperm](https://pytorch.org/docs/1.5.0/torch.html#torch.randperm)                   | [mindspore.ops.Randperm](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Randperm.html#mindspore.ops.Randperm)                                  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/Randperm.html)            |
| [torch.range](https://pytorch.org/docs/1.5.0/torch.html#torch.range)                         | [mindspore.nn.Range](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Range.html#mindspore.nn.Range)                                               |                                                                                                                          |
| [torch.real](https://pytorch.org/docs/1.5.0/torch.html#torch.real)                           | [mindspore.ops.Real](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Real.html#mindspore.ops.Real)                                              |                                                                                                                          |
| [torch.reciprocal](https://pytorch.org/docs/1.5.0/torch.html#torch.reciprocal)               | [mindspore.ops.Reciprocal](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Reciprocal.html#mindspore.ops.Reciprocal)                            |                                                                                                                          |
| [torch.remainder](https://pytorch.org/docs/1.5.0/torch.html#torch.remainder)                 | [mindspore.numpy.remainder](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.remainder.html#mindspore.numpy.remainder)                       |                                                                                                                          |
| [torch.reshape](https://pytorch.org/docs/1.5.0/torch.html#torch.reshape)                     | [mindspore.ops.Reshape](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Reshape.html#mindspore.ops.Reshape)                                     |                                                                                                                          |
| [torch.result_type](https://pytorch.org/docs/1.5.0/torch.html#torch.result_type)             | [mindspore.numpy.result_type](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.result_type.html#mindspore.numpy.result_type)                 |                                                                                                                          |
| [torch.roll](https://pytorch.org/docs/1.5.0/torch.html#torch.roll)                           | [mindspore.nn.Roll](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Roll.html#mindspore.nn.Roll)                                                  |                                                                                                                          |
| [torch.rot90](https://pytorch.org/docs/1.5.0/torch.html#torch.rot90)                         | [mindspore.numpy.rot90](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.rot90.html#mindspore.numpy.rot90)                                   |                                                                                                                          |
| [torch.round](https://pytorch.org/docs/1.5.0/torch.html#torch.round)                         | [mindspore.ops.Rint](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Rint.html#mindspore.ops.Rint)                                              |                                                                                                                          |
| [torch.rsqrt](https://pytorch.org/docs/1.5.0/torch.html#torch.rsqrt)                         | [mindspore.ops.Rsqrt](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Rsqrt.html#mindspore.ops.Rsqrt)                                           |                                                                                                                          |
| [torch.save](https://pytorch.org/docs/1.5.0/torch.html#torch.save)                           | [mindspore.save_checkpoint](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.save_checkpoint.html#mindspore.save_checkpoint)                   |                                                                                                                          |
| [torch.sigmoid](https://pytorch.org/docs/1.5.0/torch.html#torch.sigmoid)                     | [mindspore.ops.Sigmoid](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Sigmoid.html#mindspore.ops.Sigmoid)                                     |                                                                                                                          |
| [torch.sin](https://pytorch.org/docs/1.5.0/torch.html#torch.sin)                             | [mindspore.ops.Sin](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Sin.html#mindspore.ops.Sin)                                                 |                                                                                                                          |
| [torch.sinh](https://pytorch.org/docs/1.5.0/torch.html#torch.sinh)                           | [mindspore.ops.Sinh](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Sinh.html#mindspore.ops.Sinh)                                              |                                                                                                                          |
| [torch.sort](https://pytorch.org/docs/1.5.0/torch.html#torch.sort)                           | [mindspore.ops.Sort](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Sort.html#mindspore.ops.Sort)                                              |                                                                                                                          |
| [torch.sparse_coo_tensor](https://pytorch.org/docs/1.5.0/torch.html#torch.sparse_coo_tensor) | [mindspore.SparseTensor](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.SparseTensor.html#mindspore.SparseTensor)                            | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/SparseTensor.html)        |
| [torch.split](https://pytorch.org/docs/1.5.0/torch.html#torch.split)                         | [mindspore.ops.Split](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Split.html#mindspore.ops.Split)                                           |                                                                                                                          |
| [torch.sqrt](https://pytorch.org/docs/1.5.0/torch.html#torch.sqrt)                           | [mindspore.ops.Sqrt](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Sqrt.html#mindspore.ops.Sqrt)                                              |                                                                                                                          |
| [torch.square](https://pytorch.org/docs/1.5.0/torch.html#torch.square)                       | [mindspore.ops.Square](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Square.html#mindspore.ops.Square)                                        |                                                                                                                          |
| [torch.squeeze](https://pytorch.org/docs/1.5.0/torch.html#torch.squeeze)                     | [mindspore.ops.Squeeze](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Squeeze.html#mindspore.ops.Squeeze)                                     |                                                                                                                          |
| [torch.stack](https://pytorch.org/docs/1.5.0/torch.html#torch.stack)                         | [mindspore.ops.Stack](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Stack.html#mindspore.ops.Stack)                                           |                                                                                                                          |
| [torch.std](https://pytorch.org/docs/1.5.0/torch.html#torch.std)                             | [mindspore.Tensor.std](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.std)                                      |                                                                                                                          |
| [torch.std_mean](https://pytorch.org/docs/1.5.0/torch.html#torch.std_mean)                   | [mindspore.ops.ReduceMean](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.ReduceMean.html#mindspore.ops.ReduceMean)                            | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/ReduceMean&std_mean.html) |
| [torch.sum](https://pytorch.org/docs/1.5.0/torch.html#torch.sum)                             | [mindspore.ops.ReduceSum](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.ReduceSum.html#mindspore.ops.ReduceSum)                               |                                                                                                                          |
| [torch.take](https://pytorch.org/docs/1.5.0/torch.html#torch.take)                           | [mindspore.Tensor.take](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.take)                                    |                                                                                                                          |
| [torch.tan](https://pytorch.org/docs/1.5.0/torch.html#torch.tan)                             | [mindspore.ops.Tan](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Tan.html#mindspore.ops.Tan)                                                 |                                                                                                                          |
| [torch.tanh](https://pytorch.org/docs/1.5.0/torch.html#torch.tanh)                           | [mindspore.ops.Tanh](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Tanh.html#mindspore.ops.Tanh)                                              |                                                                                                                          |
| [torch.tensor](https://pytorch.org/docs/1.5.0/torch.html#torch.tensor)                       | [mindspore.Tensor](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor)                                              |                                                                                                                          |
| [torch.Tensor](https://pytorch.org/docs/1.5.0/torch.html#torch.Tensor)                       | [mindspore.Tensor](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor)                                              |                                                                                                                          |
| [torch.tensordot](https://pytorch.org/docs/1.5.0/torch.html#torch.tensordot)                 | [mindspore.numpy.tensordot](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.tensordot.html)                             |                                                                                                                          |
| [torch.topk](https://pytorch.org/docs/1.5.0/torch.html#torch.topk)                           | [mindspore.ops.TopK](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.TopK.html#mindspore.ops.TopK)                                              | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/TopK.html)                |
| [torch.trace](https://pytorch.org/docs/1.5.0/torch.html#torch.trace)                         | [mindspore.Tensor.trace](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.trace)                                  |                                                                                                                          |
| [torch.transpose](https://pytorch.org/docs/1.5.0/torch.html#torch.transpose)                 | [mindspore.ops.Transpose](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Transpose.html#mindspore.ops.Transpose)                               |                                                                                                                          |
| [torch.trapz](https://pytorch.org/docs/1.5.0/torch.html#torch.trapz)                         | [mindspore.numpy.trapz](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.trapz.html#mindspore.numpy.trapz)                                   |                                                                                                                          |
| [torch.tril](https://pytorch.org/docs/1.5.0/torch.html#torch.tril)                           | [mindspore.nn.Tril](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Tril.html#mindspore.nn.Tril)                                                  |                                                                                                                          |
| [torch.tril_indices](https://pytorch.org/docs/1.5.0/torch.html#torch.tril_indices)           | [mindspore.numpy.tril_indices](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.tril_indices.html#mindspore.numpy.tril_indices)              |                                                                                                                          |
| [torch.triu](https://pytorch.org/docs/1.5.0/torch.html#torch.triu)                           | [mindspore.nn.Triu](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Triu.html#mindspore.nn.Triu)                                                  |                                                                                                                          |
| [torch.triu_indices](https://pytorch.org/docs/1.5.0/torch.html#torch.triu_indices)           | [mindspore.numpy.triu_indices](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.triu_indices.html#mindspore.numpy.triu_indices)              |                                                                                                                          |
| [torch.true_divide](https://pytorch.org/docs/1.5.0/torch.html#torch.true_divide)             | [mindspore.numpy.true_divide](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.true_divide.html#mindspore.numpy.true_divide)                 |                                                                                                                          |
| [torch.trunc](https://pytorch.org/docs/1.5.0/torch.html#torch.trunc)                         | [mindspore.numpy.trunc](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.trunc.html#mindspore.numpy.trunc)                                   |                                                                                                                          |
| [torch.unbind](https://pytorch.org/docs/1.5.0/torch.html#torch.unbind)                       | [mindspore.ops.Unstack](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Unstack.html#mindspore.ops.Unstack)                                     |                                                                                                                          |
| [torch.unique](https://pytorch.org/docs/1.5.0/torch.html#torch.unique)                       | [mindspore.ops.Unique](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Unique.html#mindspore.ops.Unique)                                        | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/Unique.html)              |
| [torch.unsqueeze](https://pytorch.org/docs/1.5.0/torch.html#torch.unsqueeze)                 | [mindspore.ops.ExpandDims](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.ExpandDims.html#mindspore.ops.ExpandDims)                            |                                                                                                                          |
| [torch.var](https://pytorch.org/docs/1.5.0/torch.html#torch.var)                             | [mindspore.Tensor.var](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.var)                                      |                                                                                                                          |
| [torch.where](https://pytorch.org/docs/1.5.0/torch.html#torch.where)                         | [mindspore.numpy.where](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.where.html#mindspore.numpy.where)                                   |                                                                                                                          |
| [torch.zeros](https://pytorch.org/docs/1.5.0/torch.html#torch.zeros)                         | [mindspore.ops.Zeros](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Zeros.html#mindspore.ops.Zeros)                                           |                                                                                                                          |
| [torch.zeros_like](https://pytorch.org/docs/1.5.0/torch.html#torch.zeros_like)               | [mindspore.ops.ZerosLike](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.ZerosLike.html#mindspore.ops.ZerosLike)                               |                                                                                                                          |

## torch.autograd

| PyTorch 1.5.0 APIs                                                                                    | MindSpore APIs                                                                                                                                        | 说明                                                                                                               |
| ----------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------ |
| [torch.autograd.backward](https://pytorch.org/docs/1.5.0/autograd.html#torch.autograd.backward)       | [mindspore.ops.GradOperation](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.GradOperation.html#mindspore.ops.GradOperation) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/GradOperation.html) |
| [torch.autograd.enable_grad](https://pytorch.org/docs/1.5.0/autograd.html#torch.autograd.enable_grad) | [mindspore.ops.stop_gradient](https://www.mindspore.cn/tutorials/zh-CN/r1.7/beginner/autograd.html#停止计算梯度)   | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/stop_gradient.html) |
| [torch.autograd.grad](https://pytorch.org/docs/1.5.0/autograd.html#torch.autograd.grad)               | [mindspore.ops.GradOperation](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.GradOperation.html#mindspore.ops.GradOperation) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/GradOperation.html) |
| [torch.autograd.no_grad](https://pytorch.org/docs/1.5.0/autograd.html#torch.autograd.no_grad)         | [mindspore.ops.stop_gradient](https://www.mindspore.cn/tutorials/zh-CN/r1.7/beginner/autograd.html#停止计算梯度)   | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/stop_gradient.html) |
| [torch.autograd.variable](https://pytorch.org/docs/1.5.0/autograd.html#torch.autograd.variable-deprecated)| [mindspore.Parameter](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Parameter.html#mindspore.Parameter)                  |                                                                                                                    |

## torch.cuda

| PyTorch 1.5.0 APIs                                                                          | MindSpore APIs                                                                                                                                                      | 说明                                                                                                             |
| ------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- |
| [torch.cuda.device_count](https://pytorch.org/docs/1.5.0/cuda.html#torch.cuda.device_count) | [mindspore.communication.get_group_size](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.communication.html#mindspore.communication.get_group_size) |                                                                                                                  |
| [torch.cuda.set_device](https://pytorch.org/docs/1.5.0/cuda.html#torch.cuda.set_device)     | [mindspore.context.set_context](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.context.html#mindspore.context.set_context)                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/set_context.html) |

## torch.distributed

| PyTorch 1.5.0 APIs                                                                                                           | MindSpore APIs                                                                                                                                                  | 说明                                                                                                              |
| ---------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------- |
| [torch.distributed.all_gather](https://pytorch.org/docs/1.5.0/distributed.html#torch.distributed.all_gather)                 | [mindspore.ops.AllGather](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.AllGather.html#mindspore.ops.AllGather)                       |                                                                                                                   |
| [torch.distributed.all_reduce](https://pytorch.org/docs/1.5.0/distributed.html#torch.distributed.all_reduce)                 | [mindspore.ops.AllReduce](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.AllReduce.html#mindspore.ops.AllReduce)                       |                                                                                                                   |
| [torch.distributed.get_rank](https://pytorch.org/docs/1.5.0/distributed.html#torch.distributed.get_rank)                     | [mindspore.communication.get_rank](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.communication.html#mindspore.communication.get_rank)         |                                                                                                                   |
| [torch.distributed.init_process_group](https://pytorch.org/docs/1.5.0/distributed.html#torch.distributed.init_process_group) | [mindspore.communication.init](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.communication.html#mindspore.communication.init)                 | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/init.html)         |
| [torch.distributed.new_group](https://pytorch.org/docs/1.5.0/distributed.html#torch.distributed.new_group)                   | [mindspore.communication.create_group](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.communication.html#mindspore.communication.create_group) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/create_group.html) |

## torch.distributions

| PyTorch 1.5.0 APIs                                                                                                   | MindSpore APIs                                                                                                                | 说明 |
| -------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------- | ---- |
| [torch.distributions.gamma.Gamma](https://pytorch.org/docs/1.5.0/distributions.html#torch.distributions.gamma.Gamma) | [mindspore.ops.Gamma](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Gamma.html#mindspore.ops.Gamma) |      |

## torch.nn

| PyTorch 1.5.0 APIs                                                                                                                       | MindSpore APIs                                                                                                                                                                                    | 说明                                                                                                                   |
| ---------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------- |
| [torch.nn.AdaptiveAvgPool2d](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.AdaptiveAvgPool2d)                                          | [mindspore.ops.AdaptiveAvgPool2D](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.AdaptiveAvgPool2D.html#mindspore.ops.AdaptiveAvgPool2D)                                 |                                                                                                                        |
| [torch.nn.AvgPool1d](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.AvgPool1d)                                                          | [mindspore.nn.AvgPool1d](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.AvgPool1d.html#mindspore.nn.AvgPool1d)                                                             |                                                                                                                        |
| [torch.nn.AvgPool2d](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.AvgPool2d)                                                          | [mindspore.nn.AvgPool2d](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.AvgPool2d.html#mindspore.nn.AvgPool2d)                                                             |                                                                                                                        |
| [torch.nn.BatchNorm1d](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.BatchNorm1d)                                                      | [mindspore.nn.BatchNorm1d](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.BatchNorm1d.html#mindspore.nn.BatchNorm1d)                                                       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/BatchNorm1d.html)       |
| [torch.nn.BatchNorm2d](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.BatchNorm2d)                                                      | [mindspore.nn.BatchNorm2d](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.BatchNorm2d.html#mindspore.nn.BatchNorm2d)                                                       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/BatchNorm2d.html)       |
| [torch.nn.BCEWithLogitsLoss](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.BCEWithLogitsLoss)                                          | [mindspore.nn.BCEWithLogitsLoss](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.BCEWithLogitsLoss.html#mindspore.nn.BCEWithLogitsLoss)                                     |                                                                                                                        |
| [torch.nn.Conv1d](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Conv1d)                                                                | [mindspore.nn.Conv1d](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Conv1d.html#mindspore.nn.Conv1d)                                                                      |                                                                                                                        |
| [torch.nn.Conv2d](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Conv2d)                                                                | [mindspore.nn.Conv2d](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Conv2d.html#mindspore.nn.Conv2d)                                                                      | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/nn_Conv2d.html)         |
| [torch.nn.Conv3d](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Conv3d)                                                                | [mindspore.nn.Conv3d](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Conv3d.html#mindspore.nn.Conv3d)                                                                      |                                                                                                                        |
| [torch.nn.ConvTranspose1d](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.ConvTranspose1d)                                              | [mindspore.nn.Conv1dTranspose](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Conv1dTranspose.html#mindspore.nn.Conv1dTranspose)                                           |                                                                                                                        |
| [torch.nn.ConvTranspose2d](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.ConvTranspose2d)                                              | [mindspore.nn.Conv2dTranspose](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Conv2dTranspose.html#mindspore.nn.Conv2dTranspose)                                           |                                                                                                                        |
| [torch.nn.ConvTranspose3d](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.ConvTranspose3d)                                              | [mindspore.nn.Conv3dTranspose](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Conv3dTranspose.html#mindspore.nn.Conv3dTranspose)                                           |                                                                                                                        |
| [torch.nn.CrossEntropyLoss](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.CrossEntropyLoss)                                            | [mindspore.nn.SoftmaxCrossEntropyWithLogits](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.SoftmaxCrossEntropyWithLogits.html#mindspore.nn.SoftmaxCrossEntropyWithLogits) |                                                                                                                        |
| [torch.nn.CTCLoss](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.CTCLoss)                                                              | [mindspore.ops.CTCLoss](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.CTCLoss.html#mindspore.ops.CTCLoss)                                                               |                                                                                                                        |
| [torch.nn.Dropout](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Dropout)                                                              | [mindspore.nn.Dropout](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Dropout.html#mindspore.nn.Dropout)                                                                   |                                                                                                                        |
| [torch.nn.Embedding](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Embedding)                                                          | [mindspore.nn.Embedding](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Embedding.html#mindspore.nn.Embedding)                                                             | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/nn_Embedding.html)      |
| [torch.nn.Flatten](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Flatten)                                                              | [mindspore.nn.Flatten](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Flatten.html#mindspore.nn.Flatten)                                                                   | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/nn_Flatten.html)        |
| [torch.nn.GELU](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.GELU)                                                                    | [mindspore.nn.GELU](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.GELU.html#mindspore.nn.GELU)                                                                            |                                                                                                                        |
| [torch.nn.GELU](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.GELU)                                                                    | [mindspore.nn.FastGelu](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.FastGelu.html#mindspore.nn.FastGelu)                                                                | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/FastGelu.html)          |
| [torch.nn.GroupNorm](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.GroupNorm)                                                          | [mindspore.nn.GroupNorm](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.GroupNorm.html#mindspore.nn.GroupNorm)                                                             |                                                                                                                        |
| [torch.nn.GRU](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.GRU)                                                                      | [mindspore.nn.GRU](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.GRU.html#mindspore.nn.GRU)                                                                               |                                                                                                                        |
| [torch.nn.Hardshrink](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Hardshrink)                                                        | [mindspore.nn.HShrink](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.HShrink.html#mindspore.nn.HShrink)                                                                   |                                                                                                                        |
| [torch.nn.KLDivLoss](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.KLDivLoss)                                                          | [mindspore.ops.KLDivLoss](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.KLDivLoss.html#mindspore.ops.KLDivLoss)                                                         |                                                                                                                        |
| [torch.nn.L1Loss](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.L1Loss)                                                                | [mindspore.nn.L1Loss](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.L1Loss.html#mindspore.nn.L1Loss)                                                                      |                                                                                                                        |
| [torch.nn.LayerNorm](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.LayerNorm)                                                          | [mindspore.nn.LayerNorm](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.LayerNorm.html#mindspore.nn.LayerNorm)                                                             |                                                                                                                        |
| [torch.nn.LeakyReLU](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.LeakyReLU)                                                          | [mindspore.nn.LeakyReLU](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.LeakyReLU.html#mindspore.nn.LeakyReLU)                                                             |                                                                                                                        |
| [torch.nn.Linear](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Linear)                                                                | [mindspore.nn.Dense](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Dense.html#mindspore.nn.Dense)                                                                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/Dense.html)             |
| [torch.nn.LSTM](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.LSTM)                                                                    | [mindspore.nn.LSTM](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.LSTM.html#mindspore.nn.LSTM)                                                                            |                                                                                                                        |
| [torch.nn.LSTMCell](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.LSTMCell)                                                            | [mindspore.nn.LSTMCell](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.LSTMCell.html#mindspore.nn.LSTMCell)                                                                |                                                                                                                        |
| [torch.nn.MaxPool1d](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.MaxPool1d)                                                          | [mindspore.nn.MaxPool1d](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.MaxPool1d.html#mindspore.nn.MaxPool1d)                                                             | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/MaxPool1d.html)           |
| [torch.nn.MaxPool2d](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.MaxPool2d)                                                          | [mindspore.nn.MaxPool2d](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.MaxPool2d.html#mindspore.nn.MaxPool2d)                                                             | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/MaxPool2d.html)           |
| [torch.nn.MultiheadAttention](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.MultiheadAttention)                                                          | [mindspore.nn.transformer.MultiHeadAttention](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.nn.transformer.html#mindspore.nn.transformer.MultiHeadAttention)                                                             | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/MultiHeadAttention.html)
| [torch.nn.Module](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Module)                                                                | [mindspore.nn.Cell](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Cell.html#mindspore.nn.Cell)                                                                            |                                                                                                                        |
| [torch.nn.Module.add_module](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Module.add_module)                                          | [mindspore.nn.Cell.insert_child_to_cell](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Cell.html#mindspore.nn.Cell.insert_child_to_cell)                                  |                                                                                                                        |
| [torch.nn.Module.buffers](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Module.buffers)                                                | [mindspore.nn.Cell.untrainable_params](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Cell.html#mindspore.nn.Cell.untrainable_params)                                      | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/UnTrainableParams.html) |
| [torch.nn.Module.children](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Module.children)                                              | [mindspore.nn.Cell.cells](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Cell.html#mindspore.nn.Cell.cells)                                                                | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/Cells.html)             |
| [torch.nn.Module.load_state_dict](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Module.load_state_dict)                                | [mindspore.load_param_into_net](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.load_param_into_net.html#mindspore.load_param_into_net)                                 |                                                                                                                        |
| [torch.nn.Module.named_children](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Module.named_children)                                  | [mindspore.nn.Cell.name_cells](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Cell.html#mindspore.nn.Cell.name_cells)                                                      | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/NameCells.html)         |
| [torch.nn.Module.named_modules](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Module.named_modules)                                    | [mindspore.nn.Cell.cells_and_names](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Cell.html#mindspore.nn.Cell.cells_and_names)                                            |                                                                                                                        |
| [torch.nn.Module.parameters](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Module.parameters)                                          | [mindspore.nn.Cell.get_parameters](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Cell.html#mindspore.nn.Cell.get_parameters)                                              | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/GetParams.html)         |
| [torch.nn.Module.state_dict](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Module.state_dict)                                          | [mindspore.nn.Cell.parameters_dict](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Cell.html#mindspore.nn.Cell.parameters_dict)                                            |                                                                                                                        |
| [torch.nn.Module.train](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Module.train)                                                    | [mindspore.nn.Cell.set_train](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Cell.html#mindspore.nn.Cell.set_train)                                                        |                                                                                                                        |
| [torch.nn.ModuleList](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.ModuleList)                                                        | [mindspore.nn.CellList](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.CellList.html#mindspore.nn.CellList)                                                                |                                                                                                                        |
| [torch.nn.MSELoss](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.MSELoss)                                                              | [mindspore.nn.MSELoss](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.MSELoss.html#mindspore.nn.MSELoss)                                                                   |                                                                                                                        |
| [torch.nn.Parameter](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Parameter)                                                          | [mindspore.Parameter](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Parameter.html#mindspore.Parameter)                                                               |                                                                                                                        |
| [torch.nn.ParameterList](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.ParameterList)                                                  | [mindspore.ParameterTuple](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.ParameterTuple.html#mindspore.ParameterTuple)                                                | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/ParameterTuple.html)    |
| [torch.nn.PixelShuffle](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.PixelShuffle)                                                    | [mindspore.ops.DepthToSpace](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.DepthToSpace.html#mindspore.ops.DepthToSpace)                                                |                                                                                                                        |
| [torch.nn.PReLU](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.PReLU)                                                                  | [mindspore.nn.PReLU](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.PReLU.html#mindspore.nn.PReLU)                                                                         |                                                                                                                        |
| [torch.nn.ReLU](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.ReLU)                                                                    | [mindspore.nn.ReLU](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.ReLU.html#mindspore.nn.ReLU)                                                                            |                                                                                                                        |
| [torch.nn.ReplicationPad2d](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.ReplicationPad2d)                                            | [mindspore.nn.Pad](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Pad.html#mindspore.nn.Pad)                                                                               |                                                                                                                        |
| [torch.nn.SELU](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.SELU)                                                                    | [mindspore.ops.SeLU](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.SeLU.html#mindspore.ops.SeLU)                                                                        |                                                                                                                        |
| [torch.nn.Sequential](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Sequential)                                                        | [mindspore.nn.SequentialCell](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.SequentialCell.html#mindspore.nn.SequentialCell)                                              |                                                                                                                        |
| [torch.nn.Sigmoid](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Sigmoid)                                                              | [mindspore.nn.Sigmoid](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Sigmoid.html#mindspore.nn.Sigmoid)                                                                   |                                                                                                                        |
| [torch.nn.SmoothL1Loss](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.SmoothL1Loss)                                                    | [mindspore.nn.SmoothL1Loss](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.SmoothL1Loss.html#mindspore.nn.SmoothL1Loss)                                                    |                                                                                                                        |
| [torch.nn.Softmax](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Softmax)                                                              | [mindspore.nn.Softmax](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Softmax.html#mindspore.nn.Softmax)                                                                   |                                                                                                                        |
| [torch.nn.Softshrink](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Softshrink)                                                        | [mindspore.nn.SoftShrink](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.SoftShrink.html#mindspore.nn.SoftShrink)                                                          |                                                                                                                        |
| [torch.nn.SyncBatchNorm.convert_sync_batchnorm](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.SyncBatchNorm.convert_sync_batchnorm)    | [mindspore.nn.GlobalBatchNorm](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.GlobalBatchNorm.html#mindspore.nn.GlobalBatchNorm)                                           |                                                                                                                        |
| [torch.nn.Tanh](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Tanh)                                                                    | [mindspore.nn.Tanh](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Tanh.html#mindspore.nn.Tanh)                                                                            |                                                                                                                        |
| [torch.nn.Transformer](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Transformer)       | [mindspore.nn.transformer.Transformer](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.nn.transformer.html#mindspore.nn.transformer.Transformer) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/Transformer.html)
| [torch.nn.TransformerEncoder](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.TransformerEncoder)       | [mindspore.nn.transformer.TransformerEncoder](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.nn.transformer.html#mindspore.nn.transformer.TransformerEncoder) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/TransformerEncoder.html)
| [torch.nn.TransformerDecoder](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.TransformerDecoder)       | [mindspore.nn.transformer.TransformerDecoder](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.nn.transformer.html#mindspore.nn.transformer.TransformerDecoder) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/TransformerDecoder.html)
| [torch.nn.TransformerEncoderLayer](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.TransformerEncoderLayer)       | [mindspore.nn.transformer.TransformerEncoderLayer](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.nn.transformer.html#mindspore.nn.transformer.TransformerEncoderLayer) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/TransformerEncoderLayer.html)
| [torch.nn.TransformerDecoderLayer](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.TransformerDecoderLayer)       | [mindspore.nn.transformer.TransformerDecoderLayer](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.nn.transformer.html#mindspore.nn.transformer.TransformerDecoderLayer) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/TransformerDecoderLayer.html)
| [torch.nn.Unfold](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Unfold)                                                                | [mindspore.nn.Unfold](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Unfold.html#mindspore.nn.Unfold)                                                                      | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/Unfold.html)            |
| [torch.nn.Upsample](https://pytorch.org/docs/1.5.0/nn.html#torch.nn.Upsample)                                                            | [mindspore.nn.ResizeBilinear](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.ResizeBilinear.html#mindspore.nn.ResizeBilinear)                                              | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/ResizeBilinear.html)    |

## torch.nn.functional

| PyTorch 1.5.0 APIs                                                                                                                       | MindSpore APIs                                                                                                                                                                                    | 说明                                                                                                                   |
| ---------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------- |
| [torch.nn.functional.adaptive_avg_pool2d](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.adaptive_avg_pool2d)     | [mindspore.ops.AdaptiveAvgPool2D](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.AdaptiveAvgPool2D.html#mindspore.ops.AdaptiveAvgPool2D)                                 |                                                                                                                        |
| [torch.nn.functional.avg_pool1d](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.avg_pool1d)                       | [mindspore.nn.AvgPool1d](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.AvgPool1d.html#mindspore.nn.AvgPool1d)                                                             |                                                                                                                        |
| [torch.nn.functional.avg_pool2d](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.avg_pool2d)                       | [mindspore.ops.AvgPool](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.AvgPool.html#mindspore.ops.AvgPool)                                                               |                                                                                                                        |
| [torch.nn.functional.avg_pool3d](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.avg_pool3d)                       | [mindspore.ops.AvgPool3D](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.AvgPool3D.html#mindspore.ops.AvgPool3D)                                                         |                                                                                                                        |
| [torch.nn.functional.batch_norm](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.batch_norm)                       | [mindspore.ops.BatchNorm](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.BatchNorm.html#mindspore.ops.BatchNorm)                                                         |                                                                                                                        |
| [torch.nn.functional.binary_cross_entropy](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.binary_cross_entropy)   | [mindspore.ops.BinaryCrossEntropy](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.BinaryCrossEntropy.html#mindspore.ops.BinaryCrossEntropy)                              |                                                                                                                        |
| [torch.nn.functional.conv2d](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.conv2d)                               | [mindspore.ops.Conv2D](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Conv2D.html#mindspore.ops.Conv2D)                                                                  |                                                                                                                        |
| [torch.nn.functional.cosine_embedding_loss](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.cosine_embedding_loss) | [mindspore.nn.CosineEmbeddingLoss](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.CosineEmbeddingLoss.html#mindspore.nn.CosineEmbeddingLoss)                               |                                                                                                                        |
| [torch.nn.functional.ctc_loss](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.ctc_loss)                           | [mindspore.ops.CTCLoss](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.CTCLoss.html#mindspore.ops.CTCLoss)                                                               |                                                                                                                        |
| [torch.nn.functional.elu](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.elu)                                     | [mindspore.ops.Elu](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Elu.html#mindspore.ops.Elu)                                                                           |                                                                                                                        |
| [torch.nn.functional.kl_div](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.kl_div)                               | [mindspore.ops.KLDivLoss](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.KLDivLoss.html#mindspore.ops.KLDivLoss)                                                         |                                                                                                                        |
| [torch.nn.functional.l1_loss](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.l1_loss)                             | [mindspore.nn.L1Loss](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.L1Loss.html#mindspore.nn.L1Loss)                                                                      |                                                                                                                        |
| [torch.nn.functional.layer_norm](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.layer_norm)                       | [mindspore.ops.LayerNorm](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.LayerNorm.html#mindspore.ops.LayerNorm)                                                         |                                                                                                                        |
| [torch.nn.functional.leaky_relu](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.leaky_relu)                       | [mindspore.nn.LeakyReLU](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.LeakyReLU.html#mindspore.nn.LeakyReLU)                                                             |                                                                                                                        |
| [torch.nn.functional.log_softmax](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.log_softmax)                     | [mindspore.nn.LogSoftmax](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.LogSoftmax.html#mindspore.nn.LogSoftmax)                                                          |                                                                                                                        |
| [torch.nn.functional.max_pool1d](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.max_pool1d)                       | [mindspore.nn.MaxPool1d](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.MaxPool1d.html#mindspore.nn.MaxPool1d)                                                             | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/MaxPool1d.html)           |
| [torch.nn.functional.max_pool2d](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.max_pool2d)                       | [mindspore.nn.MaxPool2d](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.MaxPool2d.html#mindspore.nn.MaxPool2d)                                                             | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/MaxPool2d.html)           |
| [torch.nn.functional.max_pool3d](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.max_pool3d)                       | [mindspore.ops.MaxPool3D](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.MaxPool3D.html#mindspore.ops.MaxPool3D)                                                         | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/MaxPool3D.html)         |
| [torch.nn.functional.mse_loss](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.mse_loss)                           | [mindspore.nn.MSELoss](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.MSELoss.html#mindspore.nn.MSELoss)                                                                   |                                                                                                                        |
| [torch.nn.functional.nll_loss](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.nll_loss)                           | [mindspore.ops.NLLLoss](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.NLLLoss.html#mindspore.ops.NLLLoss)                                                               | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/NLLLoss.html)           |
| [torch.nn.functional.normalize](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.normalize)                         | [mindspore.ops.L2Normalize](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.L2Normalize.html#mindspore.ops.L2Normalize)                                                   | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/L2Normalize.html)       |
| [torch.nn.functional.one_hot](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.one_hot)                             | [mindspore.ops.OneHot](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.OneHot.html#mindspore.ops.OneHot)                                                                  |                                                                                                                        |
| [torch.nn.functional.pad](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.pad)                                     | [mindspore.nn.Pad](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Pad.html#mindspore.nn.Pad)                                                                               | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/Pad.html)               |
| [torch.nn.functional.pixel_shuffle](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.pixel_shuffle)                 | [mindspore.ops.DepthToSpace](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.DepthToSpace.html#mindspore.ops.DepthToSpace)                                                |                                                                                                                        |
| [torch.nn.functional.relu](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.relu)                                   | [mindspore.ops.ReLU](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.ReLU.html#mindspore.ops.ReLU)                                                                        |                                                                                                                        |
| [torch.nn.functional.smooth_l1_loss](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.smooth_l1_loss)               | [mindspore.nn.SmoothL1Loss](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.SmoothL1Loss.html#mindspore.nn.SmoothL1Loss)                                                    |                                                                                                                        |
| [torch.nn.functional.soft_margin_loss](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.soft_margin_loss)           | [mindspore.nn.SoftMarginLoss](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.SoftMarginLoss.html#mindspore.nn.SoftMarginLoss)                                              |                                                                                                                        |
| [torch.nn.functional.softmax](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.softmax)                             | [mindspore.ops.Softmax](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Softmax.html#mindspore.ops.Softmax)                                                               | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/Softmax.html)           |
| [torch.nn.functional.softplus](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.softplus)                           | [mindspore.ops.Softplus](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Softplus.html#mindspore.ops.Softplus)                                                            |                                                                                                                        |
| [torch.nn.functional.softsign](https://pytorch.org/docs/1.5.0/nn.functional.html#torch.nn.functional.softsign)                           | [mindspore.ops.Softsign](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Softsign.html#mindspore.ops.Softsign)                                                            |                                                                                                                        |

## torch.nn.init

| PyTorch 1.5.0 APIs                                                                                                                       | MindSpore APIs                                                                                                                                                                                    | 说明                                                                                                                   |
| ---------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------- |
| [torch.nn.init.constant_](https://pytorch.org/docs/1.5.0/nn.init.html#torch.nn.init.constant_)                                           | [mindspore.common.initializer.Constant](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.common.initializer.html#mindspore.common.initializer.Constant)                            | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/Constant.html)          |
| [torch.nn.init.kaiming_normal_](https://pytorch.org/docs/1.5.0/nn.init.html#torch.nn.init.kaiming_normal_)                               | [mindspore.common.initializer.HeNormal](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.common.initializer.html#mindspore.common.initializer.HeNormal)                            |                                                                                                                        |
| [torch.nn.init.kaiming_uniform_](https://pytorch.org/docs/1.5.0/nn.init.html#torch.nn.init.kaiming_uniform_)                             | [mindspore.common.initializer.HeUniform](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.common.initializer.html#mindspore.common.initializer.HeUniform)                          |                                                                                                                        |
| [torch.nn.init.normal_](https://pytorch.org/docs/1.5.0/nn.init.html#torch.nn.init.normal_)                                               | [mindspore.common.initializer.Normal](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.common.initializer.html#mindspore.common.initializer.Normal)                                | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/InitNormal.html)        |
| [torch.nn.init.ones_](https://pytorch.org/docs/1.5.0/nn.init.html#torch.nn.init.ones_)                                                   | [mindspore.common.initializer.One](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.common.initializer.html#mindspore.common.initializer.One)                                      |                                                                                                                        |
| [torch.nn.init.xavier_uniform_](https://pytorch.org/docs/1.5.0/nn.init.html#torch.nn.init.xavier_uniform_)                               | [mindspore.common.initializer.XavierUniform](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.common.initializer.html#mindspore.common.initializer.XavierUniform)                  |                                                                                                                        |
| [torch.nn.init.zeros_](https://pytorch.org/docs/1.5.0/nn.init.html#torch.nn.init.zeros_)                                                 | [mindspore.common.initializer.Zero](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.common.initializer.html#mindspore.common.initializer.Zero)                                    |                                                                                                                        |
| [torch.nn.init.uniform_](https://pytorch.org/docs/1.5.0/nn.init.html#torch.nn.init.uniform_)                                             | [mindspore.common.initializer.Uniform](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.common.initializer.html#mindspore.common.initializer.Uniform)                              | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/Uniform.html)           |

## torch.optim

| PyTorch 1.5.0 APIs                                                                                                                                     | MindSpore APIs                                                                                                                                                            | 说明                                                                                                                     |
| ------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------ |
| [torch.optim.Adadelta](https://pytorch.org/docs/1.5.0/optim.html#torch.optim.Adadelta)                                                                 | [mindspore.ops.ApplyAdadelta](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.ApplyAdadelta.html#mindspore.ops.ApplyAdadelta)                     | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/ApplyAdadelta.html)       |
| [torch.optim.Adagrad](https://pytorch.org/docs/1.5.0/optim.html#torch.optim.Adagrad)                                                                   | [mindspore.nn.Adagrad](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Adagrad.html#mindspore.nn.Adagrad)                                           | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/Adagrad.html)             |
| [torch.optim.Adam](https://pytorch.org/docs/1.5.0/optim.html#torch.optim.Adam)                                                                         | [mindspore.nn.Adam](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Adam.html#mindspore.nn.Adam)                                                    |                                                                                                                          |
| [torch.optim.Adamax](https://pytorch.org/docs/1.5.0/optim.html#torch.optim.Adamax)                                                                     | [mindspore.ops.ApplyAdaMax](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.ApplyAdaMax.html#mindspore.ops.ApplyAdaMax)                           |                                                                                                                          |
| [torch.optim.AdamW](https://pytorch.org/docs/1.5.0/optim.html#torch.optim.AdamW)                                                                       | [mindspore.nn.AdamWeightDecay](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.AdamWeightDecay.html#mindspore.nn.AdamWeightDecay)                   |                                                                                                                          |
| [torch.optim.lr_scheduler.CosineAnnealingWarmRestarts](https://pytorch.org/docs/1.5.0/optim.html#torch.optim.lr_scheduler.CosineAnnealingWarmRestarts) | [mindspore.nn.cosine_decay_lr](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.cosine_decay_lr.html#mindspore.nn.cosine_decay_lr)                   |                                                                                                                          |
| [torch.optim.lr_scheduler.ExponentialLR](https://pytorch.org/docs/1.5.0/optim.html#torch.optim.lr_scheduler.ExponentialLR)                             | [mindspore.nn.exponential_decay_lr](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.exponential_decay_lr.html#mindspore.nn.exponential_decay_lr)    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/ExponentialDecayLR.html)  |
| [torch.optim.lr_scheduler.MultiStepLR](https://pytorch.org/docs/1.5.0/optim.html#torch.optim.lr_scheduler.MultiStepLR)                                 | [mindspore.nn.piecewise_constant_lr](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.piecewise_constant_lr.html#mindspore.nn.piecewise_constant_lr) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/PiecewiseConstantLR.html) |
| [torch.optim.lr_scheduler.StepLR](https://pytorch.org/docs/1.5.0/optim.html#torch.optim.lr_scheduler.StepLR)                                           | [mindspore.nn.piecewise_constant_lr](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.piecewise_constant_lr.html#mindspore.nn.piecewise_constant_lr) |                                                                                                                          |
| [torch.optim.Optimizer](https://pytorch.org/docs/1.5.0/optim.html#torch.optim.Optimizer)                                                               | [mindspore.nn.Optimizer](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Optimizer.html#mindspore.nn.Optimizer)                                     | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/Optimizer.html)           |
| [torch.optim.Optimizer.step](https://pytorch.org/docs/1.5.0/optim.html#torch.optim.Optimizer.step)                                                     | [mindspore.nn.TrainOneStepCell](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.TrainOneStepCell.html#mindspore.nn.TrainOneStepCell)                | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/TrainOneStepCell.html)    |
| [torch.optim.RMSprop](https://pytorch.org/docs/1.5.0/optim.html#torch.optim.RMSprop)                                                                   | [mindspore.nn.RMSProp](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.RMSProp.html#mindspore.nn.RMSProp)                                           |                                                                                                                          |
| [torch.optim.SGD](https://pytorch.org/docs/1.5.0/optim.html#torch.optim.SGD)                                                                           | [mindspore.nn.SGD](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.SGD.html#mindspore.nn.SGD)                                                       |                                                                                                                          |

## torch.Tensor

| PyTorch 1.5.0 APIs                                                                                     | MindSpore APIs                                                                                                                                                  | 说明                                                                                                              |
| ------------------------------------------------------------------------------------------------------ | --------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------- |
| [torch.repeat_interleave](https://pytorch.org/docs/1.5.0/tensors.html#torch.repeat_interleave)         | [mindspore.ops.repeat_elements](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.repeat_elements.html#mindspore.ops.repeat_elements)     |                                                                                                                   |
| [torch.BoolTensor.all](https://pytorch.org/docs/1.5.0/tensors.html#torch.BoolTensor.all)               | [mindspore.Tensor.all](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.all)                              |                                                                                                                   |
| [torch.BoolTensor.any](https://pytorch.org/docs/1.5.0/tensors.html#torch.BoolTensor.any)               | [mindspore.Tensor.any](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.any)                              |                                                                                                                   |
| [torch.minimum](https://pytorch.org/docs/1.9.0/generated/torch.minimum.html#torch.minimum)   | [mindspore.ops.Minimum](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Minimum.html#mindspore.ops.Minimum)                                     |                                                                                                                          |
| [torch.Tensor.abs](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.abs)                       | [mindspore.Tensor.abs](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.abs)                          |                                                                                                                   |
| [torch.Tensor.argmax](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.argmax)                 | [mindspore.Tensor.argmax](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.argmax)                       |                                                                                                                   |
| [torch.Tensor.argmin](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.argmin)                 | [mindspore.Tensor.argmin](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.argmin)                       |                                                                                                                   |
| [torch.Tensor.chunk](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.chunk)                   | [mindspore.ops.Split](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Split.html#mindspore.ops.Split)                                   |                                                                                                                   |
| [torch.Tensor.copy_](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.copy_)                   | [mindspore.Tensor.copy](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.copy)                           |                                                                                                                   |
| [torch.Tensor.cuda](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.cuda)                     | [mindspore.context.set_context](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore.context.html#mindspore.context.set_context)                        | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/cuda.html)         |
| [torch.Tensor.cumsum](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.cumsum)                 | [mindspore.Tensor.cumsum](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.cumsum)                       |                                                                                                                   |
| [torch.Tensor.diagonal](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.diagonal)             | [mindspore.Tensor.diagonal](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.diagonal)                   |                                                                                                                   |
| [torch.Tensor.dtype](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.dtype)                   | [mindspore.Tensor.dtype](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.dtype)                         |                                                                                                                   |
| [torch.Tensor.expand](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.expand)                 | [mindspore.ops.BroadcastTo](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.BroadcastTo.html#mindspore.ops.BroadcastTo)                 |                                                                                                                   |
| [torch.Tensor.expand_as](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.expand_as)           | [mindspore.Tensor.expand_as](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.expand_as)                  |                                                                                                                   |
| [torch.Tensor.fill_](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.fill_)                   | [mindspore.ops.Fill](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Fill.html#mindspore.ops.Fill)                                      |                                                                                                                   |
| [torch.Tensor.flatten](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.flatten)               | [mindspore.Tensor.flatten](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.flatten)                     |                                                                                                                   |
| [torch.Tensor.float](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.float)                   | [mindspore.ops.Cast](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Cast.html#mindspore.ops.Cast)                                      | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/Cast.html)         |
| [torch.Tensor.index_add](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.index_add)           | [mindspore.ops.InplaceAdd](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.InplaceAdd.html#mindspore.ops.InplaceAdd)                    |                                                                                                                   |
| [torch.Tensor.item](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.item)                     | [mindspore.Tensor.item](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.item)                        | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/item.html)         |
| [torch.Tensor.max](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.max)                       | [mindspore.Tensor.max](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.max)                             |                                                                                                                   |
| [torch.Tensor.mean](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.mean)                     | [mindspore.Tensor.mean](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.mean)                        |                                                                                                                   |
| [torch.Tensor.min](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.min)                       | [mindspore.Tensor.min](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.min)                             |                                                                                                                   |
| [torch.Tensor.mm](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.mm)                         | [mindspore.ops.MatMul](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.MatMul.html#mindspore.ops.MatMul)                                |                                                                                                                   |
| [torch.Tensor.mul](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.mul)                       | [mindspore.ops.Mul](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Mul.html#mindspore.ops.Mul)                                         |                                                                                                                   |
| [torch.Tensor.ndim](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.ndim)                     | [mindspore.Tensor.ndim](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.ndim)                           |                                                                                                                   |
| [torch.Tensor.new_full](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.new_full)             | [mindspore.numpy.full](https://mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.full.html#mindspore.numpy.full)                              |                                                                                                                   |
| [torch.Tensor.new_zeros](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.new_zeros)           | [mindspore.ops.Zeros](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Zeros.html#mindspore.ops.Zeros)                                   |                                                                                                                   |
| [torch.Tensor.norm](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.norm)                     | [mindspore.ops.LpNorm](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.LpNorm.html#mindspore.ops.LpNorm)                                   | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/LpNorm.html)                |
| [torch.Tensor.numpy](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.numpy)                   | [mindspore.Tensor.asnumpy](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.asnumpy)                     |                                                                                                                   |
| [torch.Tensor.pow](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.pow)                       | [mindspore.ops.Pow](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Pow.html#mindspore.ops.Pow)                                         |                                                                                                                   |
| [torch.Tensor.permute](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.permute)               | [mindspore.ops.Transpose](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Transpose.html#mindspore.ops.Transpose)                                |                                                                                                                   |
| [torch.Tensor.repeat](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.repeat)                 | [mindspore.numpy.tile](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/numpy/mindspore.numpy.tile.html#mindspore.numpy.tile)                          | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/npTile.html)       |
| [torch.Tensor.requires_grad_](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.requires_grad_) | [mindspore.Parameter.requires_grad](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Parameter.html#mindspore.Parameter.requires_grad) |                                                                                                                   |
| [torch.Tensor.reshape_as](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.reshape_as)         | [mindspore.tensor.reshape](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.reshape)                  |                                                                                                                   |
| [torch.Tensor.resize_](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.resize_)               | [mindspore.Tensor.resize](https://mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.resize)                        |                                                                                                                   |
| [torch.Tensor.round](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.round)                   | [mindspore.ops.Round](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Round.html#mindspore.ops.Round)                                   |                                                                                                                   |
| [torch.Tensor.scatter](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.scatter)               | [mindspore.ops.ScatterNd](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.ScatterNd.html#mindspore.ops.ScatterNd)                       |                                                                                                                   |
| [torch.Tensor.scatter_add_](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.scatter_add_)     | [mindspore.ops.ScatterNdAdd](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.ScatterNdAdd.html#mindspore.ops.ScatterNdAdd)              | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/ScatterNdAdd.html) |
| [torch.Tensor.sigmoid](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.sigmoid)               | [mindspore.nn.Sigmoid](https://mindspore.cn/docs/zh-CN/r1.7/api_python/nn/mindspore.nn.Sigmoid.html#mindspore.nn.Sigmoid)                                 |                                                                                                                   |
| [torch.Tensor.sign](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.sign)                     | [mindspore.ops.Sign](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Sign.html#mindspore.ops.Sign)                                      |                                                                                                                   |
| [torch.Tensor.size](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.size)                     | [mindspore.Tensor.shape](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.shape)                      |                                                                                                                   |
| [torch.Tensor.sqrt](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.sqrt)                     | [mindspore.ops.Sqrt](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Sqrt.html#mindspore.ops.Sqrt)                                      |                                                                                                                   |
| [torch.Tensor.stride](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.stride)                 | [mindspore.Tensor.strides](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.strides)                     | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/stride.html)       |
| [torch.Tensor.squeeze](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.squeeze)               | [mindspore.Tensor.squeeze](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.squeeze)                     |                                                                                                                   |
| [torch.Tensor.sub](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.sub)                       | [mindspore.ops.Sub](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Sub.html#mindspore.ops.Sub)                                         |                                                                                                                   |
| [torch.Tensor.sum](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.sum)                       | [mindspore.Tensor.sum](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.sum)                             | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/TensorSum.html) |
| [torch.Tensor.t](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.t)                           | [mindspore.ops.Transpose](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.Transpose.html#mindspore.ops.Transpose)                       | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/Transpose.html)    |
| [torch.Tensor.t](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.t)                           | [mindspore.Tensor.T](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.T)                              |                                                                                                                   |
| [torch.Tensor.take](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.take)                     | [mindspore.Tensor.take](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.take)                           |  [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/TensorTake.html) |
| [torch.Tensor.transpose](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.transpose)           | [mindspore.Tensor.transpose](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.transpose)              |                                                                                                                   |
| [torch.Tensor.unsqueeze](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.unsqueeze)           | [mindspore.ops.ExpandDims](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.ExpandDims.html#mindspore.ops.ExpandDims)                    |                                                                                                                   |
| [torch.Tensor.view](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.view)                     | [mindspore.Tensor.view](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.view)                        |                                                                                                                   |
| [torch.Tensor.view_as](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.view_as)               | [mindspore.Tensor.view](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/mindspore/mindspore.Tensor.html#mindspore.Tensor.view)                        |                                                                                                                   |
| [torch.Tensor.zero_](https://pytorch.org/docs/1.5.0/tensors.html#torch.Tensor.zero_)                   | [mindspore.ops.ZerosLike](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.ZerosLike.html#mindspore.ops.ZerosLike)                       |                                                                                                                   |

## torch.utils

| PyTorch 1.5.0 APIs                                                                                                                          | MindSpore APIs                                                                                                                                                                                | 说明                                                                                                                  |
| ------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------- |
| [torch.utils.data.DataLoader](https://pytorch.org/docs/1.5.0/data.html#torch.utils.data.DataLoader)                                         | None                                                                                                                                                                                          | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/DataLoader.html)       |
| [torch.utils.data.Dataset](https://pytorch.org/docs/1.5.0/data.html#torch.utils.data.Dataset)                                               | [mindspore.dataset.GeneratorDataset](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.GeneratorDataset.html#mindspore.dataset.GeneratorDataset)                | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/GeneratorDataset.html) |
| [torch.utils.data.distributed.DistributedSampler](https://pytorch.org/docs/1.5.0/data.html#torch.utils.data.distributed.DistributedSampler) | [mindspore.dataset.DistributedSampler](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.DistributedSampler.html#mindspore.dataset.DistributedSampler)          |                                                                                                                       |
| [torch.utils.data.RandomSampler](https://pytorch.org/docs/1.5.0/data.html#torch.utils.data.RandomSampler)                                   | [mindspore.dataset.RandomSampler](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.RandomSampler.html#mindspore.dataset.RandomSampler)                         |                                                                                                                       |
| [torch.utils.data.SequentialSampler](https://pytorch.org/docs/1.5.0/data.html#torch.utils.data.SequentialSampler)                           | [mindspore.dataset.SequentialSampler](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.SequentialSampler.html#mindspore.dataset.SequentialSampler)             |                                                                                                                       |
| [torch.utils.data.SubsetRandomSampler](https://pytorch.org/docs/1.5.0/data.html#torch.utils.data.SubsetRandomSampler)                       | [mindspore.dataset.SubsetRandomSampler](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.SubsetRandomSampler.html#mindspore.dataset.SubsetRandomSampler)       |                                                                                                                       |
| [torch.utils.data.WeightedRandomSampler](https://pytorch.org/docs/1.5.0/data.html#torch.utils.data.WeightedRandomSampler)                   | [mindspore.dataset.WeightedRandomSampler](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.WeightedRandomSampler.html#mindspore.dataset.WeightedRandomSampler) |                                                                                                                       |

## torchtext

| TorchText 0.10.0 APIs                                                                                                                                 | MindSpore APIs                                                                                                                                                                                                                                        | 说明                                                                                                                                   |
| ----------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------- |
| [torchtext.data.functional.custom_replace](https://pytorch.org/text/0.10.0/data_functional.html#custom-replace)                                       | [mindspore.dataset.text.transforms.RegexReplace](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_text/mindspore.dataset.text.transforms.RegexReplace.html#mindspore.dataset.text.transforms.RegexReplace)                               |                                                                                                                                        |
| [torchtext.data.functional.load_sp_model](https://pytorch.org/text/0.10.0/data_functional.html#load-sp-model)                                         | [mindspore.dataset.text.transforms.SentencePieceVocab](https://www.mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_text/mindspore.dataset.text.SentencePieceVocab.html#mindspore.dataset.text.SentencePieceVocab)                               | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/SentencePieceVocab.html)                |
| [torchtext.data.functional.numericalize_tokens_from_iterator](https://pytorch.org/text/0.10.0/data_functional.html#numericalize-tokens-from-iterator) | [mindspore.dataset.text.transforms.Lookup](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_text/mindspore.dataset.text.transforms.Lookup.html#mindspore.dataset.text.transforms.Lookup)                                                 | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/Lookup.html)                            |
| [torchtext.data.functional.sentencepiece_numericalizer](https://pytorch.org/text/0.10.0/data_functional.html#sentencepiece-numericalizer)             | [mindspore.dataset.text.transforms.SentencePieceTokenizer](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_text/mindspore.dataset.text.transforms.SentencePieceTokenizer.html#mindspore.dataset.text.transforms.SentencePieceTokenizer) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/SentencePieceTokenizer_Out_INT.html)    |
| [torchtext.data.functional.sentencepiece_tokenizer](https://pytorch.org/text/0.10.0/data_functional.html#sentencepiece-tokenizer)                     | [mindspore.dataset.text.transforms.SentencePieceTokenizer](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_text/mindspore.dataset.text.transforms.SentencePieceTokenizer.html#mindspore.dataset.text.transforms.SentencePieceTokenizer) | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/SentencePieceTokenizer_Out_STRING.html) |
| [torchtext.data.functional.simple_space_split](https://pytorch.org/text/0.10.0/data_functional.html#simple-space-split)                               | [mindspore.dataset.text.transforms.WhitespaceTokenizer](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_text/mindspore.dataset.text.transforms.WhitespaceTokenizer.html#mindspore.dataset.text.transforms.WhitespaceTokenizer)          |                                                                                                                                        |
| [torchtext.data.utils.ngrams_iterator](https://pytorch.org/text/0.10.0/data_utils.html#ngrams-iterator)                                               | [mindspore.dataset.text.transforms.Ngram](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_text/mindspore.dataset.text.transforms.Ngram.html#mindspore.dataset.text.transforms.Ngram)                                                    | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/Ngram.html)                             |

## torchvision

| TorchVision 0.10.0 APIs                                                                                                                    | MindSpore APIs                                                                                                                                                                                                                                                   | 说明                                                                                                                 |
| ------------------------------------------------------------------------------------------------------------------------------------------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------- |
| [torchvision.datasets.CelebA](https://pytorch.org/vision/0.10/datasets.html#torchvision.datasets.CelebA)                                   | [mindspore.dataset.CelebADataset](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.CelebADataset.html#mindspore.dataset.CelebADataset)                                                                                            |                                                                                                                      |
| [torchvision.datasets.CIFAR10](https://pytorch.org/vision/0.10/datasets.html#torchvision.datasets.CIFAR10)                                 | [mindspore.dataset.Cifar10Dataset](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.Cifar10Dataset.html#mindspore.dataset.Cifar10Dataset)                                                                                         |                                                                                                                      |
| [torchvision.datasets.CIFAR100](https://pytorch.org/vision/0.10/datasets.html#torchvision.datasets.CIFAR100)                               | [mindspore.dataset.Cifar100Dataset](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.Cifar100Dataset.html#mindspore.dataset.Cifar100Dataset)                                                                                      |                                                                                                                      |
| [torchvision.datasets.CocoDetection](https://pytorch.org/vision/0.10/datasets.html#torchvision.datasets.CocoDetection)                     | [mindspore.dataset.CocoDataset](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.CocoDataset.html#mindspore.dataset.CocoDataset)                                                                                                  | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/CocoDataset.html)     |
| [torchvision.datasets.ImageFolder](https://pytorch.org/vision/0.10/datasets.html#torchvision.datasets.ImageFolder)                         | [mindspore.dataset.ImageFolderDataset](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.ImageFolderDataset.html#mindspore.dataset.ImageFolderDataset)                                                                             |                                                                                                                      |
| [torchvision.datasets.MNIST](https://pytorch.org/vision/0.10/datasets.html#torchvision.datasets.MNIST)                                     | [mindspore.dataset.MnistDataset](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.MnistDataset.html#mindspore.dataset.MnistDataset)                                                                                               |                                                                                                                      |
| [torchvision.datasets.VOCDetection](https://pytorch.org/vision/0.10/datasets.html#torchvision.datasets.VOCDetection)                       | [mindspore.dataset.VOCDataset](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.VOCDataset.html#mindspore.dataset.VOCDataset)                                                                                                     | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/VOCDetection.html)    |
| [torchvision.datasets.VOCSegmentation](https://pytorch.org/vision/0.10/datasets.html#torchvision.datasets.VOCSegmentation)                 | [mindspore.dataset.VOCDataset](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset/mindspore.dataset.VOCDataset.html#mindspore.dataset.VOCDataset)                                                                                                     | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/VOCSegmentation.html) |
| [torchvision.ops.nms](https://pytorch.org/vision/0.10/ops.html#torchvision.ops.nms)                                                        | [mindspore.ops.NMSWithMask](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.NMSWithMask.html#mindspore.ops.NMSWithMask)                                                                                                                  |                                                                                                                      |
| [torchvision.ops.roi_align](https://pytorch.org/vision/0.10/ops.html#torchvision.ops.roi_align)                                            | [mindspore.ops.ROIAlign](https://mindspore.cn/docs/zh-CN/r1.7/api_python/ops/mindspore.ops.ROIAlign.html#mindspore.ops.ROIAlign)                                                                                                                           |                                                                                                                      |
| [torchvision.transforms.CenterCrop](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.CenterCrop)                     | [mindspore.dataset.vision.c_transforms.CenterCrop](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.CenterCrop.html#mindspore.dataset.vision.c_transforms.CenterCrop)                                  |                                                                                                                      |
| [torchvision.transforms.ColorJitter](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.ColorJitter)                   | [mindspore.dataset.vision.c_transforms.RandomColorAdjust](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.RandomColorAdjust.html#mindspore.dataset.vision.c_transforms.RandomColorAdjust)             |                                                                                                                      |
| [torchvision.transforms.Compose](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.Compose)                           | [mindspore.dataset.transforms.c_transforms.Compose](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_transforms/mindspore.dataset.transforms.c_transforms.Compose.html#mindspore.dataset.transforms.c_transforms.Compose)                           |                                                                                                                      |
| [torchvision.transforms.ConvertImageDtype](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.ConvertImageDtype)       | [mindspore.dataset.vision.py_transforms.ToType](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.py_transforms.ToType.html#mindspore.dataset.vision.py_transforms.ToType)                                           | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/ToType.html)          |
| [torchvision.transforms.FiveCrop](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.FiveCrop)                         | [mindspore.dataset.vision.py_transforms.FiveCrop](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.py_transforms.FiveCrop.html#mindspore.dataset.vision.py_transforms.FiveCrop)                                     |                                                                                                                      |
| [torchvision.transforms.GaussianBlur](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.GaussianBlur)                 | [mindspore.dataset.vision.c_transforms.GaussianBlur](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.GaussianBlur.html#mindspore.dataset.vision.c_transforms.GaussianBlur)                            |                                                                                                                      |
| [torchvision.transforms.Grayscale](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.Grayscale)                       | [mindspore.dataset.vision.py_transforms.Grayscale](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.py_transforms.Grayscale.html#mindspore.dataset.vision.py_transforms.Grayscale)                                  |                                                                                                                      |
| [torchvision.transforms.LinearTransformation](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.LinearTransformation) | [mindspore.dataset.vision.py_transforms.LinearTransformation](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.py_transforms.LinearTransformation.html#mindspore.dataset.vision.py_transforms.LinearTransformation) |                                                                                                                      |
| [torchvision.transforms.Normalize](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.Normalize)                       | [mindspore.dataset.vision.c_transforms.Normalize](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.Normalize.html#mindspore.dataset.vision.c_transforms.Normalize)                                     |                                                                                                                      |
| [torchvision.transforms.Pad](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.Pad)                                   | [mindspore.dataset.vision.c_transforms.Pad](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.Pad.html#mindspore.dataset.vision.c_transforms.Pad)                                                       |                                                                                                                      |
| [torchvision.transforms.RandomAffine](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomAffine)                 | [mindspore.dataset.vision.c_transforms.RandomAffine](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.RandomAffine.html#mindspore.dataset.vision.c_transforms.RandomAffine)                            |                                                                                                                      |
| [torchvision.transforms.RandomApply](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomApply)                   | [mindspore.dataset.transforms.c_transforms.RandomApply](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_transforms/mindspore.dataset.transforms.c_transforms.RandomApply.html#mindspore.dataset.transforms.c_transforms.RandomApply)               |                                                                                                                      |
| [torchvision.transforms.RandomChoice](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomChoice)                 | [mindspore.dataset.transforms.c_transforms.RandomChoice](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_transforms/mindspore.dataset.transforms.c_transforms.RandomChoice.html#mindspore.dataset.transforms.c_transforms.RandomChoice)            |                                                                                                                      |
| [torchvision.transforms.RandomCrop](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomCrop)                     | [mindspore.dataset.vision.c_transforms.RandomCrop](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.RandomCrop.html#mindspore.dataset.vision.c_transforms.RandomCrop)                                  |                                                                                                                      |
| [torchvision.transforms.RandomErasing](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomErasing)               | [mindspore.dataset.vision.py_transforms.RandomErasing](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.py_transforms.RandomErasing.html#mindspore.dataset.vision.py_transforms.RandomErasing)                      |                                                                                                                      |
| [torchvision.transforms.RandomGrayscale](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomGrayscale)           | [mindspore.dataset.vision.py_transforms.RandomGrayscale](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.py_transforms.RandomGrayscale.html#mindspore.dataset.vision.py_transforms.RandomGrayscale)                |                                                                                                                      |
| [torchvision.transforms.RandomHorizontalFlip](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomHorizontalFlip) | [mindspore.dataset.vision.c_transforms.RandomHorizontalFlip](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.RandomHorizontalFlip.html#mindspore.dataset.vision.c_transforms.RandomHorizontalFlip)    |                                                                                                                      |
| [torchvision.transforms.RandomOrder](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomOrder)                   | [mindspore.dataset.transforms.py_transforms.RandomOrder](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_transforms/mindspore.dataset.transforms.py_transforms.RandomOrder.html#mindspore.dataset.transforms.py_transforms.RandomOrder)            |                                                                                                                      |
| [torchvision.transforms.RandomPerspective](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomPerspective)       | [mindspore.dataset.vision.py_transforms.RandomPerspective](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.py_transforms.RandomPerspective.html#mindspore.dataset.vision.py_transforms.RandomPerspective)          |                                                                                                                      |
| [torchvision.transforms.RandomPosterize](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomPosterize)           | [mindspore.dataset.vision.c_transforms.RandomPosterize](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.RandomPosterize.html#mindspore.dataset.vision.c_transforms.RandomPosterize)                   |                                                                                                                      |
| [torchvision.transforms.RandomResizedCrop](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomResizedCrop)       | [mindspore.dataset.vision.c_transforms.RandomResizedCrop](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.RandomResizedCrop.html#mindspore.dataset.vision.c_transforms.RandomResizedCrop)             |                                                                                                                      |
| [torchvision.transforms.RandomRotation](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomRotation)             | [mindspore.dataset.vision.c_transforms.RandomRotation](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.RandomRotation.html#mindspore.dataset.vision.c_transforms.RandomRotation)                      |                                                                                                                      |
| [torchvision.transforms.RandomSolarize](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomSolarize)             | [mindspore.dataset.vision.c_transforms.RandomSolarize](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.RandomSolarize.html#mindspore.dataset.vision.c_transforms.RandomSolarize)                      | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/RandomSolarize.html)  |
| [torchvision.transforms.RandomVerticalFlip](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.RandomVerticalFlip)     | [mindspore.dataset.vision.c_transforms.RandomVerticalFlip](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.RandomVerticalFlip.html#mindspore.dataset.vision.c_transforms.RandomVerticalFlip)          |                                                                                                                      |
| [torchvision.transforms.Resize](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.Resize)                             | [mindspore.dataset.vision.c_transforms.Resize](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.c_transforms.Resize.html#mindspore.dataset.vision.c_transforms.Resize)                                              |                                                                                                                      |
| [torchvision.transforms.TenCrop](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.TenCrop)                           | [mindspore.dataset.vision.py_transforms.TenCrop](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.py_transforms.TenCrop.html#mindspore.dataset.vision.py_transforms.TenCrop)                                        |                                                                                                                      |
| [torchvision.transforms.ToPILImage](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.ToPILImage)                     | [mindspore.dataset.vision.py_transforms.ToPIL](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.py_transforms.ToPIL.html#mindspore.dataset.vision.py_transforms.ToPIL)                                              | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/ToPIL.html)           |
| [torchvision.transforms.ToTensor](https://pytorch.org/vision/0.10/transforms.html#torchvision.transforms.ToTensor)                         | [mindspore.dataset.vision.py_transforms.ToTensor](https://mindspore.cn/docs/zh-CN/r1.7/api_python/dataset_vision/mindspore.dataset.vision.py_transforms.ToTensor.html#mindspore.dataset.vision.py_transforms.ToTensor)                                     | [差异对比](https://www.mindspore.cn/docs/zh-CN/r1.7/note/api_mapping/pytorch_diff/ToTensor.html)        |
