/*
 * Decompiled with CFR 0.152.
 */
package com.mindspore.ide.toolkit.services.filter;

import com.intellij.codeInsight.lookup.LookupElement;
import com.mindspore.ide.toolkit.services.complete.MindSporeLookupElement;
import com.mindspore.ide.toolkit.services.filter.AbstractFilter;
import com.mindspore.ide.toolkit.services.filter.FilterContext;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class RepeatFilter
extends AbstractFilter {
    private static final int REPEAT_FILTER_ORDER = 10;

    @Override
    public int getOrder() {
        return 10;
    }

    @Override
    protected void doFilter(FilterContext filterContext) {
        Set<LookupElement> smartCompleteResult = filterContext.getSmartResults();
        LinkedHashSet sameCompleteResult = new LinkedHashSet();
        Set<LookupElement> myProcessResults = filterContext.getMyProcessResults();
        if (smartCompleteResult.isEmpty()) {
            return;
        }
        smartCompleteResult.removeIf(smartResult -> this.compareAndExtractResult((Collection<LookupElement>)myProcessResults, sameCompleteResult, (LookupElement)smartResult));
        List sameLookupElementStrList = sameCompleteResult.stream().map(sameElement -> sameElement.getLookupString().trim()).collect(Collectors.toList());
        myProcessResults.removeIf(myElement -> sameLookupElementStrList.contains(myElement.getLookupString().trim()));
        filterContext.getElementSet().addAll(sameCompleteResult);
    }

    private boolean compareAndExtractResult(Collection<LookupElement> myProcessResults, Collection<LookupElement> sameCompleteResult, LookupElement smartResult) {
        boolean isContain = myProcessResults.stream().anyMatch(myProcessResult -> myProcessResult.getLookupString().trim().equals(smartResult.getLookupString().trim()));
        if (isContain) {
            MindSporeLookupElement msLookupElement = new MindSporeLookupElement(smartResult, MindSporeLookupElement.DataType.BOTH_IN_MINDSPORE_AND_JETBRAINS);
            sameCompleteResult.add(msLookupElement);
        }
        return isContain;
    }
}

