/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.services;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.Context;
import io.grpc.ExperimentalApi;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/6012")
@ThreadSafe
public final class CallMetricRecorder {
    private static final CallMetricRecorder NOOP = new CallMetricRecorder().disable();
    static final Context.Key<CallMetricRecorder> CONTEXT_KEY = Context.key((String)"io.grpc.services.CallMetricRecorder");
    private final AtomicReference<ConcurrentHashMap<String, Double>> metrics = new AtomicReference();
    private volatile boolean disabled;

    CallMetricRecorder() {
    }

    public static CallMetricRecorder getCurrent() {
        CallMetricRecorder recorder = (CallMetricRecorder)CONTEXT_KEY.get();
        return recorder != null ? recorder : NOOP;
    }

    public CallMetricRecorder recordCallMetric(String name, double value) {
        if (this.disabled) {
            return this;
        }
        if (this.metrics.get() == null) {
            this.metrics.compareAndSet(null, new ConcurrentHashMap());
        }
        this.metrics.get().put(name, value);
        return this;
    }

    Map<String, Double> finalizeAndDump() {
        this.disabled = true;
        Map savedMetrics = this.metrics.get();
        if (savedMetrics == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(savedMetrics);
    }

    @VisibleForTesting
    boolean isDisabled() {
        return this.disabled;
    }

    private CallMetricRecorder disable() {
        this.disabled = true;
        return this;
    }
}

