/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.alts.GoogleDefaultChannelBuilder;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsInitializationException;
import io.grpc.xds.XdsLogger;
import java.util.List;
import java.util.concurrent.TimeUnit;

abstract class XdsChannelFactory {
    @VisibleForTesting
    static boolean experimentalV3SupportEnvVar = Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_V3_SUPPORT"));
    private static final String XDS_V3_SERVER_FEATURE = "xds_v3";
    private static final XdsChannelFactory DEFAULT_INSTANCE = new XdsChannelFactory(){

        @Override
        XdsClient.XdsChannel createChannel(List<Bootstrapper.ServerInfo> servers) throws XdsInitializationException {
            if (servers.isEmpty()) {
                throw new XdsInitializationException("No server provided");
            }
            XdsLogger logger = XdsLogger.withPrefix("xds-client-channel-factory");
            Bootstrapper.ServerInfo serverInfo = servers.get(0);
            String serverUri = serverInfo.getServerUri();
            logger.log(XdsLogger.XdsLogLevel.INFO, "Creating channel to {0}", serverUri);
            List<Bootstrapper.ChannelCreds> channelCredsList = serverInfo.getChannelCredentials();
            GoogleDefaultChannelBuilder channelBuilder = null;
            for (Bootstrapper.ChannelCreds creds : channelCredsList) {
                switch (creds.getType()) {
                    case "google_default": {
                        logger.log(XdsLogger.XdsLogLevel.INFO, "Using channel credentials: google_default");
                        channelBuilder = GoogleDefaultChannelBuilder.forTarget(serverUri);
                        break;
                    }
                    case "insecure": {
                        logger.log(XdsLogger.XdsLogLevel.INFO, "Using channel credentials: insecure");
                        channelBuilder = ManagedChannelBuilder.forTarget((String)serverUri).usePlaintext();
                        break;
                    }
                    case "tls": {
                        logger.log(XdsLogger.XdsLogLevel.INFO, "Using channel credentials: tls");
                        channelBuilder = ManagedChannelBuilder.forTarget((String)serverUri);
                        break;
                    }
                }
                if (channelBuilder == null) continue;
                break;
            }
            if (channelBuilder == null) {
                throw new XdsInitializationException("No server with supported channel creds found");
            }
            ManagedChannel channel = channelBuilder.keepAliveTime(5L, TimeUnit.MINUTES).build();
            boolean useProtocolV3 = experimentalV3SupportEnvVar && serverInfo.getServerFeatures().contains(XdsChannelFactory.XDS_V3_SERVER_FEATURE);
            return new XdsClient.XdsChannel(channel, useProtocolV3);
        }
    };

    XdsChannelFactory() {
    }

    static XdsChannelFactory getInstance() {
        return DEFAULT_INSTANCE;
    }

    abstract XdsClient.XdsChannel createChannel(List<Bootstrapper.ServerInfo> var1) throws XdsInitializationException;
}

