/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.data;

import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKeyAggregator;
import com.vladsch.flexmark.util.data.DataKeyBase;
import com.vladsch.flexmark.util.data.DataValueFactory;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSet
implements DataHolder {
    protected final HashMap<DataKeyBase<?>, Object> dataSet;
    private static final ArrayList<DataKeyAggregator> ourDataKeyAggregators = new ArrayList();

    public DataSet() {
        this(null);
    }

    public DataSet(@Nullable DataHolder other) {
        this.dataSet = other == null ? new HashMap() : new HashMap(other.getAll());
    }

    @NotNull
    public static DataHolder aggregateActions(@NotNull DataHolder other, @NotNull DataHolder overrides) {
        DataSet combined = new DataSet(other);
        combined.dataSet.putAll(overrides.getAll());
        for (DataKeyAggregator combiner : ourDataKeyAggregators) {
            combined = combiner.aggregateActions(combined, other, overrides).toDataSet();
        }
        return combined;
    }

    @NotNull
    public DataHolder aggregate() {
        DataHolder combined = this;
        for (DataKeyAggregator combiner : ourDataKeyAggregators) {
            combined = combiner.aggregate(combined);
        }
        return combined;
    }

    @NotNull
    public static DataHolder aggregate(@Nullable DataHolder other, @Nullable DataHolder overrides) {
        if (other == null && overrides == null) {
            return new DataSet();
        }
        if (overrides == null) {
            return other;
        }
        if (other == null) {
            return overrides.toDataSet().aggregate().toImmutable();
        }
        return DataSet.aggregateActions(other, overrides).toDataSet().aggregate().toImmutable();
    }

    @Override
    @NotNull
    public Map<? extends DataKeyBase<?>, Object> getAll() {
        return this.dataSet;
    }

    @Override
    @NotNull
    public Collection<? extends DataKeyBase<?>> getKeys() {
        return this.dataSet.keySet();
    }

    @Override
    public boolean contains(@NotNull DataKeyBase<?> key) {
        return this.dataSet.containsKey(key);
    }

    @Override
    @Nullable
    public Object getOrCompute(@NotNull DataKeyBase<?> key, @NotNull DataValueFactory<?> factory) {
        if (this.dataSet.containsKey(key)) {
            return this.dataSet.get(key);
        }
        return factory.apply(this);
    }

    @NotNull
    public static DataSet merge(DataHolder ... dataHolders) {
        DataSet dataSet = new DataSet();
        for (DataHolder dataHolder : dataHolders) {
            dataSet.dataSet.putAll(dataHolder.getAll());
        }
        return dataSet;
    }

    @Override
    @NotNull
    public MutableDataSet toMutable() {
        return new MutableDataSet(this);
    }

    @Override
    @NotNull
    public DataSet toImmutable() {
        return this;
    }

    @Override
    @NotNull
    public DataSet toDataSet() {
        return this;
    }

    public static void registerDataKeyAggregator(@NotNull DataKeyAggregator keyAggregator) {
        if (DataSet.isAggregatorRegistered(keyAggregator)) {
            throw new IllegalStateException("Aggregator " + keyAggregator + " is already registered");
        }
        for (int i = 0; i < ourDataKeyAggregators.size(); ++i) {
            DataKeyAggregator aggregator = ourDataKeyAggregators.get(i);
            if (!DataSet.invokeSetContains(aggregator.invokeAfterSet(), keyAggregator)) continue;
            if (DataSet.invokeSetContains(keyAggregator.invokeAfterSet(), aggregator)) {
                throw new IllegalStateException("Circular invokeAfter dependencies for " + keyAggregator + " and " + aggregator);
            }
            ourDataKeyAggregators.add(i, keyAggregator);
            return;
        }
        ourDataKeyAggregators.add(keyAggregator);
    }

    static boolean isAggregatorRegistered(@NotNull DataKeyAggregator keyAggregator) {
        for (DataKeyAggregator aggregator : ourDataKeyAggregators) {
            if (aggregator.getClass() != keyAggregator.getClass()) continue;
            return true;
        }
        return false;
    }

    static boolean invokeSetContains(@Nullable Set<Class<?>> invokeSet, @NotNull DataKeyAggregator aggregator) {
        if (invokeSet == null) {
            return false;
        }
        return invokeSet.contains(aggregator.getClass());
    }

    public String toString() {
        return "DataSet{dataSet=" + this.dataSet + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataSet)) {
            return false;
        }
        DataSet set = (DataSet)o;
        return this.dataSet.equals(set.dataSet);
    }

    public int hashCode() {
        return this.dataSet.hashCode();
    }
}

